/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

final class DefaultSettingsContext
implements Context,
NameParser {
    private final DataObject dobj;
    private final Hashtable env;

    public DefaultSettingsContext(DataObject dataObject) {
        this.dobj = dataObject;
        this.env = new Hashtable();
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        return null;
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        String string = this.getRelativeName(name);
        FileObject fileObject = this.dobj.getPrimaryFile();
        Object object2 = fileObject.getAttribute(string);
        if (object2 != null) {
            throw new NameAlreadyBoundException(string + " = " + object2);
        }
        try {
            fileObject.setAttribute(string, object);
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException(string + " = " + object);
            namingException.setRootCause(iOException);
        }
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.bind(this.parse(string), object);
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return ".";
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this;
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return this;
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.list(this.parse(string));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("name cannot be null");
        }
        int n = name.size();
        if (n == 0) {
            throw new InvalidNameException("name cannot be empty");
        }
        if (n > 1 || !".".equals(name.get(0))) {
            throw new InvalidNameException("subcontexts unsupported: " + name);
        }
        return new BindingEnumeration(this.dobj.getPrimaryFile());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        return this.list(string);
    }

    @Override
    public Object lookup(String string) throws NamingException {
        return this.lookup(this.parse(string));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        String string = this.getRelativeName(name);
        return this.dobj.getPrimaryFile().getAttribute(string);
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.lookupLink(this.parse(string));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        String string = this.getRelativeName(name);
        FileObject fileObject = this.dobj.getPrimaryFile();
        try {
            fileObject.setAttribute(string, object);
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException(name + " = " + object);
            namingException.setRootCause(iOException);
        }
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.rebind(this.parse(string), object);
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        return null;
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        String string = this.getRelativeName(name);
        String string2 = this.getRelativeName(name2);
        FileObject fileObject = this.dobj.getPrimaryFile();
        Object object = fileObject.getAttribute(string2);
        if (object != null) {
            throw new NameAlreadyBoundException(string2 + " = " + object);
        }
        try {
            object = fileObject.getAttribute(string);
            fileObject.setAttribute(string2, object);
            fileObject.setAttribute(string, null);
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException(name + "->" + name2);
            namingException.setRootCause(iOException);
        }
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.rename(this.parse(string), this.parse(string2));
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.unbind(this.parse(string));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        String string = this.getRelativeName(name);
        FileObject fileObject = this.dobj.getPrimaryFile();
        if (fileObject.getAttribute(string) == null) {
            NameNotFoundException nameNotFoundException = new NameNotFoundException();
            nameNotFoundException.setResolvedName(name);
            throw nameNotFoundException;
        }
        try {
            fileObject.setAttribute(string, null);
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException();
            namingException.setResolvedName(name);
            namingException.setRootCause(iOException);
        }
    }

    @Override
    public Name parse(String string) throws NamingException {
        if (string == null) {
            throw new InvalidNameException("name cannot be null");
        }
        return new CompositeName(string);
    }

    private String getRelativeName(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("name cannot be null");
        }
        if (name.isEmpty()) {
            throw new InvalidNameException("name cannot be empty");
        }
        String string = null;
        Enumeration<String> enumeration = name.getAll();
        while (enumeration.hasMoreElements()) {
            if (string == null) {
                String string2 = enumeration.nextElement();
                if (".".equals(string2)) continue;
                if ("..".equals(string2)) {
                    throw new InvalidNameException("subcontexts unsupported: " + name);
                }
                string = string2;
                continue;
            }
            throw new InvalidNameException("subcontexts unsupported: " + name);
        }
        return string;
    }

    public String toString() {
        String string = super.toString();
        return string + '[' + this.dobj + ']';
    }

    private static final class BindingEnumeration
    implements NamingEnumeration<Binding> {
        private final Enumeration<String> en;
        private final FileObject fo;

        public BindingEnumeration(FileObject fileObject) {
            this.fo = fileObject;
            this.en = fileObject.getAttributes();
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public boolean hasMoreElements() {
            return this.en.hasMoreElements();
        }

        @Override
        public Binding next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public Binding nextElement() {
            String string = this.en.nextElement();
            Object object = this.fo.getAttribute(string);
            return new Binding(string, object);
        }
    }
}

