﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appmesh/AppMeshRequest.h>
#include <aws/appmesh/AppMesh_EXPORTS.h>
#include <aws/appmesh/model/TagRef.h>
#include <aws/appmesh/model/VirtualRouterSpec.h>
#include <aws/core/utils/UUID.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace AppMesh {
namespace Model {

/**
 * <zonbook></zonbook><xhtml></xhtml><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualRouterInput">AWS
 * API Reference</a></p>
 */
class CreateVirtualRouterRequest : public AppMeshRequest {
 public:
  AWS_APPMESH_API CreateVirtualRouterRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateVirtualRouter"; }

  AWS_APPMESH_API Aws::String SerializePayload() const override;

  AWS_APPMESH_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency
   * of the request. Up to 36 letters, numbers, hyphens, and underscores are
   * allowed.</p>
   */
  inline const Aws::String& GetClientToken() const { return m_clientToken; }
  inline bool ClientTokenHasBeenSet() const { return m_clientTokenHasBeenSet; }
  template <typename ClientTokenT = Aws::String>
  void SetClientToken(ClientTokenT&& value) {
    m_clientTokenHasBeenSet = true;
    m_clientToken = std::forward<ClientTokenT>(value);
  }
  template <typename ClientTokenT = Aws::String>
  CreateVirtualRouterRequest& WithClientToken(ClientTokenT&& value) {
    SetClientToken(std::forward<ClientTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the service mesh to create the virtual router in.</p>
   */
  inline const Aws::String& GetMeshName() const { return m_meshName; }
  inline bool MeshNameHasBeenSet() const { return m_meshNameHasBeenSet; }
  template <typename MeshNameT = Aws::String>
  void SetMeshName(MeshNameT&& value) {
    m_meshNameHasBeenSet = true;
    m_meshName = std::forward<MeshNameT>(value);
  }
  template <typename MeshNameT = Aws::String>
  CreateVirtualRouterRequest& WithMeshName(MeshNameT&& value) {
    SetMeshName(std::forward<MeshNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Web Services IAM account ID of the service mesh owner. If the
   * account ID is not your own, then the account that you specify must share the
   * mesh with your account before you can create the resource in the service mesh.
   * For more information about mesh sharing, see <a
   * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working
   * with shared meshes</a>.</p>
   */
  inline const Aws::String& GetMeshOwner() const { return m_meshOwner; }
  inline bool MeshOwnerHasBeenSet() const { return m_meshOwnerHasBeenSet; }
  template <typename MeshOwnerT = Aws::String>
  void SetMeshOwner(MeshOwnerT&& value) {
    m_meshOwnerHasBeenSet = true;
    m_meshOwner = std::forward<MeshOwnerT>(value);
  }
  template <typename MeshOwnerT = Aws::String>
  CreateVirtualRouterRequest& WithMeshOwner(MeshOwnerT&& value) {
    SetMeshOwner(std::forward<MeshOwnerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The virtual router specification to apply.</p>
   */
  inline const VirtualRouterSpec& GetSpec() const { return m_spec; }
  inline bool SpecHasBeenSet() const { return m_specHasBeenSet; }
  template <typename SpecT = VirtualRouterSpec>
  void SetSpec(SpecT&& value) {
    m_specHasBeenSet = true;
    m_spec = std::forward<SpecT>(value);
  }
  template <typename SpecT = VirtualRouterSpec>
  CreateVirtualRouterRequest& WithSpec(SpecT&& value) {
    SetSpec(std::forward<SpecT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Optional metadata that you can apply to the virtual router to assist with
   * categorization and organization. Each tag consists of a key and an optional
   * value, both of which you define. Tag keys can have a maximum character length of
   * 128 characters, and tag values can have a maximum length of 256 characters.</p>
   */
  inline const Aws::Vector<TagRef>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Vector<TagRef>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Vector<TagRef>>
  CreateVirtualRouterRequest& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsT = TagRef>
  CreateVirtualRouterRequest& AddTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace_back(std::forward<TagsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name to use for the virtual router.</p>
   */
  inline const Aws::String& GetVirtualRouterName() const { return m_virtualRouterName; }
  inline bool VirtualRouterNameHasBeenSet() const { return m_virtualRouterNameHasBeenSet; }
  template <typename VirtualRouterNameT = Aws::String>
  void SetVirtualRouterName(VirtualRouterNameT&& value) {
    m_virtualRouterNameHasBeenSet = true;
    m_virtualRouterName = std::forward<VirtualRouterNameT>(value);
  }
  template <typename VirtualRouterNameT = Aws::String>
  CreateVirtualRouterRequest& WithVirtualRouterName(VirtualRouterNameT&& value) {
    SetVirtualRouterName(std::forward<VirtualRouterNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_clientToken{Aws::Utils::UUID::PseudoRandomUUID()};

  Aws::String m_meshName;

  Aws::String m_meshOwner;

  VirtualRouterSpec m_spec;

  Aws::Vector<TagRef> m_tags;

  Aws::String m_virtualRouterName;
  bool m_clientTokenHasBeenSet = true;
  bool m_meshNameHasBeenSet = false;
  bool m_meshOwnerHasBeenSet = false;
  bool m_specHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_virtualRouterNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppMesh
}  // namespace Aws
