/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.util.HashSet;
import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeToClassVisitor;
import proguard.classfile.attribute.visitor.InstructionToAttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.editor.MemberAdder;
import proguard.classfile.editor.MemberRemover;
import proguard.classfile.editor.SimplifiedClassEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.InitializerMethodFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCollector;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.optimize.peephole.InstructionSequencesReplacer;
import proguard.optimize.peephole.PeepholeOptimizer;
import proguard.util.MultiValueMap;

public class StaticInterfaceMethodConverter
extends SimplifiedVisitor
implements ClassVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final MultiValueMap<String, String> injectedClassNameMap;
    private final ClassVisitor modifiedClassVisitor;
    private final MemberVisitor extraMemberVisitor;

    public StaticInterfaceMethodConverter(ClassPool programClassPool, ClassPool libraryClassPool, MultiValueMap<String, String> injectedClassNameMap, ClassVisitor modifiedClassVisitor, MemberVisitor extraMemberVisitor) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.injectedClassNameMap = injectedClassNameMap;
        this.modifiedClassVisitor = modifiedClassVisitor;
        this.extraMemberVisitor = extraMemberVisitor;
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        HashSet<String> staticMethods = new HashSet<String>();
        programClass.accept(new AllMethodVisitor(new MemberAccessFilter(8, 0, new InitializerMethodFilter(null, new MemberCollector(false, true, true, staticMethods)))));
        if (!staticMethods.isEmpty()) {
            ProgramClass utilityClass = this.createUtilityClass(programClass);
            MemberVisitor memberAdder = new MemberAdder(utilityClass);
            if (this.extraMemberVisitor != null) {
                memberAdder = new MultiMemberVisitor(memberAdder, this.extraMemberVisitor);
            }
            MemberRemover memberRemover = new MemberRemover();
            programClass.accept(new AllMethodVisitor(new MemberAccessFilter(8, 0, new InitializerMethodFilter(null, new MultiMemberVisitor(memberAdder, memberRemover)))));
            this.programClassPool.addClass(utilityClass);
            this.injectedClassNameMap.put(programClass.getName(), utilityClass.getName());
            this.replaceInstructions(programClass, utilityClass, staticMethods);
            utilityClass.accept(new MultiClassVisitor(new ClassSuperHierarchyInitializer(this.programClassPool, this.libraryClassPool), new ClassReferenceInitializer(this.programClassPool, this.libraryClassPool)));
            programClass.accept(new MultiClassVisitor(memberRemover, new ConstantPoolShrinker()));
        }
    }

    private ProgramClass createUtilityClass(ProgramClass interfaceClazz) {
        ProgramClass utilityClass = new ProgramClass(0x2E0000, 1, new Constant[10], 4097, 0, 0);
        String utilityClassName = interfaceClazz.getName() + "$$Util";
        ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(utilityClass, this.programClassPool, this.libraryClassPool);
        utilityClass.u2thisClass = constantPoolEditor.addClassConstant(utilityClassName, utilityClass);
        utilityClass.u2superClass = constantPoolEditor.addClassConstant("java/lang/Object", null);
        SimplifiedClassEditor classEditor = new SimplifiedClassEditor(utilityClass);
        classEditor.addMethod(2, "<init>", "()V", 10).aload_0().invokespecial("java/lang/Object", "<init>", "()V").return_();
        classEditor.finishEditing();
        return utilityClass;
    }

    private void replaceInstructions(ProgramClass interfaceClass, ProgramClass utilityClass, Set<String> staticMethods) {
        InstructionSequenceBuilder ____ = new InstructionSequenceBuilder(this.programClassPool, this.libraryClassPool);
        Instruction[][][] instructions = new Instruction[staticMethods.size()][][];
        int index = 0;
        for (String staticMethod : staticMethods) {
            String[] splitArray = staticMethod.split("\\.");
            String methodName = splitArray[0];
            String methodDesc = splitArray[1];
            Instruction[][] replacement = new Instruction[][]{____.invokestatic_interface(interfaceClass.getName(), methodName, methodDesc).__(), ____.invokestatic(utilityClass.getName(), methodName, methodDesc).__()};
            instructions[index++] = replacement;
        }
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        InstructionToAttributeVisitor updatedClassVisitor = new InstructionToAttributeVisitor(new AttributeToClassVisitor(this.modifiedClassVisitor));
        this.programClassPool.classesAccept(new MyReferencedClassFilter(interfaceClass, new AllMethodVisitor(new AllAttributeVisitor(new PeepholeOptimizer(codeAttributeEditor, new InstructionSequencesReplacer(____.constants(), instructions, null, codeAttributeEditor, (InstructionVisitor)updatedClassVisitor))))));
    }

    private static class MyReferencedClassFilter
    extends SimplifiedVisitor
    implements ClassVisitor,
    ConstantVisitor {
        private final Clazz referencedClass;
        private final ClassVisitor classVisitor;
        private boolean referenceClassFound;

        public MyReferencedClassFilter(Clazz referencedClass, ClassVisitor classVisitor) {
            this.referencedClass = referencedClass;
            this.classVisitor = classVisitor;
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            this.referenceClassFound = false;
            programClass.constantPoolEntriesAccept(this);
            if (this.referenceClassFound) {
                programClass.accept(this.classVisitor);
            }
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            if (refConstant.referencedClass == this.referencedClass) {
                this.referenceClassFound = true;
            }
        }
    }
}

