/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.TextOption;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;

public class ClientOptions
extends OptionGroup {
    private static final Logger logger = Logger.getLogger(ClientOptions.class.getName());
    public static final String TAG = "clientOptions";
    private static final String PERSONAL_GROUP = "clientOptions.personal";
    public static final String NAME = "model.option.playerName";
    public static final String LANGUAGE = "model.option.languageOption";
    public static final String AUTOMATIC = "clientOptions.gui.languageOption.autoDetectLanguage";
    private static final String GUI_GROUP = "clientOptions.gui";
    private static final String DISPLAY_GROUP = "clientOptions.display";
    public static final String DISPLAY_SCALING = "model.option.displayScaling";
    public static final String MANUAL_MAIN_FONT_SIZE = "model.option.manualMainFontSize";
    public static final String MAIN_FONT_SIZE = "model.option.mainFontSize";
    public static final String USE_PIXMAPS = "model.option.usePixmaps";
    public static final String USE_OPENGL = "model.option.useOpenGL";
    public static final String USE_XRENDER = "model.option.useXRender";
    public static final String USE_TERRAIN_ANIMATIONS = "model.option.useTerrainAnimations";
    public static final String GRAPHICS_QUALITY = "model.option.graphicsQuality";
    public static final int GRAPHICS_QUALITY_LOWEST = 0;
    public static final int GRAPHICS_QUALITY_LOW = 10;
    public static final int GRAPHICS_QUALITY_NORMAL = 20;
    public static final int GRAPHICS_QUALITY_HIGH = 30;
    public static final int GRAPHICS_QUALITY_HIGHEST = 40;
    public static final String MOVE_ANIMATION_SPEED = "model.option.moveAnimationSpeed";
    public static final String ENEMY_MOVE_ANIMATION_SPEED = "model.option.enemyMoveAnimationSpeed";
    public static final String FRIENDLY_MOVE_ANIMATION_SPEED = "model.option.friendlyMoveAnimationSpeed";
    private static final String INTERFACE_GROUP = "clientOptions.interface";
    private static final String MAPVIEW_GROUP = "clientOptions.interface.mapView";
    public static final String DEFAULT_ZOOM_LEVEL = "model.option.defaultZoomLevel";
    public static final String ALWAYS_CENTER = "model.option.alwaysCenter";
    public static final String JUMP_TO_ACTIVE_UNIT = "model.option.jumpToActiveUnit";
    public static final String MAP_SCROLL_ON_DRAG = "model.option.mapScrollOnDrag";
    public static final String AUTO_SCROLL = "model.option.autoScroll";
    public static final String DISPLAY_GRID = "model.option.displayGrid";
    public static final String DISPLAY_BORDERS = "model.option.displayBorders";
    public static final String DISPLAY_FOG_OF_WAR = "model.option.displayFogOfWar";
    public static final String UNIT_LAST_MOVE_DELAY = "model.option.unitLastMoveDelay";
    public static final String DISPLAY_TILE_TEXT = "model.option.displayTileText";
    public static final int DISPLAY_TILE_TEXT_EMPTY = 0;
    public static final int DISPLAY_TILE_TEXT_NAMES = 1;
    public static final int DISPLAY_TILE_TEXT_OWNERS = 2;
    public static final int DISPLAY_TILE_TEXT_REGIONS = 3;
    public static final String DISPLAY_COLONY_LABELS = "model.option.displayColonyLabels";
    public static final int COLONY_LABELS_NONE = 0;
    public static final int COLONY_LABELS_CLASSIC = 1;
    public static final int COLONY_LABELS_MODERN = 2;
    private static final String MAPCONTROLS_GROUP = "clientOptions.interface.mapControls";
    public static final String DISPLAY_COMPASS_ROSE = "model.option.displayCompassRose";
    public static final String DISPLAY_MAP_CONTROLS = "model.option.displayMapControls";
    public static final String MAP_CONTROLS = "model.option.mapControls";
    public static final String MAP_CONTROLS_CORNERS = "clientOptions.gui.mapControls.CornerMapControls";
    public static final String MAP_CONTROLS_CLASSIC = "clientOptions.gui.mapControls.ClassicMapControls";
    public static final String MINIMAP_TOGGLE_FOG_OF_WAR = "model.option.miniMapToggleFogOfWar";
    public static final String MINIMAP_TOGGLE_BORDERS = "model.option.miniMapToggleBorders";
    public static final String MINIMAP_BACKGROUND_COLOR = "model.option.color.background";
    private static final String MESSAGES_GROUP = "clientOptions.messages";
    public static final String MESSAGES_GROUP_BY = "model.option.guiMessagesGroupBy";
    public static final int MESSAGES_GROUP_BY_NOTHING = 0;
    public static final int MESSAGES_GROUP_BY_TYPE = 1;
    public static final int MESSAGES_GROUP_BY_SOURCE = 2;
    public static final String SHOW_GOODS_MOVEMENT = "model.option.guiShowGoodsMovement";
    public static final String SHOW_COLONY_WARNINGS = "model.option.guiShowColonyWarnings";
    public static final String SHOW_PRECOMBAT = "model.option.guiShowPreCombat";
    public static final String SHOW_NOT_BEST_TILE = "model.option.guiShowNotBestTile";
    public static final String SHOW_REGION_NAMING = "model.option.guiShowRegionNaming";
    public static final String COLONY_REPORT = "model.option.colonyReport";
    public static final int COLONY_REPORT_CLASSIC = 0;
    public static final int COLONY_REPORT_COMPACT = 1;
    public static final String LABOUR_REPORT = "model.option.labourReport";
    public static final int LABOUR_REPORT_CLASSIC = 0;
    public static final int LABOUR_REPORT_COMPACT = 1;
    private static final String WAREHOUSE_GROUP = "clientOptions.warehouse";
    public static final String CUSTOM_STOCK = "model.option.customStock";
    public static final String LOW_LEVEL = "model.option.lowLevel";
    public static final String HIGH_LEVEL = "model.option.highLevel";
    public static final String STOCK_ACCOUNTS_FOR_PRODUCTION = "model.option.stockAccountsForProduction";
    private static final String OTHER_GROUP = "clientOptions.other";
    public static final String REMEMBER_PANEL_POSITIONS = "model.option.rememberPanelPositions";
    public static final String REMEMBER_PANEL_SIZES = "model.option.rememberPanelSizes";
    public static final String DISABLE_GRAY_LAYER = "model.option.disableGrayLayer";
    public static final String AUTOLOAD_EMIGRANTS = "model.option.autoloadEmigrants";
    public static final String AUTOLOAD_SENTRIES = "model.option.autoloadSentries";
    public static final String AUTO_END_TURN = "model.option.autoEndTurn";
    public static final String SHOW_END_TURN_DIALOG = "model.option.showEndTurnDialog";
    public static final String INDIAN_DEMAND_RESPONSE = "model.option.indianDemandResponse";
    public static final int INDIAN_DEMAND_RESPONSE_ASK = 0;
    public static final int INDIAN_DEMAND_RESPONSE_ACCEPT = 1;
    public static final int INDIAN_DEMAND_RESPONSE_REJECT = 2;
    public static final String UNLOAD_OVERFLOW_RESPONSE = "model.option.unloadOverflowResponse";
    public static final int UNLOAD_OVERFLOW_RESPONSE_ASK = 0;
    public static final int UNLOAD_OVERFLOW_RESPONSE_NEVER = 1;
    public static final int UNLOAD_OVERFLOW_RESPONSE_ALWAYS = 2;
    public static final String MIN_NUMBER_FOR_DISPLAYING_GOODS_COUNT = "model.option.guiMinNumberToDisplayGoodsCount";
    public static final String MAX_NUMBER_OF_GOODS_IMAGES = "model.option.guiMaxNumberOfGoodsImages";
    public static final String MIN_NUMBER_FOR_DISPLAYING_GOODS = "model.option.guiMinNumberToDisplayGoods";
    public static final String COLONY_COMPARATOR = "model.option.colonyComparator";
    public static final int COLONY_COMPARATOR_NAME = 0;
    public static final int COLONY_COMPARATOR_AGE = 1;
    public static final int COLONY_COMPARATOR_POSITION = 2;
    public static final int COLONY_COMPARATOR_SIZE = 3;
    public static final int COLONY_COMPARATOR_SOL = 4;
    private static final String SAVEGAMES_GROUP = "clientOptions.savegames";
    public static final String SHOW_SAVEGAME_SETTINGS = "model.option.showSavegameSettings";
    public static final int SHOW_SAVEGAME_SETTINGS_NEVER = 0;
    public static final int SHOW_SAVEGAME_SETTINGS_MULTIPLAYER = 1;
    public static final int SHOW_SAVEGAME_SETTINGS_ALWAYS = 2;
    public static final String AUTOSAVE_PERIOD = "model.option.autosavePeriod";
    public static final String AUTOSAVE_VALIDITY = "model.option.autosaveValidity";
    public static final String AUTOSAVE_DELETE = "model.option.autosaveDelete";
    public static final String CONFIRM_SAVE_OVERWRITE = "model.option.confirmSaveOverwrite";
    public static final String AUTO_SAVE_PREFIX = "model.option.autoSavePrefix";
    public static final String LAST_TURN_NAME = "model.option.lastTurnName";
    public static final String BEFORE_LAST_TURN_NAME = "model.option.beforeLastTurnName";
    private static final String AUDIO_GROUP = "clientOptions.audio";
    public static final String AUDIO_MIXER = "model.option.audioMixer";
    public static final String AUDIO_VOLUME = "model.option.audioVolume";
    public static final String MUSIC_VOLUME = "model.option.musicVolume";
    public static final String SOUND_EFFECTS_VOLUME = "model.option.soundEffectsVolume";
    public static final String AUDIO_ALERTS = "model.option.audioAlerts";
    public static final String USER_MODS = "clientOptions.mods.userMods";
    public static final String ETC = "clientOptions.etc";
    private static final List<String> specialKeys = CollectionUtils.makeUnmodifiableList("model.option.languageOption", "model.option.useOpenGL", "model.option.usePixmaps", "model.option.useXRender");
    private static final Comparator<Colony> colonyAgeComparator = Comparator.comparingInt(c -> c.getEstablished().getNumber());
    private static AtomicReference<Comparator<Colony>> colonyNameComparator = new AtomicReference<Object>(null);
    private static final Comparator<Colony> colonySizeComparator = Comparator.comparingInt(Colony::getUnitCount).thenComparingInt(Colony::getSonsOfLiberty).reversed();
    private static final Comparator<Colony> colonySoLComparator = Comparator.comparingInt(Colony::getSonsOfLiberty).thenComparingInt(Colony::getUnitCount).reversed();
    private static final Comparator<Colony> colonyPositionComparator = Comparator.comparingInt(c -> Location.rankOf(c));
    private static final Map<Integer, String> friendlyMoveAnimationSpeeds = CollectionUtils.makeUnmodifiableMap(new Integer[]{0, 1, 2, 3}, new String[]{"clientOptions.gui.friendlyMoveAnimationSpeed.off", "clientOptions.gui.friendlyMoveAnimationSpeed.slow", "clientOptions.gui.friendlyMoveAnimationSpeed.normal", "clientOptions.gui.friendlyMoveAnimationSpeed.fast"});
    private static final Map<Integer, String> graphicsQualityChoices = CollectionUtils.makeUnmodifiableMap(new Integer[]{0, 10, 20, 30, 40}, new String[]{"clientOptions.gui.graphicsQuality.lowest", "clientOptions.gui.graphicsQuality.low", "clientOptions.gui.graphicsQuality.normal", "clientOptions.gui.graphicsQuality.high", "clientOptions.gui.graphicsQuality.highest"});

    public ClientOptions() {
        super(TAG);
    }

    private boolean load(FreeColSavegameFile save) {
        if (save == null) {
            return false;
        }
        boolean ret = false;
        try (FreeColXMLReader xr = save.getClientOptionsFreeColXMLReader();){
            ret = this.load(xr);
        }
        catch (IOException | XMLStreamException ex) {
            logger.log(Level.WARNING, "Load OptionGroup(" + this.getId() + ") from file " + save.getPath() + " crashed", ex);
            return false;
        }
        logger.info("Load OptionGroup(" + this.getId() + ") from " + save.getPath() + (ret ? " succeeded" : " failed"));
        return ret;
    }

    public boolean merge(File file) {
        ClientOptions clop = new ClientOptions();
        if (!clop.load(file)) {
            return false;
        }
        LogBuilder lb = new LogBuilder(64);
        boolean ret = this.merge(clop, lb);
        lb.shrink("\n");
        lb.log(logger, Level.FINEST);
        return ret;
    }

    public boolean merge(FreeColSavegameFile save) {
        ClientOptions clop = new ClientOptions();
        if (!clop.load(save)) {
            return false;
        }
        LogBuilder lb = new LogBuilder(64);
        boolean ret = this.merge(clop.getOption(USER_MODS), lb);
        lb.shrink("\n");
        lb.log(logger, Level.FINEST);
        return ret;
    }

    public List<FreeColModFile> getActiveMods() {
        Predicate<FreeColModFile> validModPred = m -> m != null && m.getId() != null;
        Function<FreeColModFile, FreeColModFile> modFileMapper = m -> FreeColModFile.getFreeColModFile(m.getId());
        return CollectionUtils.transform(this.getModList(USER_MODS), validModPred, modFileMapper, CollectionUtils.toListNoNulls());
    }

    public int getDisplayTileText() {
        return this.getInteger(DISPLAY_TILE_TEXT);
    }

    public Comparator<Colony> getColonyComparator() {
        return ClientOptions.getColonyComparatorInternal(this.getInteger(COLONY_COMPARATOR));
    }

    private static Comparator<Colony> getColonyComparatorInternal(int type) {
        switch (type) {
            case 1: {
                return colonyAgeComparator;
            }
            case 2: {
                return colonyPositionComparator;
            }
            case 3: {
                return colonySizeComparator;
            }
            case 4: {
                return colonySoLComparator;
            }
            case 0: {
                Comparator<Colony> cnc = colonyNameComparator.get();
                if (cnc == null) {
                    cnc = Comparator.comparing(Settlement::getName, Collator.getInstance(FreeCol.getLocale()));
                    colonyNameComparator.set(cnc);
                }
                return cnc;
            }
        }
        throw new RuntimeException("Unknown comparator: " + type);
    }

    public Comparator<ModelMessage> getModelMessageComparator(Game game) {
        switch (this.getInteger(MESSAGES_GROUP_BY)) {
            case 2: {
                HashMap specialized = new HashMap();
                specialized.put("Colony", this.getColonyComparator());
                return ModelMessage.getSourceComparator(game, specialized);
            }
            case 1: {
                return ModelMessage.messageTypeComparator;
            }
        }
        return null;
    }

    public boolean isRiverAnimationEnabled() {
        return this.isTerrainAnimationsEnabled() && this.getRange(GRAPHICS_QUALITY) >= 20;
    }

    public boolean isTerrainAnimationsEnabled() {
        return this.getBoolean(USE_TERRAIN_ANIMATIONS) && this.getRange(GRAPHICS_QUALITY) >= 10;
    }

    public void fixClientOptions() {
        this.addBooleanOption(MINIMAP_TOGGLE_BORDERS, GUI_GROUP, true);
        this.addBooleanOption(MINIMAP_TOGGLE_FOG_OF_WAR, GUI_GROUP, true);
        this.addTextOption(AUTO_SAVE_PREFIX, SAVEGAMES_GROUP, "Autosave");
        this.addTextOption(LAST_TURN_NAME, SAVEGAMES_GROUP, "last-turn");
        this.addTextOption(BEFORE_LAST_TURN_NAME, SAVEGAMES_GROUP, "before-last-turn");
        this.addBooleanOption(STOCK_ACCOUNTS_FOR_PRODUCTION, WAREHOUSE_GROUP, false);
        this.addBooleanOption(AUTOLOAD_SENTRIES, OTHER_GROUP, false);
        try {
            RangeOption ro = this.getOption(DEFAULT_ZOOM_LEVEL, RangeOption.class);
            if (ro.getItemValues().size() != 6) {
                Integer value = ro.getValue();
                ro.clearItemValues();
                ro.addItemValue(1, "1");
                ro.addItemValue(2, "2");
                ro.addItemValue(3, "3");
                ro.addItemValue(4, "4");
                ro.addItemValue(5, "5");
                ro.addItemValue(6, "6");
                ro.setValue(value);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to fix model.option.defaultZoomLevel option", e);
        }
        this.addBooleanOption(SHOW_REGION_NAMING, MESSAGES_GROUP, true);
        this.addBooleanOption("model.option.guiShowCombatResult", MESSAGES_GROUP, true);
        this.addBooleanOption("model.option.guiShowUnitRepaired", MESSAGES_GROUP, true);
        this.addBooleanOption("model.option.guiShowUnitArrived", MESSAGES_GROUP, true);
        this.addBooleanOption("model.option.guiShowDisasters", MESSAGES_GROUP, true);
        this.addBooleanOption(USE_OPENGL, GUI_GROUP, true);
        this.addBooleanOption(USE_XRENDER, GUI_GROUP, true);
        this.addRangeOption(FRIENDLY_MOVE_ANIMATION_SPEED, GUI_GROUP, 3, friendlyMoveAnimationSpeeds);
        this.regroup(LANGUAGE, PERSONAL_GROUP);
        this.addOptionGroup(DISPLAY_GROUP, TAG);
        this.addIntegerOption(DISPLAY_SCALING, DISPLAY_GROUP, 0);
        this.addBooleanOption(MANUAL_MAIN_FONT_SIZE, DISPLAY_GROUP, false);
        this.addIntegerOption(MAIN_FONT_SIZE, DISPLAY_GROUP, 12);
        for (String n : new String[]{USE_PIXMAPS, USE_OPENGL, USE_XRENDER, MOVE_ANIMATION_SPEED, ENEMY_MOVE_ANIMATION_SPEED, FRIENDLY_MOVE_ANIMATION_SPEED}) {
            this.regroup(n, DISPLAY_GROUP);
        }
        this.addOptionGroup(INTERFACE_GROUP, TAG);
        this.addOptionGroup(MAPVIEW_GROUP, INTERFACE_GROUP);
        for (String n : new String[]{DEFAULT_ZOOM_LEVEL, ALWAYS_CENTER, JUMP_TO_ACTIVE_UNIT, MAP_SCROLL_ON_DRAG, AUTO_SCROLL, DISPLAY_GRID, DISPLAY_BORDERS, UNIT_LAST_MOVE_DELAY, DISPLAY_TILE_TEXT, DISPLAY_COLONY_LABELS}) {
            this.regroup(n, MAPVIEW_GROUP);
        }
        this.addOptionGroup(MAPCONTROLS_GROUP, INTERFACE_GROUP);
        for (String n : new String[]{DISPLAY_COMPASS_ROSE, DISPLAY_MAP_CONTROLS, MINIMAP_TOGGLE_FOG_OF_WAR, MINIMAP_TOGGLE_BORDERS, MINIMAP_BACKGROUND_COLOR}) {
            this.regroup(n, MAPCONTROLS_GROUP);
        }
        this.regroup(MESSAGES_GROUP, INTERFACE_GROUP);
        this.regroup(WAREHOUSE_GROUP, INTERFACE_GROUP);
        this.regroup(OTHER_GROUP, INTERFACE_GROUP);
        this.addBooleanOption(DISPLAY_FOG_OF_WAR, MAPCONTROLS_GROUP, false);
        this.addRangeOption(GRAPHICS_QUALITY, DISPLAY_GROUP, 20, graphicsQualityChoices);
        this.addBooleanOption(USE_TERRAIN_ANIMATIONS, DISPLAY_GROUP, true);
        this.addPercentageOption(MUSIC_VOLUME, AUDIO_GROUP, 100);
        this.addPercentageOption(SOUND_EFFECTS_VOLUME, AUDIO_GROUP, 100);
        this.remove(MAP_CONTROLS);
        RangeOption op = this.getOption(DISPLAY_SCALING, RangeOption.class);
        if (!op.getItemValues().containsKey(75)) {
            op.setItemValueAtIndex(1, 75, "model.option.displayScaling.75");
        }
    }

    private void addPercentageOption(String id, String gr, int val) {
        if (!this.hasOption(id, PercentageOption.class)) {
            PercentageOption op = new PercentageOption(id, null);
            op.setGroup(gr);
            op.setValue(val);
            this.add(op);
        }
    }

    private void addBooleanOption(String id, String gr, boolean val) {
        if (!this.hasOption(id, BooleanOption.class)) {
            BooleanOption op = new BooleanOption(id, null);
            op.setGroup(gr);
            op.setValue(val);
            this.add(op);
        }
    }

    private void addIntegerOption(String id, String gr, int val) {
        if (!this.hasOption(id, IntegerOption.class)) {
            IntegerOption op = new IntegerOption(id, null);
            op.setGroup(gr);
            op.setValue(val);
            this.add(op);
        }
    }

    private void addOptionGroup(String id, String gr) {
        if (!this.hasOption(id, OptionGroup.class)) {
            OptionGroup og = new OptionGroup(id);
            og.setGroup(gr);
            this.add(og);
        }
    }

    private void addRangeOption(String id, String gr, int rank, Map<Integer, String> entries) {
        if (!this.hasOption(id, RangeOption.class)) {
            RangeOption op = new RangeOption(id, null);
            op.setGroup(gr);
            op.clearItemValues();
            for (Map.Entry<Integer, String> e : entries.entrySet()) {
                op.addItemValue(e.getKey(), e.getValue());
            }
            op.setValueRank(rank);
            this.add(op);
        }
    }

    private void addTextOption(String id, String gr, String val) {
        if (!this.hasOption(id, TextOption.class)) {
            TextOption op = new TextOption(id, null);
            op.setGroup(gr);
            op.setValue(val);
            this.add(op);
        }
    }

    private void regroup(String id, String gr) {
        Option op = this.getOption(id);
        if (op != null) {
            op.setGroup(gr);
        }
    }

    public Point getPanelPosition(String className) {
        OptionGroup etc = this.getOptionGroup(ETC);
        try {
            return etc == null ? null : new Point(etc.getInteger(className + ".x"), etc.getInteger(className + ".y"));
        }
        catch (Exception ex) {
            logger.finest("Missing position option for " + className);
            return null;
        }
    }

    public Dimension getPanelSize(String className) {
        OptionGroup etc = this.getOptionGroup(ETC);
        try {
            return etc == null ? null : new Dimension(etc.getInteger(className + ".w"), etc.getInteger(className + ".h"));
        }
        catch (Exception ex) {
            logger.finest("Missing size option for " + className);
            return null;
        }
    }

    public static Map<String, String> getSpecialOptions() throws FreeColException {
        HashMap<String, String> ret = new HashMap<String, String>(specialKeys.size());
        for (String key : specialKeys) {
            ret.put(key, null);
        }
        File optionsFile = FreeColDirectories.getClientOptionsFile();
        try (FreeColXMLReader xr = new FreeColXMLReader(optionsFile);){
            xr.readAttributeValues(ret, "value");
        }
        catch (IOException | XMLStreamException xe) {
            throw new FreeColException(xe);
        }
        return ret;
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

