/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.Suppliers;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaParameterizedType;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.JavaTypeVariable;
import com.tngtech.archunit.core.domain.JavaWildcardType;
import com.tngtech.archunit.core.domain.properties.HasAnnotations;
import com.tngtech.archunit.thirdparty.com.google.common.base.Predicates;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;

class JavaClassDependencies {
    private final JavaClass javaClass;
    private final Supplier<Set<Dependency>> directDependenciesFromClass;

    JavaClassDependencies(JavaClass javaClass) {
        this.javaClass = javaClass;
        this.directDependenciesFromClass = this.createDirectDependenciesFromClassSupplier();
    }

    private Supplier<Set<Dependency>> createDirectDependenciesFromClassSupplier() {
        return Suppliers.memoize(() -> Streams.concat(this.dependenciesFromAccesses(this.javaClass.getAccessesFromSelf()), this.inheritanceDependenciesFromSelf(), this.fieldDependenciesFromSelf(), this.returnTypeDependenciesFromSelf(), this.codeUnitParameterDependenciesFromSelf(), this.throwsDeclarationDependenciesFromSelf(), this.annotationDependenciesFromSelf(), this.instanceofCheckDependenciesFromSelf(), this.referencedClassObjectDependenciesFromSelf(), this.typeParameterDependenciesFromSelf()).collect(ImmutableSet.toImmutableSet()));
    }

    Set<Dependency> getDirectDependenciesFromClass() {
        return this.directDependenciesFromClass.get();
    }

    private Stream<Dependency> dependenciesFromAccesses(Set<JavaAccess<?>> accesses) {
        return accesses.stream().flatMap(access -> Dependency.tryCreateFromAccess(access).stream());
    }

    private Stream<Dependency> inheritanceDependenciesFromSelf() {
        Stream<Dependency> rawInheritanceDependencies = Stream.concat(this.javaClass.getRawInterfaces().stream(), this.javaClass.getRawSuperclass().map(Stream::of).orElse(Stream.empty())).map(supertype -> Dependency.fromInheritance(this.javaClass, supertype));
        Stream<Dependency> genericInheritanceDependencies = Stream.concat(this.genericSuperclassTypeArgumentDependencies(), this.genericInterfaceTypeArgumentDependencies());
        return Stream.concat(rawInheritanceDependencies, genericInheritanceDependencies);
    }

    private Stream<Dependency> genericSuperclassTypeArgumentDependencies() {
        if (!this.javaClass.getSuperclass().isPresent() || !(this.javaClass.getSuperclass().get() instanceof JavaParameterizedType)) {
            return Stream.empty();
        }
        JavaParameterizedType genericSuperclass = (JavaParameterizedType)this.javaClass.getSuperclass().get();
        return this.dependenciesOfTypes(genericSuperclass.getActualTypeArguments()).flatMap(superclassTypeArgumentDependency -> Dependency.tryCreateFromGenericSuperclassTypeArguments(this.javaClass, genericSuperclass, superclassTypeArgumentDependency).stream());
    }

    private Stream<Dependency> genericInterfaceTypeArgumentDependencies() {
        return JavaClassDependencies.getGenericInterfacesOf(this.javaClass).flatMap(genericInterface -> this.dependenciesOfTypes(genericInterface.getActualTypeArguments()).flatMap(interfaceTypeArgumentDependency -> Dependency.tryCreateFromGenericInterfaceTypeArgument(this.javaClass, genericInterface, interfaceTypeArgumentDependency).stream()));
    }

    private static Stream<JavaParameterizedType> getGenericInterfacesOf(JavaClass javaClass) {
        return javaClass.getInterfaces().stream().filter(Predicates.instanceOf(JavaParameterizedType.class)).map(type -> (JavaParameterizedType)type);
    }

    private Stream<Dependency> fieldDependenciesFromSelf() {
        return this.javaClass.getFields().stream().flatMap(field -> Stream.concat(Dependency.tryCreateFromField(field).stream(), this.genericFieldTypeArgumentDependencies((JavaField)field)));
    }

    private Stream<Dependency> genericFieldTypeArgumentDependencies(JavaField field) {
        if (!(field.getType() instanceof JavaParameterizedType)) {
            return Stream.empty();
        }
        JavaParameterizedType fieldType = (JavaParameterizedType)field.getType();
        return this.dependenciesOfTypes(fieldType.getActualTypeArguments()).flatMap(fieldTypeArgumentDependency -> Dependency.tryCreateFromGenericFieldTypeArgument(field, fieldTypeArgumentDependency).stream());
    }

    private Stream<Dependency> returnTypeDependenciesFromSelf() {
        return this.javaClass.getMethods().stream().flatMap(method -> Stream.concat(Dependency.tryCreateFromReturnType(method).stream(), this.genericReturnTypeArgumentDependencies((JavaMethod)method)));
    }

    private Stream<Dependency> genericReturnTypeArgumentDependencies(JavaMethod method) {
        if (!(method.getReturnType() instanceof JavaParameterizedType)) {
            return Stream.empty();
        }
        JavaParameterizedType returnType = (JavaParameterizedType)method.getReturnType();
        return this.dependenciesOfTypes(returnType.getActualTypeArguments()).flatMap(returnTypeArgumentDependency -> Dependency.tryCreateFromGenericMethodReturnTypeArgument(method, returnTypeArgumentDependency).stream());
    }

    private Stream<Dependency> codeUnitParameterDependenciesFromSelf() {
        return this.javaClass.getCodeUnits().stream().flatMap(codeUnit -> Stream.concat(this.rawParameterTypeDependencies((JavaCodeUnit)codeUnit), this.genericParameterTypeArgumentDependencies((JavaCodeUnit)codeUnit)));
    }

    private Stream<Dependency> rawParameterTypeDependencies(JavaCodeUnit codeUnit) {
        return codeUnit.getRawParameterTypes().stream().flatMap(parameter -> Dependency.tryCreateFromParameter(codeUnit, parameter).stream());
    }

    private Stream<Dependency> genericParameterTypeArgumentDependencies(JavaCodeUnit codeUnit) {
        return codeUnit.getParameterTypes().stream().filter(parameterType -> parameterType instanceof JavaParameterizedType).flatMap(parameterType -> JavaClassDependencies.dependenciesOfParameterizedType((JavaParameterizedType)parameterType).flatMap(parameterTypeDependency -> Dependency.tryCreateFromGenericCodeUnitParameterTypeArgument(codeUnit, parameterType, parameterTypeDependency).stream()));
    }

    private Stream<Dependency> throwsDeclarationDependenciesFromSelf() {
        return this.javaClass.getThrowsDeclarations().stream().flatMap(throwsDeclaration -> Dependency.tryCreateFromThrowsDeclaration(throwsDeclaration).stream());
    }

    private Stream<Dependency> annotationDependenciesFromSelf() {
        return Streams.concat(this.annotationDependencies(this.javaClass), this.annotationDependencies((HasDescription & HasAnnotations<?>)this.javaClass.getFields()), this.annotationDependencies((HasDescription & HasAnnotations<?>)this.javaClass.getMethods()), this.parameterAnnotationDependencies(this.javaClass.getMethods()), this.annotationDependencies((HasDescription & HasAnnotations<?>)this.javaClass.getConstructors()), this.parameterAnnotationDependencies(this.javaClass.getConstructors()));
    }

    private Stream<Dependency> instanceofCheckDependenciesFromSelf() {
        return this.javaClass.getInstanceofChecks().stream().flatMap(instanceofCheck -> Dependency.tryCreateFromInstanceofCheck(instanceofCheck).stream());
    }

    private Stream<Dependency> referencedClassObjectDependenciesFromSelf() {
        return this.javaClass.getReferencedClassObjects().stream().flatMap(referencedClassObject -> Dependency.tryCreateFromReferencedClassObject(referencedClassObject).stream());
    }

    private Stream<Dependency> typeParameterDependenciesFromSelf() {
        return Stream.concat(this.classTypeParameterDependenciesFromSelf(), this.codeUnitTypeParameterDependenciesFromSelf());
    }

    private Stream<Dependency> classTypeParameterDependenciesFromSelf() {
        return this.javaClass.getTypeParameters().stream().flatMap(this::getDependenciesFromTypeParameter);
    }

    private Stream<Dependency> codeUnitTypeParameterDependenciesFromSelf() {
        return this.javaClass.getCodeUnits().stream().flatMap(codeUnit -> codeUnit.getTypeParameters().stream()).flatMap(this::getDependenciesFromTypeParameter);
    }

    private Stream<Dependency> getDependenciesFromTypeParameter(JavaTypeVariable<?> typeVariable) {
        return this.dependenciesOfTypes(typeVariable.getUpperBounds()).flatMap(typeParameterDependency -> Dependency.tryCreateFromTypeParameter(typeVariable, typeParameterDependency).stream());
    }

    private Stream<JavaClass> dependenciesOfTypes(Collection<JavaType> types) {
        return types.stream().flatMap(JavaClassDependencies::dependenciesOfType);
    }

    private static Stream<JavaClass> dependenciesOfType(JavaType javaType) {
        if (javaType instanceof JavaClass) {
            return Stream.of((JavaClass)javaType);
        }
        if (javaType instanceof JavaParameterizedType) {
            return JavaClassDependencies.dependenciesOfParameterizedType((JavaParameterizedType)javaType);
        }
        if (javaType instanceof JavaWildcardType) {
            return JavaClassDependencies.dependenciesOfWildcardType((JavaWildcardType)javaType);
        }
        return Stream.empty();
    }

    private static Stream<JavaClass> dependenciesOfParameterizedType(JavaParameterizedType parameterizedType) {
        return Stream.concat(Stream.of(parameterizedType.toErasure()), parameterizedType.getActualTypeArguments().stream().flatMap(JavaClassDependencies::dependenciesOfType));
    }

    private static Stream<JavaClass> dependenciesOfWildcardType(JavaWildcardType javaType) {
        return Stream.concat(javaType.getUpperBounds().stream(), javaType.getLowerBounds().stream()).flatMap(JavaClassDependencies::dependenciesOfType);
    }

    private Stream<Dependency> parameterAnnotationDependencies(Set<? extends JavaCodeUnit> codeUnits) {
        return codeUnits.stream().flatMap(codeUnit -> this.annotationDependencies((HasDescription & HasAnnotations<?>)codeUnit.getParameters()));
    }

    private <T extends HasDescription & HasAnnotations<?>> Stream<Dependency> annotationDependencies(Collection<T> annotatedObjects) {
        return annotatedObjects.stream().flatMap(x$0 -> this.annotationDependencies((HasDescription)x$0));
    }

    private <T extends HasDescription & HasAnnotations<?>> Stream<Dependency> annotationDependencies(T annotated) {
        final Stream.Builder addToStream = Stream.builder();
        for (final JavaAnnotation<?> annotation : ((HasAnnotations<?>)annotated).getAnnotations()) {
            Dependency.tryCreateFromAnnotation(annotation).forEach(addToStream);
            annotation.accept(new JavaAnnotation.DefaultParameterVisitor(){

                @Override
                public void visitClass(String propertyName, JavaClass javaClass) {
                    Dependency.tryCreateFromAnnotationMember(annotation, javaClass).forEach(addToStream);
                }

                @Override
                public void visitEnumConstant(String propertyName, JavaEnumConstant enumConstant) {
                    Dependency.tryCreateFromAnnotationMember(annotation, enumConstant.getDeclaringClass()).forEach(addToStream);
                }

                @Override
                public void visitAnnotation(String propertyName, JavaAnnotation<?> memberAnnotation) {
                    Dependency.tryCreateFromAnnotationMember(annotation, memberAnnotation.getRawType()).forEach(addToStream);
                    memberAnnotation.accept(this);
                }
            });
        }
        return addToStream.build();
    }
}

