/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os;

import com.jogamp.common.os.DynamicLinker;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.util.LongObjectHashMap;
import com.jogamp.common.util.SecurityUtil;

abstract class DynamicLinkerImpl
implements DynamicLinker {
    private final Object secSync = new Object();
    private boolean allLinkPermissionGranted = false;
    private static final LongObjectHashMap libHandle2Name = new LongObjectHashMap(16);

    DynamicLinkerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void claimAllLinkPermission() throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            this.allLinkPermissionGranted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void releaseAllLinkPermission() throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            this.allLinkPermissionGranted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkLinkPermission(String string) throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            if (!this.allLinkPermissionGranted) {
                SecurityUtil.checkLinkPermission(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkLinkPermission(long l) throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            if (!this.allLinkPermissionGranted) {
                LibRef libRef = this.getLibRef(l);
                if (null == libRef) {
                    throw new IllegalArgumentException("Library handle 0x" + Long.toHexString(l) + " unknown.");
                }
                SecurityUtil.checkLinkPermission(libRef.getLibPath().path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkAllLinkPermission() throws SecurityException {
        Object object = this.secSync;
        synchronized (object) {
            if (!this.allLinkPermissionGranted) {
                SecurityUtil.checkAllLinkPermission();
            }
        }
    }

    @Override
    public long openLibraryGlobal(NativeLibrary.LibPath libPath, boolean bl) throws SecurityException {
        this.checkLinkPermission(libPath.path);
        long l = this.openLibraryGlobalImpl(libPath);
        if (0L != l) {
            LibRef libRef = this.incrLibRefCount(l, libPath);
            if (DEBUG || bl) {
                System.err.println("DynamicLinkerImpl.openLibraryGlobal \"" + libPath + "\": 0x" + Long.toHexString(l) + " -> " + libRef + ")");
            }
        } else if (DEBUG || bl) {
            System.err.println("DynamicLinkerImpl.openLibraryGlobal \"" + libPath + "\" failed, error: " + this.getLastError());
        }
        return l;
    }

    protected abstract long openLibraryGlobalImpl(NativeLibrary.LibPath var1) throws SecurityException;

    @Override
    public final long openLibraryLocal(NativeLibrary.LibPath libPath, boolean bl) throws SecurityException {
        this.checkLinkPermission(libPath.path);
        long l = this.openLibraryLocalImpl(libPath);
        if (0L != l) {
            LibRef libRef = this.incrLibRefCount(l, libPath);
            if (DEBUG || bl) {
                System.err.println("DynamicLinkerImpl.openLibraryLocal \"" + libPath + "\": 0x" + Long.toHexString(l) + " -> " + libRef + ")");
            }
        } else if (DEBUG || bl) {
            System.err.println("DynamicLinkerImpl.openLibraryLocal \"" + libPath + "\" failed, error: " + this.getLastError());
        }
        return l;
    }

    protected abstract long openLibraryLocalImpl(NativeLibrary.LibPath var1) throws SecurityException;

    @Override
    public final String lookupLibraryPathname(long l, String string) throws SecurityException {
        this.checkLinkPermission(l);
        String string2 = this.lookupLibraryPathnameImpl(l, string);
        if (DEBUG_LOOKUP) {
            System.err.println("DynamicLinkerImpl.lookupLibraryPathname(0x" + Long.toHexString(l) + ", " + string + ") -> '" + string2 + "'");
        }
        return string2;
    }

    protected abstract String lookupLibraryPathnameImpl(long var1, String var3) throws SecurityException;

    @Override
    public final long lookupSymbolGlobal(String string) throws SecurityException {
        this.checkAllLinkPermission();
        long l = this.lookupSymbolGlobalImpl(string);
        if (DEBUG_LOOKUP) {
            System.err.println("DynamicLinkerImpl.lookupSymbolGlobal(" + string + ") -> 0x" + Long.toHexString(l));
        }
        return l;
    }

    protected abstract long lookupSymbolGlobalImpl(String var1) throws SecurityException;

    @Override
    public final long lookupSymbol(long l, String string) throws SecurityException, IllegalArgumentException {
        this.checkLinkPermission(l);
        long l2 = this.lookupSymbolLocalImpl(l, string);
        if (DEBUG_LOOKUP) {
            System.err.println("DynamicLinkerImpl.lookupSymbol(0x" + Long.toHexString(l) + ", " + string + ") -> 0x" + Long.toHexString(l2));
        }
        return l2;
    }

    protected abstract long lookupSymbolLocalImpl(long var1, String var3) throws SecurityException;

    @Override
    public final void closeLibrary(long l, boolean bl) throws SecurityException, IllegalArgumentException {
        LibRef libRef = this.decrLibRefCount(l);
        if (null != libRef) {
            this.checkLinkPermission(libRef.getLibPath().path);
        }
        if (DEBUG || bl) {
            System.err.println("DynamicLinkerImpl.closeLibrary(0x" + Long.toHexString(l) + " -> " + libRef + ")");
        }
        if (0L != l) {
            this.closeLibraryImpl(l);
        }
    }

    protected abstract void closeLibraryImpl(long var1) throws SecurityException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LibRef getLibRef(long l) {
        LongObjectHashMap longObjectHashMap = libHandle2Name;
        synchronized (longObjectHashMap) {
            return (LibRef)libHandle2Name.get(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LibRef incrLibRefCount(long l, NativeLibrary.LibPath libPath) {
        LongObjectHashMap longObjectHashMap = libHandle2Name;
        synchronized (longObjectHashMap) {
            LibRef libRef = this.getLibRef(l);
            if (null == libRef) {
                libRef = new LibRef(libPath);
                libHandle2Name.put(l, libRef);
            } else {
                libRef.incrRefCount();
            }
            if (DEBUG) {
                System.err.println("DynamicLinkerImpl.incrLibRefCount 0x" + Long.toHexString(l) + " -> " + libRef + ", libs loaded " + libHandle2Name.size());
            }
            return libRef;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LibRef decrLibRefCount(long l) {
        LongObjectHashMap longObjectHashMap = libHandle2Name;
        synchronized (longObjectHashMap) {
            LibRef libRef = this.getLibRef(l);
            if (null != libRef && 0 == libRef.decrRefCount()) {
                libHandle2Name.remove(l);
            }
            if (DEBUG) {
                System.err.println("DynamicLinkerImpl.decrLibRefCount 0x" + Long.toHexString(l) + " -> " + libRef + ", libs loaded " + libHandle2Name.size());
            }
            return libRef;
        }
    }

    static final class LibRef {
        private final NativeLibrary.LibPath libPath;
        private int refCount;

        LibRef(NativeLibrary.LibPath libPath) {
            this.libPath = libPath;
            this.refCount = 1;
        }

        final int incrRefCount() {
            return ++this.refCount;
        }

        final int decrRefCount() {
            return --this.refCount;
        }

        final int getRefCount() {
            return this.refCount;
        }

        final NativeLibrary.LibPath getLibPath() {
            return this.libPath;
        }

        public final String toString() {
            return "LibRef[" + this.libPath + ", refCount " + this.refCount + "]";
        }
    }
}

