/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractElementLiveList;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.NDTNode;
import java.util.Locale;
import java.util.Objects;
import org.w3c.dom.Node;

class TagnameElementList
extends AbstractElementLiveList {
    private static final long serialVersionUID = 1L;
    private final String localName;
    private final String htmlLocalName;
    private final String prefix;
    private final boolean matchAll;
    private final boolean isHTML;

    TagnameElementList(NDTNode nDTNode, String string, String string2, boolean bl, boolean bl2) {
        super(nDTNode);
        this.localName = string;
        this.htmlLocalName = string.toLowerCase(Locale.ROOT);
        this.prefix = string2;
        this.matchAll = bl;
        this.isHTML = bl2;
    }

    @Override
    boolean matches(DOMElement dOMElement, Node node) {
        return dOMElement == node && (this.matchAll || this.matchesLocalName(dOMElement)) && Objects.equals(this.prefix, dOMElement.getPrefix());
    }

    @Override
    boolean matches(DOMElement dOMElement) {
        return this.matchAll || this.matchesLocalName(dOMElement) && Objects.equals(this.prefix, dOMElement.getPrefix());
    }

    boolean matchesLocalName(DOMElement dOMElement) {
        String string = dOMElement.getLocalName();
        if (this.isHTML && dOMElement.getNamespaceURI() == "http://www.w3.org/1999/xhtml") {
            return string.equals(this.htmlLocalName);
        }
        return string.equals(this.localName);
    }
}

