# frozen_string_literal: true

class RemoveRedundantUuidIndexFromVulnerabilityOccurrences < Gitlab::Database::Migration[2.3]
  milestone '18.0'
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_occurrences_on_uuid_1'

  def up
    remove_concurrent_index_by_name :vulnerability_occurrences, INDEX_NAME
  end

  def down
    add_concurrent_index :vulnerability_occurrences, :uuid, unique: true, name: INDEX_NAME
  end
end
