---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
gitlab_dedicated: yes
description: プロジェクトの表示レベル、作成、保持、および削除を制御します。
title: アクセスと表示レベルの制御
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLabインスタンスの管理者は、ブランチ、プロジェクト、スニペット、グループなどに対して特定の制御を適用できます。たとえば、次の内容を定義できます。

- プロジェクトを作成または削除できるロール
- 削除されたプロジェクトとグループの保持期間
- グループ、プロジェクト、およびスニペットの表示レベル
- SSHキーで許可されるタイプと長さ
- 受け入れられるプロトコル（SSHまたはHTTPS）やクローンURLなどのGit設定
- プッシュミラーリングとプルミラーリングを許可または禁止する
- グループおよびプロジェクトへの招待を許可または禁止する

前提要件:

- 管理者である必要があります。

表示レベルとアクセス制御のオプションにアクセスするには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **表示レベルとアクセス制御**を展開します。

## プロジェクトを作成できるロールを定義する {#define-which-roles-can-create-projects}

インスタンスにプロジェクトの作成保護を追加できます。この保護により、インスタンス上でどのロールが[プロジェクトをグループに追加](../../user/group/_index.md#specify-who-can-add-projects-to-a-group)できるかを定義できます。

**プロジェクトの作成に必要なデフォルトの最小ロール**設定を設定すると、新しいグループのデフォルトが設定されます。既存のグループは、現在の権限を保持します。

前提要件:

- 管理者である必要があります。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **表示レベルとアクセス制御**を展開します。
1. **プロジェクトの作成に必要なデフォルトの最小ロール**で、目的のロールを選択します。
   - なし
   - 管理者
   - オーナー
   - メンテナー
   - デベロッパー
1. **変更を保存**を選択します。

{{< alert type="note" >}}

**管理者**を選択して、[管理者モード](sign_in_restrictions.md#admin-mode)が有効になっている場合、管理者は新しいプロジェクトを作成するために管理者モードを有効にする必要があります。

{{< /alert >}}

## プロジェクトの削除を管理者に制限する {#restrict-project-deletion-to-administrators}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

前提要件:

- 管理者であるか、プロジェクトのオーナーロールを持っている必要があります。

プロジェクトの削除を管理者のみに制限するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **表示レベルとアクセス制御**を展開します。
1. **プロジェクトの削除を許可**までスクロールし、**管理者**を選択します。
1. **変更を保存**を選択します。

制限を無効にするには、次の手順に従います。

1. **オーナーと管理者**を選択します。
1. **変更を保存**を選択します。

## 削除保護 {#deletion-protection}

{{< history >}}

- GitLab 16.0で、[GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/issues/393622)および[GitLab Self-Managed](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/119606)におけるプロジェクトの遅延削除の有効化が、デフォルトで有効になりました。
- GitLab 16.0で、PremiumおよびUltimateプランにおいて[グループのデフォルトの動作に変更](https://gitlab.com/gitlab-org/gitlab/-/issues/389557)されました。
- GitLab 18.0でGitLab PremiumからGitLab Freeに[移行](https://gitlab.com/groups/gitlab-org/-/epics/17208)しました。
- GitLab 18.4で、削除予定のグループまたはプロジェクトの即時削除を禁止するサポートが、`disallow_immediate_deletion`[フラグ](../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201957)されました。デフォルトでは無効になっています。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

これらの保護は、インスタンス上のグループやプロジェクトが誤って削除されることを防止するために役立ちます。

### 保持期間 {#retention-period}

グループとプロジェクトは、定義した保持期間中であれば復元可能です。デフォルトでは、保持期間は30日ですが、`1`日から`90`日の間の値に変更できます。

前提要件:

- 管理者である必要があります。

グループとプロジェクトの削除保護を設定するには、次の手順を実行します。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **表示レベルとアクセス制御**を展開します。
1. **削除保護**までスクロールし、保持期間を`1`日から`90`日の間の値に設定します。
1. **変更を保存**を選択します。

### デフォルトを上書きして即座に削除する {#override-defaults-and-delete-immediately}

遅延を上書きして、削除対象としてマークされたプロジェクトを即座に削除するには、次の手順に従います。

1. [プロジェクトを復元](../../user/project/working_with_projects.md#restore-a-project)します。
1. [プロジェクトの管理ページ](../admin_area.md#administering-projects)の説明に従って、プロジェクトを削除します。

## プロジェクトの表示レベルのデフォルトを設定する {#configure-project-visibility-defaults}

新しいプロジェクトのデフォルトの[表示レベル](../../user/public_access.md)を設定するには、次の手順に従います。

前提要件:

- 管理者である必要があります。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **表示レベルとアクセス制御**を展開します。
1. デフォルトのプロジェクトの表示レベルとして、目的の値を選択します。
   - **非公開**: 各ユーザーに明示的にプロジェクトへのアクセス権を付与します。このプロジェクトがグループに属している場合、グループのメンバーにアクセス権を付与します。
   - **内部**: 外部ユーザーを除く、すべての認証済みユーザーがプロジェクトにアクセスできます。
   - **公開**: ユーザーは認証なしでプロジェクトにアクセスできます。
1. **変更を保存**を選択します。

## スニペットの表示レベルのデフォルトを設定する {#configure-snippet-visibility-defaults}

新しい[スニペット](../../user/snippets.md)のデフォルトの表示レベルを設定するには、次の手順に従います。

前提要件:

- 管理者である必要があります。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **表示レベルとアクセス制御**を展開します。
1. **デフォルトのスニペットの表示レベル**で、目的の表示レベルを選択します。
   - **非公開**
   - **内部**: この設定は、GitLab.comの新しいプロジェクト、グループ、およびスニペットに対しては無効になっています。`Internal`表示レベル設定を使用している既存のスニペットは、この設定を保持します。この変更の詳細については、[イシュー12388](https://gitlab.com/gitlab-org/gitlab/-/issues/12388)を参照してください。
   - **公開**
1. **変更を保存**を選択します。

## グループの表示レベルのデフォルトを設定する {#configure-group-visibility-defaults}

新しいグループのデフォルトの表示レベルを設定するには、次の手順に従います。

前提要件:

- 管理者である必要があります。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **表示レベルとアクセス制御**を展開します。
1. **デフォルトのグループの表示レベル**で、目的の表示レベルを選択します。
   - **非公開**: メンバーのみがグループとそのプロジェクトを表示できます。
   - **内部**: 外部ユーザーを除く、すべての認証済みユーザーがグループと内部プロジェクトを表示できます。
   - **公開**: グループおよび公開プロジェクトは、認証なしで表示できます。
1. **変更を保存**を選択します。

グループの表示レベルの詳細については、[グループの表示レベル](../../user/group/_index.md#group-visibility)を参照してください。

## 表示レベルを制限する {#restrict-visibility-levels}

{{< history >}}

- GitLab 16.3で、`prevent_visibility_restriction`[フラグ](../feature_flags/_index.md)とともに、デフォルトのプロジェクトおよびグループの表示レベルを制限できないように[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/124649)されました。デフォルトでは無効になっています。
- GitLab 16.4で、`prevent_visibility_restriction`はデフォルトで[有効](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131203)になりました。
- GitLab 16.7で、`prevent_visibility_restriction`は[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/433280)されました。

{{< /history >}}

表示レベルを制限する場合、変更しようとしているアイテムから表示レベルを継承するサブグループやプロジェクトの権限と、表示レベルの制限が互いにどのように影響し合うのかを検討してください。

この設定は、パーソナルネームスペースで作成されたプロジェクトには適用されません。この機能を[エンタープライズユーザー](../../user/enterprise_user/_index.md)に拡張することを目的とした[機能リクエスト](https://gitlab.com/gitlab-org/gitlab/-/issues/382749)があります。

グループ、プロジェクト、スニペット、選択したページの表示レベルを制限するには、次の手順に従います。

前提要件:

- 管理者である必要があります。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **表示レベルとアクセス制御**を展開します。
1. **可視性レベルの制限**で、制限する表示レベルを選択します。
   - **公開**レベルを制限する場合:
      - 管理者のみが、公開グループ、プロジェクト、スニペットを作成できます。
      - ユーザープロファイルは、Webインターフェースを通じて認証済みユーザーのみに表示されます。
      - GraphQL APIではユーザー属性は表示されません。
   - **内部**レベルを制限する場合:
     - 管理者のみが、内部グループ、プロジェクト、スニペットを作成できます。
   - **非公開**レベルを制限する場合:
     - 管理者のみが、非公開グループ、プロジェクト、スニペットを作成できます。
1. **変更を保存**を選択します。

{{< alert type="note" >}}

新しいプロジェクトまたはグループのデフォルトとして設定されている表示レベルを制限することはできません。逆に、制限された表示レベルを新しいプロジェクトまたはグループのデフォルトとして設定することはできません。

{{< /alert >}}

## 有効なGitアクセスプロトコルを設定する {#configure-enabled-git-access-protocols}

GitLabのアクセス制限を使用すると、ユーザーがGitLabとの通信に使用できるプロトコルを選択できます。アクセスプロトコルを無効にしても、サーバー自体へのポートアクセスはブロックされません。プロトコル（SSHまたはHTTP(S)）で使用されるポートには、引き続きアクセス可能です。GitLabのアクセス制限は、アプリケーションレベルで適用されます。

GitLabは、選択したプロトコルに対してのみGitアクションを許可します。

- SSHとHTTP(S)の両方を有効にしている場合、ユーザーはどちらのプロトコルも選択できます。
- いずれか一方のプロトコルのみを有効にしている場合、プロジェクトページには許可されたプロトコルのURLのみが表示され、変更するオプションは表示されません。

インスタンス上のすべてのプロジェクトに対して有効なGitアクセスプロトコルを指定するには、次の手順に従います。

前提要件:

- 管理者である必要があります。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **表示レベルとアクセス制御**を展開します。
1. **有効なGitアクセスプロトコル**で、目的のプロトコルを選択します。
   - SSHとHTTP(S)の両方
   - SSHのみ
   - HTTP(S)のみ
1. **変更を保存**を選択します。

{{< alert type="warning" >}}

GitLabは、[GitLab CI/CDジョブトークン](../../ci/jobs/ci_job_token.md)を使用して実行されるGitのクローンリクエストまたはフェッチリクエストに対して、[HTTP(S)プロトコルの使用を許可](https://gitlab.com/gitlab-org/gitlab-foss/-/merge_requests/18021)しています。GitLab RunnerおよびCI/CDジョブにはこの設定が必要なため、**SSHのみ**を選択していても、この動作は変わりません。

{{< /alert >}}

## HTTP(S)用のGitクローンURLをカスタマイズする {#customize-git-clone-url-for-https}

{{< details >}}

- 提供形態: GitLab Self-Managed

{{< /details >}}

プロジェクトのHTTP(S)用のGitクローンURLは、カスタマイズ可能です。この設定は、プロジェクトページに表示されるクローンパネルに影響します。次に例を示します。

- GitLabインスタンスが`https://example.com`にある場合、プロジェクトのクローンURLは`https://example.com/foo/bar.git`のようになります。
- `https://git.example.com/gitlab/foo/bar.git`のようなクローンURLにしたい場合は、`https://git.example.com/gitlab/`のように設定できます。

`gitlab.rb`でHTTP(S)用のカスタムGitクローンURLを指定するには、`gitlab_rails['gitlab_ssh_host']`に新しい値を設定します。GitLab UIから新しい値を指定するには、次の手順に従います。

前提要件:

- 管理者である必要があります。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **表示レベルとアクセス制御**を展開します。
1. **HTTP(S)用のカスタムGitクローンURL**に、ルートURLを入力します。
1. **変更を保存**を選択します。

## RSA、DSA、ECDSA、ED25519、ECDSA_SK、ED25519_SK SSHキーのデフォルトを設定する {#configure-defaults-for-rsa-dsa-ecdsa-ed25519-ecdsa_sk-ed25519_sk-ssh-keys}

以下のオプションでは、SSHキーで[許可されるタイプと長さ](../../security/ssh_keys_restrictions.md)を指定します。

各キータイプの制限を指定するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **表示レベルとアクセス制御**を展開します。
1. **RSA SSHキー**に移動します。
1. キータイプごとに、使用を完全に許可または禁止するか、次の長さのみを許可できます。
   - 1024ビット以上
   - 2048ビット以上
   - 3072ビット以上
   - 4096ビット以上
   - 1024ビット以上
1. **変更を保存**を選択します。

## プロジェクトのミラーリングを有効にする {#enable-project-mirroring}

GitLabでは、プロジェクトのミラーリングがデフォルトで有効になっています。無効にすると、すべてのリポジトリで[プルミラーリング](../../user/project/repository/mirror/pull.md)と[プッシュミラーリング](../../user/project/repository/mirror/push.md)が機能しなくなります。この設定は、プロジェクトごとに管理者ユーザーのみが再度有効にできます。

インスタンス上でプロジェクトのメンテナーがプロジェクト単位でミラーリングを設定できるようにするには、次の手順に従います。

前提要件:

- 管理者である必要があります。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **リポジトリ**を選択します。
1. **リポジトリのミラーリング**を展開します。
1. **プロジェクトのメンテナーがリポジトリのミラーリングを設定できるようにする**を選択します。
1. **変更を保存**を選択します。

## 全体で許可されたIPの範囲を設定する {#configure-globally-allowed-ip-address-ranges}

管理者は、IPアドレス範囲を[グループごとのIP制限](../../user/group/access_and_permissions.md#restrict-group-access-by-ip-address)と組み合わせることができます。全体で許可されたIPアドレスを使用すると、グループで独自のIPアドレス制限が設定されている場合でも、GitLabインストールの一部を機能させることができます。

たとえば、GitLabページデーモンが`10.0.0.0/24`の範囲で実行されている場合、その範囲を全体で許可します。グループのIPアドレス制限に`10.0.0.0/24`の範囲が含まれていない場合でも、GitLabページはパイプラインからアーティファクトをフェッチできます。

グループの許可リストにIPアドレス範囲を追加するには、次の手順に従います。

前提要件:

- 管理者である必要があります。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **表示レベルとアクセス制御**を展開します。
1. **全体で許可されたIPの範囲**に、IPアドレス範囲のリストを指定します。このリストの仕様は次のとおりです。
   - IPアドレス範囲の数に制限はありません。
   - SSHまたはHTTPの認証済みIPアドレス範囲の両方に適用されます。認証タイプごとにこのリストを分けることはできません。
1. **変更を保存**を選択します。

## グループおよびプロジェクトへの招待を禁止する {#prevent-invitations-to-groups-and-projects}

{{< history >}}

- GitLab 18.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189954)されました。デフォルトでは無効になっています。

{{< /history >}}

管理者は、管理者以外のユーザーがインスタンスのすべてのグループまたはプロジェクトにユーザーを招待することを禁止できます。これを設定すると、インスタンスのグループまたはプロジェクトにユーザーを招待できるのは管理者のみになります。

{{< alert type="note" >}}

[共有](../../user/project/members/sharing_projects_groups.md)や[移行](../../user/project/import/_index.md)などの機能を使用すると、これらのグループやプロジェクトへのアクセスが許可される場合があります。

{{< /alert >}}

管理者は、[特定のグループへのユーザー招待を禁止](../../user/group/manage.md#prevent-invitations-to-a-group)することもできます。

前提要件:

- 管理者である必要があります。

インスタンスへの招待を禁止するには、次の手順に従います。

1. 左側のサイドバーの下部で、**管理者**を選択します。
1. **設定** > **一般**を選択します。
1. **表示レベルとアクセス制御**を展開します。
1. **グループメンバーの招待を禁止する**チェックボックスをオンにします。
1. **変更を保存**を選択します。
