---
stage: Deploy
group: Environments
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: KubernetesクラスターでGitLab CI/CDを使用する
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- エージェント接続共有制限が、GitLab 17.0で100から[500に変更されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149844)。

{{< /history >}}

GitLab CI/CDを使用して、Kubernetesクラスターに安全に接続、デプロイ、および更新できます。

そのためには、[クラスターにエージェントをインストール](install/_index.md)します。完了すると、Kubernetesコンテキストが作成され、GitLab CI/CDパイプラインでKubernetes APIコマンドを実行できます。

クラスターへのアクセスを安全にするには:

- 各エージェントには、個別のコンテキスト(`kubecontext`)があります。
- エージェントが設定されているプロジェクトと、承認した追加のプロジェクトのみが、クラスター内のエージェントにアクセスできます。

GitLab CI/CDを使用してクラスターとやり取りするには、RunnerをGitLabに登録する必要があります。ただし、これらのRunnerは、エージェントが存在するクラスター内にある必要はありません。

前提要件: 

- [GitLab CI/CDが有効になっている](../../../ci/pipelines/settings.md#disable-gitlab-cicd-pipelines)ことを確認してください。

## クラスターでGitLab CI/CDを使用する {#use-gitlab-cicd-with-your-cluster}

GitLab CI/CDを使用してKubernetesクラスターを更新するには: 

1. Kubernetesクラスターが動作しており、マニフェストがGitLabプロジェクトにあることを確認します。
1. 同じGitLabプロジェクトで、[Kubernetes向けGitLabエージェントを登録してインストール](install/_index.md)します。
1. [`.gitlab-ci.yml`ファイルを更新](#update-your-gitlab-ciyml-file-to-run-kubectl-commands)して、エージェントのKubernetesコンテキストを選択し、Kubernetes APIコマンドを実行します。
1. パイプラインを実行して、クラスターにデプロイするか、クラスターを更新します。

Kubernetesマニフェストを含む複数のGitLabプロジェクトがある場合: 

1. 独自のGitLabプロジェクトで、またはKubernetesマニフェストを保持するGitLabプロジェクトの1つで[Kubernetes向けGitLabエージェントをインストール](install/_index.md)します。
1. GitLabプロジェクトで[エージェントアクセスを承認](#authorize-agent-access)します。
1. オプション: セキュリティを強化するには、[代理を使用](#restrict-project-and-group-access-by-using-impersonation)します。
1. [`.gitlab-ci.yml`ファイルを更新](#update-your-gitlab-ciyml-file-to-run-kubectl-commands)して、エージェントのKubernetesコンテキストを選択し、Kubernetes APIコマンドを実行します。
1. パイプラインを実行して、クラスターにデプロイするか、クラスターを更新します。

## エージェントアクセスを承認する {#authorize-agent-access}

複数のプロジェクトにKubernetesマニフェストがある場合は、これらのプロジェクトがエージェントにアクセスできるように承認する必要があります。個々のプロジェクト、グループ、またはサブグループに対してエージェントアクセスを承認し、すべてのプロジェクトがアクセスできるようにすることができます。セキュリティを強化するために、[代理を使用](#restrict-project-and-group-access-by-using-impersonation)することもできます。

認証設定が反映されるまでに1 - 2分かかることがあります。

### エージェントにアクセスするようにプロジェクトを承認する {#authorize-your-projects-to-access-the-agent}

{{< history >}}

- GitLab 15.6で[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/346566)され、階層制限が削除されました。
- GitLab 15.7でユーザーネームスペース内のプロジェクトを承認できるように[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/356831)されました。
- GitLab 18.1で、異なるトップレベルグループに属するグループの承認を許可するように[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/377932)されました。

{{< /history >}}

Kubernetesマニフェストを保持するGitLabプロジェクトに、エージェントへのアクセスをを承認するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、[エージェント設定ファイル](install/_index.md#create-an-agent-configuration-file)(`config.yaml`)を含むプロジェクトを見つけます。
1. `config.yaml`ファイルを編集します。`ci_access`キーワードの下に、`projects`属性を追加します。
1. `id`には、プロジェクトへのパスを追加します。

   ```yaml
   ci_access:
     projects:
       - id: path/to/project
   ```

   - [インスタンスレベルの承認](#authorize-all-projects-in-your-gitlab-instance-to-access-the-agent)アプリケーション設定が有効になっていない限り、承認されたプロジェクトは、エージェントの設定プロジェクトと同じトップレベルグループまたはユーザーネームスペースを持っている必要があります。
   - 追加の階層に対応するために、同じクラスターに追加のエージェントをインストールできます。
   - 最大500個のプロジェクトを承認できます。

これらの変更を行った後:

- すべてのCI/CDジョブに、すべての共有エージェント接続のコンテキストを含む`kubeconfig`ファイルが含まれるようになりました。
- `kubeconfig`パスは、`$KUBECONFIG`環境変数で使用できます。
- CI/CDスクリプトから`kubectl`コマンドを実行するコンテキストを選択します。

### エージェントにアクセスするようグループ内のプロジェクトを承認する {#authorize-projects-in-your-groups-to-access-the-agent}

{{< history >}}

- GitLab 15.6で[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/346566)され、階層制限が削除されました。
- GitLab 18.1で、異なるトップレベルグループに属するグループの承認を許可するように[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/377932)されました。

{{< /history >}}

エージェントにアクセスするようにグループまたはサブグループ内のすべてのGitLabプロジェクトを承認するには: 

1. 左側のサイドバーで、**検索または移動先**を選択して、[エージェント設定ファイル](install/_index.md#create-an-agent-configuration-file)(`config.yaml`)を含むプロジェクトを見つけます。
1. `config.yaml`ファイルを編集します。`ci_access`キーワードの下に、`groups`属性を追加します。
1. `id`には、パスを追加します: 

   ```yaml
   ci_access:
     groups:
       - id: path/to/group/subgroup
   ```

   - [インスタンスレベルの認証](#authorize-all-projects-in-your-gitlab-instance-to-access-the-agent)アプリケーション設定が有効になっていない限り、認証されたグループは、エージェントの構成プロジェクトと同じトップレベルグループを持っている必要があります。
   - 追加の階層に対応するために、同じクラスターに追加のエージェントをインストールできます。
   - 承認されたグループのすべてのサブグループも、（個別に指定されなくても）同じエージェントにアクセスできます。
   - 最大500個のグループを承認できます。

これらの変更を行った後:

- グループとそのサブグループに属するすべてのプロジェクトが、エージェントにアクセスできるようになりました。
- すべてのCI/CDジョブに、すべての共有エージェント接続のコンテキストを含む`kubeconfig`ファイルが含まれるようになりました。
- `kubeconfig`パスは、`$KUBECONFIG`環境変数で使用できます。
- CI/CDスクリプトから`kubectl`コマンドを実行するコンテキストを選択します。

### エージェントにアクセスするようGitLabインスタンス内のすべてのプロジェクトを承認する {#authorize-all-projects-in-your-gitlab-instance-to-access-the-agent}

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 17.11で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/357516)されました。

{{< /history >}}

前提要件: 

- 管理者である必要があります。

GitLabインスタンス内のすべてのプロジェクトを承認するようにエージェントを設定できるようにするには: 

{{< tabs >}}

{{< tab title="UIを使用する" >}}

1. **管理者**エリアで、**設定 > 一般**を選択し、**Kubernetes向けGitLabエージェント**セクションを展開します。
1. **インスタンスレベルの認証を有効にする**を選択します。
1. **変更を保存**を選択します。

{{< /tab >}}

{{< tab title="APIを使用する" >}}

1. [アプリケーション設定を更新](../../../api/settings.md#update-application-settings)して、`organization_cluster_agent_authorization_enabled`を`true`にします。

{{< /tab >}}

{{< /tabs >}}

すべてのGitLabプロジェクトにアクセスするようにエージェントを承認するには: 

1. 左側のサイドバーで、**検索または移動先**を選択して、[エージェント設定ファイル](install/_index.md#create-an-agent-configuration-file)(`config.yaml`)を含むプロジェクトを見つけます。
1. `config.yaml`ファイルを編集します。`ci_access`キーワードの下に、`instance`属性を追加します。

   ```yaml
   ci_access:
     instance: {}
   ```

エージェント設定ファイルにこれらの変更を加えた後: 

- お使いのインスタンス内のすべてのプロジェクトのすべてのCI/CDジョブは、エージェントへのアクセスを承認されています。必要に応じて、RBACでCI/CDジョブの代理を使用して、アクセスを許可または制限できます。詳細については、[Restrict project and group access by using impersonation](#restrict-project-and-group-access-by-using-impersonation)（代理を使用したプロジェクトおよびグループアクセス制限）を参照してください。
- すべてのCI/CDジョブに、すべての共有エージェント接続のコンテキストを含む`kubeconfig`ファイルが含まれるようになりました。
- `kubeconfig`パスは、`$KUBECONFIG`環境変数で使用できます。
- CI/CDスクリプトから`kubectl`コマンドを実行するコンテキストを選択します。

## `.gitlab-ci.yml`ファイルを更新して`kubectl`コマンドを実行する {#update-your-gitlab-ciyml-file-to-run-kubectl-commands}

Kubernetesコマンドを実行するプロジェクトで、プロジェクトの`.gitlab-ci.yml`ファイルを編集します。

`script`キーワードの下の最初のコマンドで、エージェントのコンテキストを設定します。`<path/to/agent/project>:<agent-name>`形式を使用します。次に例を示します: 

```yaml
deploy:
  image:
    name: bitnami/kubectl:latest
    entrypoint: ['']
  script:
    - kubectl config get-contexts
    - kubectl config use-context path/to/agent/project:agent-name
    - kubectl get pods
```

エージェントのコンテキストが不明な場合は、エージェントにアクセスするCI/CDジョブから`kubectl config get-contexts`を実行します。

### Auto DevOpsを使用する環境 {#environments-that-use-auto-devops}

Auto DevOpsが有効になっている場合は、CI/CD変数`KUBE_CONTEXT`を定義する必要があります。Auto DevOpsで使用するエージェントのコンテキストに`KUBE_CONTEXT`の値を設定します: 

```yaml
deploy:
  variables:
    KUBE_CONTEXT: path/to/agent/project:agent-name
```

異なるエージェントを別々のAuto DevOpsジョブに割り当てることができます。インスタンスのために、Auto DevOpsでは、`staging`ジョブに1つのエージェントを使用し、`production`ジョブに別のエージェントを使用できます。複数のエージェントを使用するには、各エージェントに[環境スコープのCI/CD変数](../../../ci/environments/_index.md#limit-the-environment-scope-of-a-cicd-variable)を定義します。次に例を示します: 

1. `KUBE_CONTEXT`という名前の2つの変数を定義します。
1. 最初の変数: 
   1. `environment`を`staging`に設定します。
   1. 値をステージングエージェントのコンテキストに設定します。
1. 2番目の変数:
   1. `environment`を`production`に設定します。
   1. 値を本番環境エージェントのコンテキストに設定します。

### 証明書ベースの接続とエージェントベースの接続の両方を使用する環境 {#environments-with-both-certificate-based-and-agent-based-connections}

[証明書ベースのクラスター](../../infrastructure/clusters/_index.md)（非推奨）とエージェント接続の両方がある環境にデプロイする場合: 

- 証明書ベースのクラスターのコンテキストは`gitlab-deploy`と呼ばれます。このコンテキストは、デフォルトで常に選択されます。
- エージェントのコンテキストは`$KUBECONFIG`に含まれています。それらは`kubectl config use-context <path/to/agent/project>:<agent-name>`を使用して選択できます。

証明書ベースの接続が存在する場合にエージェント接続を使用するには、新しい`kubectl`設定コンテキストを手動で設定できます。次に例を示します: 

```yaml
deploy:
  variables:
    KUBE_CONTEXT: my-context # The name to use for the new context
    AGENT_ID: 1234 # replace with your agent's numeric ID
    K8S_PROXY_URL: https://<KAS_DOMAIN>/k8s-proxy/ # For agent server (KAS) deployed in Kubernetes cluster (for gitlab.com use kas.gitlab.com); replace with your URL
    # K8S_PROXY_URL: https://<GITLAB_DOMAIN>/-/kubernetes-agent/k8s-proxy/ # For agent server (KAS) in Omnibus
    # Include any additional variables
  before_script:
    - kubectl config set-credentials agent:$AGENT_ID --token="ci:${AGENT_ID}:${CI_JOB_TOKEN}"
    - kubectl config set-cluster gitlab --server="${K8S_PROXY_URL}"
    - kubectl config set-context "$KUBE_CONTEXT" --cluster=gitlab --user="agent:${AGENT_ID}"
    - kubectl config use-context "$KUBE_CONTEXT"
  # Include the remaining job configuration
```

### 自己署名証明書を使用するKASを使用する環境 {#environments-with-kas-that-use-self-signed-certificates}

KASを使用する環境と自己署名証明書を使用する場合は、証明書に署名した認証局（CA）を信頼するようにKubernetesクライアントを設定する必要があります。

クライアントを設定するには、次のいずれかを実行します: 

- PEM形式でKAS証明書を使用してCI/CD変数`SSL_CERT_FILE`を設定します。
- `--certificate-authority=$KAS_CERTIFICATE`でKubernetesクライアントを設定します。ここで、`KAS_CERTIFICATE`はKASのCA証明書を持つCI/CD変数です。
- コンテナイメージを更新するか、Runner経由でマウントして、ジョブコンテナ内の適切な場所に証明書を配置します。
- 推奨されません。`--insecure-skip-tls-verify=true`でKubernetesクライアントを設定します。

## 代理を使用してプロジェクトとグループのアクセスを制限する {#restrict-project-and-group-access-by-using-impersonation}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 15.5で[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/357934)され、環境プランの代理のサポートが追加されました。

{{< /history >}}

デフォルトでは、CI/CDジョブは、クラスターにエージェントをインストールするために使用されるサービスアカウントからすべての権限を継承します。クラスターへのアクセスを制限するには、[代理](https://kubernetes.io/docs/reference/access-authn-authz/authentication/#user-impersonation)を使用します。

代理を指定するには、エージェント設定ファイルで`access_as`属性を使用し、Kubernetes RBACルールを使用して代理アカウントの権限を管理します。

代理にできるもの:

- エージェント自体（デフォルト）。
- クラスターにアクセスするCI/CDジョブ。
- クラスター内で定義された特定のユーザーまたはシステムアカウント。

認証設定が反映されるまでに1 - 2分かかることがあります。

### エージェントを代理化する {#impersonate-the-agent}

エージェントはデフォルトで代理化されます。代理化するために何かする必要はありません。

### クラスターにアクセスするCI/CDジョブを代理化する {#impersonate-the-cicd-job-that-accesses-the-cluster}

クラスターにアクセスするCI/CDジョブを代理化するには、`access_as`キーの下に`ci_job: {}`キーと値を追加します。

エージェントが実際のKubernetes APIにリクエストを行う場合、次の方法で代理認証情報を設定します: 

- `UserName`が`gitlab:ci_job:<job id>`に設定されます。例: `gitlab:ci_job:1074499489`。
- `Groups`は以下に設定されます: 

  - CIジョブからのすべてのリクエストを識別するために`gitlab:ci_job`。
  - プロジェクトが存在するグループのIDのリスト。
  - プロジェクトID。
  - このジョブが属する環境のslugとプラン。

    `group1/group1-1/project1`のCIジョブの例:

    - グループ`group1`のIDは23です。
    - グループ`group1/group1-1`のIDは25です。
    - プロジェクト`group1/group1-1/project1`のIDは150です。
    - `production`環境プランを持つ`prod`環境で実行されているジョブ。

  グループリストは`[gitlab:ci_job, gitlab:group:23, gitlab:group_env_tier:23:production, gitlab:group:25, gitlab:group_env_tier:25:production, gitlab:project:150, gitlab:project_env:150:prod, gitlab:project_env_tier:150:production]`になります。

- `Extra`は、リクエストに関する追加情報を伝えます。代理化されたIDには、次のプロパティが設定されます:

| プロパティ                             | 説明                                                                  |
| ------------------------------------ | ---------------------------------------------------------------------------- |
| `agent.gitlab.com/id`                | エージェントIDが含まれています。                                                       |
| `agent.gitlab.com/config_project_id` | エージェントの設定プロジェクトIDが含まれています。                               |
| `agent.gitlab.com/project_id`        | CIプロジェクトIDが含まれています。                                                  |
| `agent.gitlab.com/ci_pipeline_id`    | CIパイプラインIDが含まれています。                                                 |
| `agent.gitlab.com/ci_job_id`         | CIジョブIDが含まれています。                                                      |
| `agent.gitlab.com/username`          | CIジョブが実行されているユーザーのユーザー名が含まれています。                  |
| `agent.gitlab.com/environment_slug`  | 環境のslugが含まれています。環境で実行されている場合にのみ設定されます。 |
| `agent.gitlab.com/environment_tier`  | 環境のプランが含まれています。環境で実行されている場合にのみ設定されます。 |

CI/CDジョブのIDでアクセスを制限する例`config.yaml`:

```yaml
ci_access:
  projects:
    - id: path/to/project
      access_as:
        ci_job: {}
```

#### CI/CDジョブを制限するRBACの例 {#example-rbac-to-restrict-cicd-jobs}

次の`RoleBinding`リソースは、すべてのCI/CDジョブを読み取り権限のみに制限します。

```yaml
apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRoleBinding
metadata:
  name: ci-job-view
roleRef:
  name: view
  kind: ClusterRole
  apiGroup: rbac.authorization.k8s.io
subjects:
  - name: gitlab:ci_job
    kind: Group
```

### 静的なIDを代理化する {#impersonate-a-static-identity}

特定の接続では、代理化に静的なIDを使用できます。

`access_as`キーの下に、`impersonate`キーを追加して、提供されたIDを使用してリクエストを行います。

IDは、次のキーで指定できます: 

- `username`（必須）
- `uid`
- `groups`
- `extra`

詳細については、[Kubernetesの公式ドキュメント](https://kubernetes.io/docs/reference/access-authn-authz/authentication/#user-impersonation)を参照してください。

## 特定の環境へのプロジェクトとグループのアクセスを制限する {#restrict-project-and-group-access-to-specific-environments}

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 15.7で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/343885)されました。

{{< /history >}}

デフォルトでは、エージェントが[プロジェクトで利用できる](#authorize-agent-access)場合、プロジェクトのすべてのCI/CDジョブはそのエージェントを使用できます。

特定環境でのジョブのみにエージェントへのアクセスを制限するには、`environments`を`ci_access.projects`または`ci_access.groups`に追加します。次に例を示します: 

  ```yaml
  ci_access:
    projects:
      - id: path/to/project-1
      - id: path/to/project-2
        environments:
          - staging
          - review/*
    groups:
      - id: path/to/group-1
        environments:
          - production
  ```

この例では: 

- `project-1`のすべてのCI/CDジョブがエージェントにアクセスできます。
- `project-2`の`staging`または`review/*`環境下にあるCI/CDジョブはエージェントにアクセスできます。
  - `*`はワイルドカードのため、`review/*`は`review`配下のすべての環境と一致します。
- `group-1`配下のプロジェクトの`production`環境用のCI/CDジョブは、エージェントにアクセスできます。

## 保護ブランチへのエージェントへのアクセスを制限 {#restrict-access-to-the-agent-to-protected-branches}

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 17.3で`kubernetes_agent_protected_branches`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/467936)されました。デフォルトでは無効になっています。
- GitLab 17.10で、[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/467936)になりました。機能フラグ`kubernetes_agent_protected_branches`は削除されました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。この機能はテストには利用できますが、本番環境での使用には適していません。

{{< /alert >}}

[保護ブランチ](../../project/repository/branches/protected.md)で実行されるジョブのみにエージェントへのアクセスを制限するには: 

- `protected_branches_only: true`を`ci_access.projects`または`ci_access.groups`に追加します。次に例を示します: 

  ```yaml
  ci_access:
    projects:
      - id: path/to/project-1
        protected_branches_only: true
    groups:
      - id: path/to/group-1
        protected_branches_only: true
        environments:
          - production
  ```

デフォルトでは、`protected_branches_only`が`false`に設定され、エージェントには保護されていないブランチと保護ブランチからアクセスできます。

セキュリティを強化するために、この機能を[環境制限](#restrict-project-and-group-access-to-specific-environments)と組み合わせることができます。

プロジェクトに複数の設定がある場合、最も具体的な設定のみが使用されます。たとえば、次の設定では、`example`グループが保護ブランチへのアクセスのみを許可するように設定されている場合でも、`example/my-project`の保護されていないブランチへのアクセスが許可されます:

```yaml
# .gitlab/agents/my-agent/config.yaml
ci_access:
  project:
    - id: example/my-project # Project of the group below
      protected_branches_only: false # This configuration supersedes the group configuration
      environments:
        - dev
  groups:
    - id: example
      protected_branches_only: true
      environments:
        - dev
```

詳細については、[CI/CDからKubernetesへのアクセス](https://gitlab.com/gitlab-org/cluster-integration/gitlab-agent/-/blob/master/doc/kubernetes_ci_access.md#apiv4joballowed_agents-api)を参照してください。

## 関連トピック {#related-topics}

- [自己ペースの教室ワークショップ](https://gitlab-for-eks.awsworkshop.io)（AWS EKSを使用していますが、他のKubernetesクラスターにも使用できます）
- [Auto DevOpsを設定する](../../../topics/autodevops/cloud_deployments/auto_devops_with_gke.md#configure-auto-devops)

## トラブルシューティング {#troubleshooting}

### `~/.kube/cache`に書き込み権限を付与する {#grant-write-permissions-to-kubecache}

`kubectl`、Helm、`kpt`、`kustomize`などのツールは、クラスターに関する情報を`~/.kube/cache`にキャッシュします。このディレクトリが書き込み可能でない場合、ツールは呼び出すたびに情報をフェッチするため、インタラクションが遅くなり、クラスターの読み込みに不要な負荷がかかります。最良のエクスペリエンスを得るために、`.gitlab-ci.yml`ファイルで使用するイメージで、このディレクトリが書き込み可能であることを確認してください。

### TLSを有効にする {#enable-tls}

GitLab Self-Managedを使用している場合は、インスタンスがトランスポートレイヤーセキュリティ（TLS）で設定されていることを確認してください。

TLSなしで`kubectl`を使用しようとすると、次のようなエラーが発生する可能性があります: 

```shell
$ kubectl get pods
error: You must be logged in to the server (the server has asked for the client to provide credentials)
```

### サーバーに接続できません: 不明な認証局によって署名された証明書 {#unable-to-connect-to-the-server-certificate-signed-by-unknown-authority}

KASを使用する環境で、自己署名証明書を使用している場合、`kubectl`の呼び出しで次のエラーが返されることがあります: 

```plaintext
kubectl get pods
Unable to connect to the server: x509: certificate signed by unknown authority
```

このエラーは、ジョブがKAS証明書に署名した認証局（CA）を信頼しないために発生します。

問題を解決するには、[CAを信頼するように `kubectl`を設定](#environments-with-kas-that-use-self-signed-certificates)します。

### 検証エラー {#validation-errors}

`kubectl`のバージョンv1.27.0またはv.1.27.1を使用している場合、次のエラーが発生する可能性があります: 

```plaintext
error: error validating "file.yml": error validating data: the server responded with the status code 426 but did not return more information; if you choose to ignore these errors, turn validation off with --validate=false
```

このイシューは、共有Kubernetesライブラリを使用する`kubectl`およびその他のツールの[バグ](https://github.com/kubernetes/kubernetes/issues/117463)によって発生します。

問題を解決するには、別のバージョンの`kubectl`を使用してください。
