---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 脆弱性検出結果API
description: GitLab REST API（非推奨）を使用して、プロジェクト、スキャナー、重大度のフィルターを使用して、セキュリティスキャンからの脆弱性の検出結果をリストおよび管理します
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< alert type="warning" >}}

このAPIは非推奨になる過程にあり、不安定であると見なされています。レスポンスペイロードは、GitLabのリリース全体で変更または破損する可能性があります。代わりに、[GraphQL API](graphql/reference/_index.md#queryvulnerabilities)を使用してください。詳細については、[GraphQLの例](vulnerabilities.md#replace-vulnerability-rest-api-with-graphql)を参照してください

{{< /alert >}}

{{< alert type="note" >}}

このAPIリソースは、脆弱性が[脆弱性オブジェクト](https://gitlab.com/gitlab-org/gitlab/-/issues/13561)の提供用に予約されているため、VulnerabilitiesからVulnerability Findingsに名前が変更されました。以前のVulnerabilities APIとの壊れたインテグレーションを修正するには、`vulnerabilities` URL部分を`vulnerability_findings`に変更します。

{{< /alert >}}

このAPIを使用して[脆弱性の検出結果](../user/application_security/vulnerability_report/_index.md)を取得する。このAPIへのすべての呼び出しには、認証が必要です。

ユーザーが[プロジェクトセキュリティダッシュボード](../user/permissions.md#project-members-permissions)を使用する権限を持っていない場合、このプロジェクトの脆弱性検出結果に対するすべてのリクエストは、`403 Forbidden`ステータスコードを返します。

## 脆弱性検出結果のページネーション {#vulnerability-findings-pagination}

APIの結果はページネーションされるため、デフォルトでは、`GET`リクエストは一度に20件の結果を返します。

詳細については、[ページネーション](rest/_index.md#pagination)を参照してください。

## プロジェクトの脆弱性検出結果をリスト表示する {#list-project-vulnerability-findings}

プロジェクトのすべての脆弱性検出結果をリスト表示します。

```plaintext
GET /projects/:id/vulnerability_findings
GET /projects/:id/vulnerability_findings?report_type=sast
GET /projects/:id/vulnerability_findings?report_type=container_scanning
GET /projects/:id/vulnerability_findings?report_type=sast,dast
GET /projects/:id/vulnerability_findings?scope=all
GET /projects/:id/vulnerability_findings?scope=dismissed
GET /projects/:id/vulnerability_findings?severity=high
GET /projects/:id/vulnerability_findings?pipeline_id=42
```

| 属性     | 型           | 必須 | 説明                                                                                                                                                                         |
| ------------- | -------------- | -------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `id`          | 整数または文字列 | はい      | 認証済みユーザーがメンバーであるプロジェクトのIDまたは[URLエンコードされたパス](rest/_index.md#namespaced-paths)                                                           |
| `report_type` | 文字列配列   | いいえ       | 指定されたレポートタイプに属する脆弱性検出結果を返します。有効な値：`sast`、`dast`、`dependency_scanning`、または`container_scanning`。デフォルトではすべてになります。                   |
| `scope`       | 文字列         | いいえ       | 指定されたスコープの脆弱性検出結果を返します：`all`または`dismissed`。`dismissed`がデフォルトです。                                                                                  |
| `severity`    | 文字列配列   | いいえ       | 指定された重大度レベルに属する脆弱性検出結果を返します：`info`、`unknown`、`low`、`medium`、`high`、または`critical`。デフォルトではすべてになります。                                   |
| `pipeline_id` | 整数または文字列 | いいえ       | 指定されたパイプラインに属する脆弱性検出結果を返します。                                                                                                                     |

```shell
curl --request GET \
  --header "PRIVATE-TOKEN: <your_access_token>" \
  --url "https://gitlab.example.com/api/v4/projects/4/vulnerability_findings"
```

レスポンス例:

```json
[
  {
    "id": null,
    "report_type": "sast",
    "name": "Possible command injection",
    "severity": "high",
    "scanner": {
      "external_id": "brakeman",
      "name": "Brakeman",
      "vendor": "GitLab"
    },
    "identifiers": [
      {
        "external_type": "brakeman_warning_code",
        "external_id": "14",
        "name": "Brakeman Warning Code 14",
        "url": "https://brakemanscanner.org/docs/warning_types/command_injection/"
      }
    ],
    "uuid": "ad5e3be3-a193-55f5-a200-bc12865fb09c",
    "create_jira_issue_url": null,
    "false_positive": true,
    "create_vulnerability_feedback_issue_path": "/root/test-false-positive/-/vulnerability_feedback",
    "create_vulnerability_feedback_merge_request_path": "/root/test-false-positive/-/vulnerability_feedback",
    "create_vulnerability_feedback_dismissal_path": "/root/test-false-positive/-/vulnerability_feedback",
    "project": {
      "id": 2,
      "name": "Test False Positive",
      "full_path": "/root/test-false-positive",
      "full_name": "Administrator / Test False Positive"
    },
    "dismissal_feedback": null,
    "issue_feedback": null,
    "merge_request_feedback": null,
    "description": null,
    "links": [],
    "location": {
      "file": "app/controllers/users_controller.rb",
      "start_line": 42,
      "class": "UsersController",
      "method": "list_users"
    },
    "remediations": [
      null
    ],
    "solution": null,
    "evidence": null,
    "request": null,
    "response": null,
    "evidence_source": null,
    "supporting_messages": [],
    "assets": [],
    "details": {},
    "state": "detected",
    "scan": {
      "type": "sast",
      "status": "success",
      "start_time": "2021-09-02T20:55:48",
      "end_time": "2021-09-02T20:55:48"
    },
    "blob_path": "/root/test-false-positive/-/blob/dfd75607752a839bbc9c7362d111effaa470fecd/app/controllers/users_controller.rb#L42"
  }
]
```

## GraphQLで脆弱性検出REST APIを置き換える {#replace-vulnerability-findings-rest-api-with-graphql}

脆弱性検出REST APIエンドポイントの[今後の非推奨化](https://gitlab.com/groups/gitlab-org/-/epics/5118)に備えて、以下の例を使用して、GraphQL APIで同等の操作を実行します。

### GraphQL - プロジェクトの脆弱性検出結果 {#graphql---project-vulnerability-findings}

[`Pipeline.securityReportFindings`](graphql/reference/_index.md#pipelinesecurityreportfindings)を使用してください。

```graphql
query VulnerabilityFindings {
  project(fullPath: "gitlab-examples/security/security-reports") {
    pipelines(first:1) {
      nodes {
        securityReportFindings(first:1) {
          nodes {
            title
            severity
            state
            scanner {
              externalId
              name
              vendor
            }
            identifiers {
              externalType
              externalId
              name
              url
            }
            uuid
            falsePositive
            description
            location {
              ... on VulnerabilityLocationSast {
                file
                startLine
                endLine
                vulnerableClass
                vulnerableMethod
                blobPath
              }

              ... on VulnerabilityLocationContainerScanning {
                dependency {
                  package {
                    name
                  }
                  version
                }
                image
                operatingSystem
              }

              ... on VulnerabilityLocationDependencyScanning {
                file
                blobPath
                dependency {
                  version
                }
              }
            }
            remediations {
              diff
              summary
            }
            solution
            evidence {
              request {
                body
                headers {
                  name
                  value
                }
                method
                url
              }
            }
          }
        }
      }
    }
  }
}
```

レスポンス例:

```json
{
  "data": {
    "project": {
      "pipelines": {
        "nodes": [
          {
            "securityReportFindings": {
              "nodes": [
                {
                  "title": "Deserialization of Untrusted Data",
                  "severity": "CRITICAL",
                  "state": "CONFIRMED",
                  "scanner": {
                    "externalId": "gemnasium",
                    "name": "Gemnasium",
                    "vendor": "GitLab"
                  },
                  "identifiers": [
                    {
                      "externalType": "gemnasium",
                      "externalId": "b60c2d6b-9083-4a97-a1b2-f7dc79bff74c",
                      "name": "Gemnasium-b60c2d6b-9083-4a97-a1b2-f7dc79bff74c",
                      "url": "https://gitlab.com/gitlab-org/security-products/gemnasium-db/-/blob/master/gem/activerecord/CVE-2022-32224.yml"
                    },
                    {
                      "externalType": "cve",
                      "externalId": "CVE-2022-32224",
                      "name": "CVE-2022-32224",
                      "url": "https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-32224"
                    },
                    {
                      "externalType": "ghsa",
                      "externalId": "GHSA-3hhc-qp5v-9p2j",
                      "name": "GHSA-3hhc-qp5v-9p2j",
                      "url": "https://github.com/advisories/GHSA-3hhc-qp5v-9p2j"
                    }
                  ],
                  "uuid": "c9e40395-72cd-54f5-962f-e1d52c0dffab",
                  "falsePositive": false,
                  "description": "A possible escalation to RCE vulnerability exists when using YAML serialized columns in Active Record < 7.0.3.1, <6.1.6.1, <6.0.5.1 and <5.2.8.1 which could allow an attacker, that can manipulate data in the database (via means like SQL injection), the ability to escalate to an RCE.",
                  "location": {
                    "file": "dependency-scanning-files/Gemfile.lock",
                    "blobPath": null,
                    "dependency": {
                      "version": "5.0.0"
                    }
                  },
                  "remediations": [],
                  "solution": "Upgrade to versions 5.2.8.1, 6.0.5.1, 6.1.6.1, 7.0.3.1 or above.",
                  "evidence": null
                }
              ]
            }
          }
        ]
      }
    }
  }
}
```
