---
stage: Verify
group: Pipeline Authoring
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Pipeline editor
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

The pipeline editor is the primary place to edit the GitLab CI/CD configuration in
the `.gitlab-ci.yml` file in the root of your repository. To access the editor, go to **Build** > **Pipeline editor**.

From the pipeline editor page you can:

- Select the branch to work from.
- [Validate](#validate-cicd-syntax) your configuration syntax while editing the file.
- Do a deeper [validation of your configuration](#validate-cicd-configuration), that verifies it with any configuration
  added with the [`include`](../yaml/_index.md#include) keyword.
- View a [list of the CI/CD configuration added with the `include` keyword](#view-included-cicd-configuration).
- See a [visualization](#visualize-ci-configuration) of the current configuration.
- View the [full configuration](#view-full-configuration), which displays the configuration with any configuration from `include` added.
- [Commit](#commit-changes-to-ci-configuration) the changes to a specific branch.

## Validate CI/CD syntax

As you use the pipeline editor, the pipeline configuration syntax is continually validated against
the GitLab CI/CD pipeline schema. The syntax of your CI/CD YAML and also some basic logical validations
are checked.

The result of this validation is shown at the top of the editor page. If the validation fails,
this section displays a tip to help you fix the problem.

## Validate CI/CD configuration

{{< history >}}

- Option to select different branches [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/482676) in GitLab 18.4.

{{< /history >}}

To test the validity of your GitLab CI/CD configuration before committing the changes,
use the pipeline editor validation tool. This tool simulates the creation of pipeline
due to a Git push event, and can help troubleshoot logic issues, including incorrect
`rules` and `needs` job dependencies:

1. On the top bar, select **Search or go to** and find your project.
1. Select **Build** > **Pipeline editor**.
1. Select the **Validate** tab.
1. Optional. Select a different branch to use for the simulated push event by using
   the **Pipeline run source** dropdown list.
1. Select **Validate pipeline**.

The simulated pipeline uses the existing pipeline configuration from the **Edit** tab.

To validate a CI/CD YAML snippet without adding it to the **Edit** tab, use the
[CI Lint tool](../yaml/lint.md#simulate-a-pipeline) instead.

## View included CI/CD configuration

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/7064) in GitLab 15.0 [with a flag](../../administration/feature_flags/_index.md) named `pipeline_editor_file_tree`. Disabled by default.
- [Feature flag removed](https://gitlab.com/gitlab-org/gitlab/-/issues/357219) in GitLab 15.1.

{{< /history >}}

You can review configuration added with the [`include`](../yaml/_index.md#include)
keyword in the pipeline editor. In the upper-right corner, select the file tree ({{< icon name="file-tree" >}})
to see a list of all included configuration files. Selected files open in a new tab
for review.

## Visualize CI configuration

To view a visualization of your `.gitlab-ci.yml` configuration, in your project,
go to **Build** > **Pipeline editor**, and then select the **Visualize** tab. The
visualization shows all stages and jobs. Any [`needs`](../yaml/_index.md#needs)
relationships are displayed as lines connecting jobs together, showing the
hierarchy of execution.

Hover over a job to highlight its `needs` relationships:

![CI/CD configuration visualization on hover](img/ci_config_visualization_hover_v17_9.png)

If the configuration does not have any `needs` relationships, then no lines are drawn because
each job depends only on the previous stage being completed successfully.

## View full configuration

{{< history >}}

- **View merged YAML** tab [renamed to **Full configuration**](https://gitlab.com/gitlab-org/gitlab/-/issues/377404) in GitLab 16.0.

{{< /history >}}

To view the fully expanded CI/CD configuration as one combined file, go to the
pipeline editor's **Full configuration** tab. This tab displays an expanded configuration
where:

- Configuration imported with [`include`](../yaml/_index.md#include) is copied into the view.
- Jobs that use [`extends`](../yaml/_index.md#extends) display with the
  [extended configuration merged into the job](../yaml/yaml_optimization.md#merge-details).
- [YAML anchors](../yaml/yaml_optimization.md#anchors) are replaced with the linked configuration.
- [YAML `!reference` tags](../yaml/yaml_optimization.md#reference-tags) are also replaced
  with the linked configuration.
- Conditional rules are evaluated assuming a default branch push event.

Using `!reference` tags can cause nested configuration that display with
multiple hyphens (`-`) at the start of the line in the expanded view. This behavior is expected, and the extra
hyphens do not affect the job's execution. For example, this configuration and
fully expanded version are both valid:

- `.gitlab-ci.yml` file:

  ```yaml
  .python-req:
    script:
      - pip install pyflakes

  .rule-01:
    rules:
      - if: $CI_MERGE_REQUEST_SOURCE_BRANCH_NAME =~ /^feature/
        when: manual
        allow_failure: true
      - if: $CI_MERGE_REQUEST_SOURCE_BRANCH_NAME

  .rule-02:
    rules:
      - if: $CI_COMMIT_BRANCH == "main"
        when: manual
        allow_failure: true

  lint-python:
    image: python:latest
    script:
      - !reference [.python-req, script]
      - pyflakes python/
    rules:
      - !reference [.rule-01, rules]
      - !reference [.rule-02, rules]
  ```

- Expanded configuration in **Full configuration** tab:

  ```yaml
  ".python-req":
    script:
    - pip install pyflakes
  ".rule-01":
    rules:
    - if: "$CI_MERGE_REQUEST_SOURCE_BRANCH_NAME =~ /^feature/"
      when: manual
      allow_failure: true
    - if: "$CI_MERGE_REQUEST_SOURCE_BRANCH_NAME"
  ".rule-02":
    rules:
    - if: $CI_COMMIT_BRANCH == "main"
      when: manual
      allow_failure: true
  lint-python:
    image: python:latest
    script:
    - - pip install pyflakes                                     # <- The extra hyphens do not affect the job's execution.
    - pyflakes python/
    rules:
    - - if: "$CI_MERGE_REQUEST_SOURCE_BRANCH_NAME =~ /^feature/" # <- The extra hyphens do not affect the job's execution.
        when: manual
        allow_failure: true
      - if: "$CI_MERGE_REQUEST_SOURCE_BRANCH_NAME"               # <- No extra hyphen but aligned with previous rule
    - - if: $CI_COMMIT_BRANCH == "main"                          # <- The extra hyphens do not affect the job's execution.
        when: manual
        allow_failure: true
  ```

## Commit changes to CI configuration

The commit form appears at the bottom of each tab in the editor so you can commit
your changes at any time.

When you are satisfied with your changes, add a descriptive commit message and enter
a branch. The branch field defaults to your project's default branch.

If you enter a new branch name, the **Start a new merge request with these changes**
checkbox appears. Select it to start a new merge request after you commit the changes.

![The commit form, showing a commit message, branch, and merge request checkmark.](img/pipeline_editor_commit_v13_8.png)

## Editor accessibility options

The pipeline editor is based on the [Monaco Editor](https://github.com/microsoft/monaco-editor)
which has several [accessibility features](https://github.com/microsoft/monaco-editor/wiki/Monaco-Editor-Accessibility-Guide),
including:

| Feature                          | Shortcut on Windows or Linux      | Shortcut on macOS                                    | Details |
|----------------------------------|-----------------------------------|------------------------------------------------------|---------|
| Keyboard navigation command list | <kbd>F1</kbd>                     | <kbd>F1</kbd>                                        | A [list of commands](https://github.com/microsoft/monaco-editor/wiki/Monaco-Editor-Accessibility-Guide#keyboard-navigation) that make the editor easier to use without a mouse. |
| Tab trapping                     | <kbd>Control</kbd>+<kbd>m</kbd> | <kbd>Control</kbd>+<kbd>Shift</kbd>+<kbd>m</kbd> | Enable [tab trapping](https://github.com/microsoft/monaco-editor/wiki/Monaco-Editor-Accessibility-Guide#tab-trapping) to go to the next focusable element on the page instead of inserting a tab character. |

## Troubleshooting

### `Unable to validate CI/CD configuration.` message

This message is caused by a problem validating the syntax in the pipeline editor.
It can happen when GitLab is unable to communicate with the service that validates the syntax.

The information in these sections may not display properly:

- The syntax status on the **Edit** tab (valid or invalid).
- The **Visualize** tab.
- The **Lint** tab.
- The **Full configuration** tab.

You can still work on your CI/CD configuration and commit the changes you made without
any issues. As soon as the service becomes available again, the syntax validation
should display immediately.
