/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.gradle.api.cache.Cleanup;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.internal.cache.CacheResourceConfigurationInternal;
import org.gradle.internal.time.TimeFormatting;

public class DirectoryBuildCacheEntryRetention {
    private final Supplier<Long> entryRetentionTimestampSupplier;
    private final String retentionDescription;
    private final boolean cleanupDisabled;

    public DirectoryBuildCacheEntryRetention(CacheConfigurationsInternal cacheConfigurations) {
        this.cleanupDisabled = cacheConfigurations.getCleanup().get() == Cleanup.DISABLED;
        CacheResourceConfigurationInternal buildCacheConfig = cacheConfigurations.getBuildCache();
        this.entryRetentionTimestampSupplier = buildCacheConfig.getEntryRetentionTimestampSupplier();
        this.retentionDescription = DirectoryBuildCacheEntryRetention.describeEntryRetention((CacheResourceConfigurationInternal.EntryRetention)buildCacheConfig.getEntryRetention().get());
    }

    public Supplier<Long> getEntryRetentionTimestampSupplier() {
        return this.entryRetentionTimestampSupplier;
    }

    public String getDescription() {
        if (this.cleanupDisabled) {
            return "disabled";
        }
        return this.retentionDescription;
    }

    private static String describeEntryRetention(CacheResourceConfigurationInternal.EntryRetention entryRetention) {
        long entryRetentionMillis = entryRetention.getTimeInMillis();
        if (entryRetention.isRelative()) {
            long expiryDays = TimeUnit.MILLISECONDS.toDays(entryRetentionMillis);
            if (expiryDays >= 2L) {
                return "after " + expiryDays + " days";
            }
            return "after " + TimeFormatting.formatDurationTerse((long)entryRetentionMillis);
        }
        return "older than " + Instant.ofEpochMilli(entryRetentionMillis).atZone(ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z"));
    }
}

