/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;

class Pixelator {
    protected final Graphics3D g;
    Pixelator p0;
    protected int[] zb;
    protected int[] pb;
    int width;
    int bgcolor;

    Pixelator(Graphics3D graphics3d) {
        this.g = graphics3d;
        this.bgcolor = this.g.bgcolor;
        this.setBuf();
    }

    void setBuf() {
        this.zb = this.g.zbuf;
        this.pb = this.g.pbuf;
    }

    void clearPixel(int offset, int z) {
        if (this.zb[offset] > z) {
            this.zb[offset] = Integer.MAX_VALUE;
        }
    }

    void addPixel(int offset, int z, int p) {
        this.zb[offset] = z;
        this.pb[offset] = p;
    }

    public void addImagePixel(byte shade, int tLog, int offset, int z, int argb, int bgargb) {
        if (z < this.zb[offset]) {
            switch (shade) {
                case 0: {
                    return;
                }
                case 8: {
                    this.addPixel(offset, z, argb);
                    return;
                }
            }
            shade = (byte)(shade + tLog);
            if (shade <= 7) {
                int p = this.pb[offset];
                if (bgargb != 0) {
                    p = Graphics3D.mergeBufferPixel(p, bgargb, bgargb);
                }
                p = Graphics3D.mergeBufferPixel(p, argb & 0xFFFFFF | shade << 24, this.bgcolor);
                this.addPixel(offset, z, p);
            }
        }
    }
}

