/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.sf.juife.EnhancedDialog;
import net.sf.juife.JuifeUtils;
import net.sf.juife.plaf.WizardUI;
import net.sf.juife.wizard.DefaultWizardModel;
import net.sf.juife.wizard.WizardModel;
import net.sf.juife.wizard.WizardPage;

public class Wizard
extends JPanel {
    private static final String uiClassID = "WizardUI";
    public static final String BACK_BUTTON_ICON = "Wizard.backButtonIcon";
    public static final String NEXT_BUTTON_ICON = "Wizard.nextButtonIcon";
    public static final String LEFT_PANE_BACKGROUND_COLOR = "Wizard.leftPaneBackgroundColor";
    public static final String LEFT_PANE_FOREGROUND_COLOR = "Wizard.leftPaneForegroundColor";
    private final WizardDialog wizardDialog;
    private WizardModel model = new DefaultWizardModel();
    private final Handler handler = new Handler();

    public Wizard(Frame owner, String title) {
        this(owner, title, (WizardModel)new DefaultWizardModel());
    }

    public Wizard(Frame owner, String title, WizardModel model) {
        this.wizardDialog = new WizardDialog(owner, title, true);
        this.initWizard();
        this.setModel(model);
    }

    public Wizard(Dialog owner, String title) {
        this(owner, title, (WizardModel)new DefaultWizardModel());
    }

    public Wizard(Dialog owner, String title, WizardModel model) {
        this.wizardDialog = new WizardDialog(owner, title, true);
        this.initWizard();
        this.setModel(model);
    }

    private void initWizard() {
        this.wizardDialog.getContentPane().add(this);
        this.wizardDialog.pack();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public WizardUI getUI() {
        return (WizardUI)this.ui;
    }

    public void setUI(WizardUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((WizardUI)UIManager.getUI(this));
    }

    public void setModal(Boolean modal) {
        this.wizardDialog.setModal(modal);
    }

    public WizardModel getModel() {
        return this.model;
    }

    public void setModel(WizardModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model must be non null");
        }
        WizardModel oldModel = this.model;
        this.model = model;
        if (oldModel != null) {
            oldModel.removeActionListener(this.getHandler());
        }
        model.addActionListener(this.getHandler());
        this.firePropertyChange("model", oldModel, this.model);
    }

    public void closeWizard() {
        if (!this.getCurrentPage().mayClose()) {
            return;
        }
        this.wizardDialog.setVisible(false);
    }

    public void cancelWizard() {
        if (!this.getCurrentPage().mayCancel()) {
            return;
        }
        this.wizardDialog.setVisible(false);
    }

    public void finishWizard() {
        if (!this.getModel().getCurrentPage().mayFinish()) {
            return;
        }
        if (!this.getModel().hasNext()) {
            this.wizardDialog.setVisible(false);
        } else {
            this.getModel().next();
        }
    }

    public WizardPage getCurrentPage() {
        return this.getModel().getCurrentPage();
    }

    public void showWizard() {
        if (this.getModel().getCurrentPage() == null) {
            this.getModel().next();
        }
        this.wizardDialog.setLocation(JuifeUtils.centerLocation(this.wizardDialog, this.wizardDialog.getParent()));
        this.wizardDialog.setVisible(true);
    }

    public void enableNextButton(boolean enable) {
        this.getUI().enableNextButton(enable);
    }

    public void enableFinishButton(boolean enable) {
        this.getUI().enableFinishButton(enable);
    }

    public JDialog getWizardDialog() {
        return this.wizardDialog;
    }

    private Handler getHandler() {
        return this.handler;
    }

    static {
        UIManager.put(uiClassID, "net.sf.juife.plaf.basic.BasicWizardUI");
    }

    private class Handler
    implements ActionListener {
        private Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Wizard.this.getCurrentPage().setWizard(Wizard.this);
            Wizard.this.getCurrentPage().preinitPage();
        }
    }

    private class WizardDialog
    extends EnhancedDialog {
        WizardDialog(Frame owner, String title, boolean modal) {
            super(owner, title, modal);
            this.initWizardDialog();
        }

        WizardDialog(Dialog owner, String title, boolean modal) {
            super(owner, title, modal);
            this.initWizardDialog();
        }

        private void initWizardDialog() {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    WizardDialog.this.onCancel();
                }
            });
        }

        @Override
        protected void onOk() {
        }

        @Override
        protected void onCancel() {
            if (Wizard.this.getCurrentPage().getPageType() == WizardPage.Type.SUMMARY_PAGE) {
                Wizard.this.closeWizard();
                return;
            }
            if (Wizard.this.getUI().mayCancelWizard()) {
                Wizard.this.cancelWizard();
            }
        }
    }
}

