/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util.json;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Optional;
import org.apache.kafka.server.util.json.DecodeJson;
import org.apache.kafka.server.util.json.JsonArray;
import org.apache.kafka.server.util.json.JsonObject;

public interface JsonValue {
    public JsonNode node();

    default public <T> T to(DecodeJson<T> decodeJson) throws JsonMappingException {
        return decodeJson.decode(this.node());
    }

    default public JsonObject asJsonObject() throws JsonMappingException {
        return this.asJsonObjectOptional().orElseThrow(() -> new JsonMappingException(null, String.format("Expected JSON object, received %s", this.node())));
    }

    default public Optional<JsonObject> asJsonObjectOptional() {
        if (this instanceof JsonObject) {
            return Optional.of((JsonObject)this);
        }
        if (this.node() instanceof ObjectNode) {
            return Optional.of(new JsonObject((ObjectNode)this.node()));
        }
        return Optional.empty();
    }

    default public JsonArray asJsonArray() throws JsonMappingException {
        return this.asJsonArrayOptional().orElseThrow(() -> new JsonMappingException(null, String.format("Expected JSON array, received %s", this.node())));
    }

    default public Optional<JsonArray> asJsonArrayOptional() {
        if (this instanceof JsonArray) {
            return Optional.of((JsonArray)this);
        }
        if (this.node() instanceof ArrayNode) {
            return Optional.of(new JsonArray((ArrayNode)this.node()));
        }
        return Optional.empty();
    }

    public static JsonValue apply(JsonNode node) {
        if (node instanceof ObjectNode) {
            return new JsonObject((ObjectNode)node);
        }
        if (node instanceof ArrayNode) {
            return new JsonArray((ArrayNode)node);
        }
        return new BasicJsonValue(node);
    }

    public static class BasicJsonValue
    implements JsonValue {
        protected JsonNode node;

        BasicJsonValue(JsonNode node) {
            this.node = node;
        }

        @Override
        public JsonNode node() {
            return this.node;
        }

        public int hashCode() {
            return this.node().hashCode();
        }

        public boolean equals(Object a) {
            if (a instanceof BasicJsonValue) {
                return this.node().equals((Object)((BasicJsonValue)a).node());
            }
            return false;
        }

        public String toString() {
            return this.node().toString();
        }
    }
}

