/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.internals.KStreamKTableJoinProcessor;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.state.StoreBuilder;

class KStreamKTableJoin<StreamKey, StreamValue, TableValue, VOut>
implements ProcessorSupplier<StreamKey, StreamValue, StreamKey, VOut> {
    private final KeyValueMapper<StreamKey, StreamValue, StreamKey> keyValueMapper = (key, value) -> key;
    private final KTableValueGetterSupplier<StreamKey, TableValue> valueGetterSupplier;
    private final ValueJoinerWithKey<? super StreamKey, ? super StreamValue, ? super TableValue, ? extends VOut> joiner;
    private final boolean leftJoin;
    private final Optional<Duration> gracePeriod;
    private final Optional<String> storeName;
    private final Set<StoreBuilder<?>> stores;

    KStreamKTableJoin(KTableValueGetterSupplier<StreamKey, TableValue> valueGetterSupplier, ValueJoinerWithKey<? super StreamKey, ? super StreamValue, ? super TableValue, ? extends VOut> joiner, boolean leftJoin, Optional<Duration> gracePeriod, Optional<StoreBuilder<?>> bufferStoreBuilder) {
        this.valueGetterSupplier = valueGetterSupplier;
        this.joiner = joiner;
        this.leftJoin = leftJoin;
        this.gracePeriod = gracePeriod;
        this.storeName = bufferStoreBuilder.map(StoreBuilder::name);
        this.stores = bufferStoreBuilder.map(Collections::singleton).orElse(null);
    }

    @Override
    public Set<StoreBuilder<?>> stores() {
        return this.stores;
    }

    @Override
    public Processor<StreamKey, StreamValue, StreamKey, VOut> get() {
        return new KStreamKTableJoinProcessor<StreamKey, StreamValue, StreamKey, TableValue, VOut>(this.valueGetterSupplier.get(), this.keyValueMapper, this.joiner, this.leftJoin, this.gracePeriod, this.storeName);
    }
}

