/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals.metrics;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsClientMetricsDelegatingReporter
implements MetricsReporter {
    private static final Logger log = LoggerFactory.getLogger(StreamsClientMetricsDelegatingReporter.class);
    private final Admin adminClient;

    public StreamsClientMetricsDelegatingReporter(Admin adminClient, String streamsClientId) {
        this.adminClient = Objects.requireNonNull(adminClient);
        log.debug("Creating Client Metrics reporter for streams client {}", (Object)streamsClientId);
    }

    public void init(List<KafkaMetric> metrics) {
        metrics.forEach(this::metricChange);
    }

    public void metricChange(KafkaMetric metric) {
        if (this.isStreamsClientMetric(metric)) {
            log.debug("Registering metric {}", (Object)metric.metricName());
            this.adminClient.registerMetricForSubscription(metric);
        }
    }

    private boolean isStreamsClientMetric(KafkaMetric metric) {
        boolean shouldInclude = metric.metricName().group().equals("stream-metrics");
        if (!shouldInclude) {
            log.trace("Rejecting thread metric {}", (Object)metric.metricName());
        }
        return shouldInclude;
    }

    public void metricRemoval(KafkaMetric metric) {
        if (this.isStreamsClientMetric(metric)) {
            log.debug("Unregistering metric {}", (Object)metric.metricName());
            this.adminClient.unregisterMetricFromSubscription(metric);
        }
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
    }
}

