/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.codestarts.CodestartProjectDefinition;
import io.quarkus.devtools.codestarts.CodestartType;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartCatalog;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartProjectInput;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.CreateProjectCodestartDataConverter;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.CatalogMergeUtility;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.catalog.selection.ExtensionOrigins;
import io.quarkus.registry.catalog.selection.OriginCombination;
import io.quarkus.registry.catalog.selection.OriginPreference;
import io.quarkus.registry.catalog.selection.OriginSelector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class CreateProjectCommandHandler
implements QuarkusCommandHandler {
    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        Map<String, Object> platformProjectData;
        Set<String> extensionsQuery = invocation.getValue("project.extensions", Set.of());
        String className = invocation.getStringValue("project.resource.class-name");
        String pkgName = invocation.getStringValue("project.package-name");
        String groupId = invocation.getStringValue("project.group-id");
        if (pkgName == null) {
            if (className != null && className.contains(".")) {
                int idx = className.lastIndexOf(46);
                invocation.setValue("project.package-name", className.substring(0, idx));
                invocation.setValue("project.resource.class-name", className.substring(idx + 1));
            } else if (groupId != null) {
                invocation.setValue("project.package-name", groupId.replace('-', '.').replace('_', '.'));
            }
        }
        List<Extension> extensionsToAdd = this.computeRequiredExtensions(invocation.getExtensionsCatalog(), extensionsQuery, invocation.log());
        ExtensionCatalog mainCatalog = invocation.getExtensionsCatalog();
        String javaVersion = invocation.getStringValue("project.java-version");
        this.checkMinimumJavaVersion(javaVersion, extensionsToAdd);
        List<ExtensionCatalog> extensionOrigins = CreateProjectCommandHandler.getExtensionOrigins(mainCatalog, extensionsToAdd);
        ArrayList<ArtifactCoords> platformBoms = new ArrayList<ArtifactCoords>(Math.max(extensionOrigins.size(), 1));
        if (!extensionOrigins.isEmpty()) {
            ExtensionCatalog mergedCatalog = CatalogMergeUtility.merge(extensionOrigins);
            platformProjectData = ToolsUtils.readProjectData(mergedCatalog);
            CreateProjectCommandHandler.setQuarkusProperties(invocation, mergedCatalog);
            extensionsToAdd = this.computeRequiredExtensions(mergedCatalog, extensionsQuery, invocation.log());
            boolean sawFirstPlatform = false;
            for (ExtensionCatalog c : extensionOrigins) {
                if (!c.isPlatform()) continue;
                if (c.getBom().getArtifactId().equals("quarkus-bom") || !sawFirstPlatform) {
                    mainCatalog = c;
                    sawFirstPlatform = true;
                }
                platformBoms.add(c.getBom());
            }
        } else {
            platformProjectData = ToolsUtils.readProjectData(mainCatalog);
            platformBoms.add(mainCatalog.getBom());
            CreateProjectCommandHandler.setQuarkusProperties(invocation, mainCatalog);
        }
        ArrayList<ArtifactCoords> extensionCoords = new ArrayList<ArtifactCoords>(extensionsToAdd.size());
        for (Extension e2 : extensionsToAdd) {
            ArtifactCoords coords = e2.getArtifact();
            for (ExtensionOrigin origin : e2.getOrigins()) {
                if (!origin.isPlatform() || origin.getBom() == null || !platformBoms.contains(origin.getBom())) continue;
                coords = Extensions.stripVersion(coords);
                break;
            }
            extensionCoords.add(coords);
        }
        invocation.setValue("bom.group-id", mainCatalog.getBom().getGroupId());
        invocation.setValue("bom.artifact-id", mainCatalog.getBom().getArtifactId());
        invocation.setValue("bom.version", mainCatalog.getBom().getVersion());
        invocation.setValue("quarkus-version", mainCatalog.getQuarkusCoreVersion());
        try {
            HashMap platformData = new HashMap();
            if (mainCatalog.getMetadata().get("maven") != null) {
                platformData.put("maven", mainCatalog.getMetadata().get("maven"));
            }
            if (mainCatalog.getMetadata().get("gradle") != null) {
                platformData.put("gradle", mainCatalog.getMetadata().get("gradle"));
            }
            QuarkusCodestartProjectInput input = QuarkusCodestartProjectInput.builder().addPlatforms(platformBoms).addExtensions(extensionCoords).buildTool(invocation.getQuarkusProject().getBuildTool()).example((String)invocation.getValue("codegen.example")).noCode(invocation.getValue("codegen.no-code", false)).addCodestarts((Collection)invocation.getValue("codegen.extra-codestarts", Set.of())).noBuildToolWrapper(invocation.getValue("codegen.no-buildtool-wrapper", false)).noDockerfiles(invocation.getValue("codegen.no-dockerfiles", false)).addData((Map)platformProjectData).addData((Map)platformData).addData((Map)CreateProjectCodestartDataConverter.toCodestartData(invocation.getValues())).addData(invocation.getValue("data", Map.of())).messageWriter(invocation.log()).defaultCodestart(CreateProjectCommandHandler.getDefaultCodestart(mainCatalog)).build();
            invocation.log().info("-----------");
            if (!extensionsToAdd.isEmpty()) {
                invocation.log().info("selected extensions: \n" + extensionsToAdd.stream().map(e -> "- " + e.getArtifact().getGroupId() + ":" + e.getArtifact().getArtifactId() + "\n").collect(Collectors.joining()));
            }
            QuarkusCodestartCatalog catalog = QuarkusCodestartCatalog.fromExtensionsCatalog(invocation.getQuarkusProject().getExtensionsCatalog(), invocation.getQuarkusProject().getCodestartResourceLoaders());
            CodestartProjectDefinition projectDefinition = catalog.createProject(input);
            projectDefinition.generate(invocation.getQuarkusProject().getProjectDirPath());
            invocation.log().info("\n-----------\n" + String.valueOf(MessageIcons.SUCCESS_ICON) + " " + projectDefinition.getRequiredCodestart(CodestartType.PROJECT).getName() + " project has been successfully generated in:\n--> " + invocation.getQuarkusProject().getProjectDirPath().toString() + "\n-----------");
        }
        catch (IOException e3) {
            throw new QuarkusCommandException("Failed to create project: " + e3.getMessage(), e3);
        }
        return QuarkusCommandOutcome.success();
    }

    private static void setQuarkusProperties(QuarkusCommandInvocation invocation, ExtensionCatalog catalog) {
        Properties quarkusProps = ToolsUtils.readQuarkusProperties(catalog);
        quarkusProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String name = k.toString();
            if (!invocation.hasValue(name)) {
                invocation.setValue(name, v.toString());
            }
        }));
    }

    private List<Extension> computeRequiredExtensions(ExtensionCatalog catalog, Set<String> extensionsQuery, MessageWriter log) throws QuarkusCommandException {
        List<Extension> extensionsToAdd = QuarkusCommandHandlers.computeExtensionsFromQuery(catalog, extensionsQuery, log);
        if (extensionsToAdd == null) {
            throw new QuarkusCommandException("Failed to create project because of invalid extensions");
        }
        return extensionsToAdd;
    }

    private static List<ExtensionCatalog> getExtensionOrigins(ExtensionCatalog extensionCatalog, List<Extension> extensionsToAdd) throws QuarkusCommandException {
        ArrayList<ExtensionOrigins> originsWithPreferences;
        if (extensionsToAdd.isEmpty() && extensionCatalog.isPlatform()) {
            return List.of(extensionCatalog);
        }
        Extension quarkusCore = CreateProjectCommandHandler.findQuarkusCore(extensionCatalog);
        if (extensionsToAdd.isEmpty()) {
            if (quarkusCore.getOrigins().size() == 1 && quarkusCore.getOrigins().get(0) instanceof ExtensionCatalog) {
                return List.of((ExtensionCatalog)quarkusCore.getOrigins().get(0));
            }
            originsWithPreferences = new ArrayList(quarkusCore.getOrigins().size());
            extensionsToAdd = List.of(quarkusCore);
        } else {
            originsWithPreferences = new ArrayList<ExtensionOrigins>();
            for (Extension e : extensionsToAdd) {
                CreateProjectCommandHandler.addOriginsWithPreferences(originsWithPreferences, e);
            }
        }
        CreateProjectCommandHandler.addOriginsWithPreferences(originsWithPreferences, quarkusCore);
        if (!originsWithPreferences.isEmpty()) {
            return CreateProjectCommandHandler.getRecommendedOrigins(extensionsToAdd, originsWithPreferences);
        }
        if (extensionCatalog.isPlatform()) {
            return List.of(extensionCatalog);
        }
        HashMap<String, ExtensionCatalog> catalogMap = new HashMap<String, ExtensionCatalog>();
        for (Extension e : extensionsToAdd) {
            ExtensionOrigin origin = (ExtensionOrigin)e.getOrigins().get(0);
            if (!(origin instanceof ExtensionCatalog)) continue;
            catalogMap.putIfAbsent(origin.getId(), (ExtensionCatalog)origin);
        }
        return List.copyOf(catalogMap.values());
    }

    private static List<ExtensionCatalog> getRecommendedOrigins(List<Extension> extensionsToAdd, List<ExtensionOrigins> extOrigins) throws QuarkusCommandException {
        OriginCombination recommendedCombination = OriginSelector.of(extOrigins).calculateRecommendedCombination();
        if (recommendedCombination == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("Failed to determine a compatible Quarkus version for the requested extensions: ");
            buf.append(extensionsToAdd.get(0).getArtifact().getKey().toGacString());
            for (int i = 1; i < extensionsToAdd.size(); ++i) {
                buf.append(", ").append(extensionsToAdd.get(i).getArtifact().getKey().toGacString());
            }
            throw new QuarkusCommandException(buf.toString());
        }
        return recommendedCombination.getUniqueSortedCatalogs();
    }

    private static Extension findQuarkusCore(ExtensionCatalog extensionCatalog) throws QuarkusCommandException {
        Optional<Extension> quarkusCore = extensionCatalog.getExtensions().stream().filter(e -> e.getArtifact().getArtifactId().equals("quarkus-core")).findFirst();
        if (quarkusCore.isEmpty()) {
            throw new QuarkusCommandException("Failed to locate quarkus-core in the extension catalog");
        }
        return quarkusCore.get();
    }

    private static void addOriginsWithPreferences(List<ExtensionOrigins> extOrigins, Extension e) {
        ExtensionOrigins.Builder eoBuilder = null;
        for (ExtensionOrigin c : e.getOrigins()) {
            OriginPreference op;
            if (!(c instanceof ExtensionCatalog) || (op = (OriginPreference)c.getMetadata().get("origin-preference")) == null) continue;
            if (eoBuilder == null) {
                eoBuilder = ExtensionOrigins.builder((ArtifactKey)e.getArtifact().getKey());
            }
            eoBuilder.addOrigin((ExtensionCatalog)c, op);
        }
        if (eoBuilder != null) {
            extOrigins.add(eoBuilder.build());
        }
    }

    private void checkMinimumJavaVersion(String javaVersionString, List<Extension> extensions) throws QuarkusCommandException {
        ArrayList<Extension> incompatibleExtensions = new ArrayList<Extension>();
        int javaVersion = javaVersionString == null ? 17 : Integer.parseInt(javaVersionString);
        for (Extension extension : extensions) {
            Integer extMinJavaVersion = ExtensionProcessor.getMinimumJavaVersion(extension);
            if (extMinJavaVersion == null || javaVersion >= extMinJavaVersion) continue;
            incompatibleExtensions.add(extension);
        }
        if (!incompatibleExtensions.isEmpty()) {
            String list = incompatibleExtensions.stream().map(e -> String.format("- %s (min: %s)", e.managementKey(), ExtensionProcessor.getMinimumJavaVersion(e))).collect(Collectors.joining("\n  "));
            throw new QuarkusCommandException(String.format("Some extensions are not compatible with the selected Java version (%s):\n %s", javaVersion, list));
        }
    }

    private static String getDefaultCodestart(ExtensionCatalog catalog) {
        Object defaultCodestart;
        Object projectMetadata;
        Map map = catalog.getMetadata();
        if (map != null && !map.isEmpty() && (projectMetadata = map.get("project")) instanceof Map && (defaultCodestart = ((Map)projectMetadata).get("default-codestart")) != null && defaultCodestart instanceof String) {
            return defaultCodestart.toString();
        }
        return "resteasy-reactive";
    }
}

