/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health.checks;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.function.Function;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

public abstract class AbstractHeapMemoryHealthCheck
implements HealthCheck {
    double maxPercentage = 0.9;

    public AbstractHeapMemoryHealthCheck() {
    }

    public AbstractHeapMemoryHealthCheck(double maxPercentage) {
        this.maxPercentage = maxPercentage;
    }

    protected HealthCheckResponse getHealthCheckResponse(Function<MemoryMXBean, MemoryUsage> memoryUsageFunction) {
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryUsageFunction.apply(memoryBean);
        long memUsed = memoryUsage.getUsed();
        long memMax = memoryUsage.getMax();
        HealthCheckResponseBuilder responseBuilder = HealthCheckResponse.named((String)this.name()).withData("used", memUsed).withData("max", memMax).withData("max %", String.valueOf(this.maxPercentage));
        if (memMax > 0L) {
            boolean status = (double)memUsed < (double)memMax * this.maxPercentage;
            return responseBuilder.status(status).build();
        }
        return responseBuilder.up().build();
    }

    abstract String name();
}

