/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.common.exception;

import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.ValidationAspect;
import org.opensearch.timeseries.model.ValidationIssueType;

public class ValidationException
extends TimeSeriesException {
    private final ValidationIssueType type;
    private final ValidationAspect aspect;
    private final IntervalTimeConfiguration intervalSuggestion;

    public ValidationIssueType getType() {
        return this.type;
    }

    public ValidationAspect getAspect() {
        return this.aspect;
    }

    public IntervalTimeConfiguration getIntervalSuggestion() {
        return this.intervalSuggestion;
    }

    public ValidationException(String message, ValidationIssueType type, ValidationAspect aspect) {
        this(message, null, type, aspect, null);
    }

    public ValidationException(String message, ValidationIssueType type, ValidationAspect aspect, IntervalTimeConfiguration intervalSuggestion) {
        this(message, null, type, aspect, intervalSuggestion);
    }

    public ValidationException(String message, Throwable cause, ValidationIssueType type, ValidationAspect aspect, IntervalTimeConfiguration intervalSuggestion) {
        super("", message, cause);
        this.type = type;
        this.aspect = aspect;
        this.intervalSuggestion = intervalSuggestion;
    }

    @Override
    public String toString() {
        String superString = super.toString();
        StringBuilder sb = new StringBuilder(superString);
        if (this.type != null) {
            sb.append(" type: ");
            sb.append(this.type.getName());
        }
        if (this.aspect != null) {
            sb.append(" aspect: ");
            sb.append(this.aspect.getName());
        }
        if (this.intervalSuggestion != null) {
            sb.append(" interval suggestion: ");
            sb.append(this.intervalSuggestion.getInterval());
            sb.append(this.intervalSuggestion.getUnit());
        }
        return sb.toString();
    }
}

