/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DistanceFeatureQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, DistanceFeatureQuery> {
    @Nonnull
    private final String field;
    @Nonnull
    private final JsonData origin;
    @Nonnull
    private final String pivot;
    public static final JsonpDeserializer<DistanceFeatureQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DistanceFeatureQuery::setupDistanceFeatureQueryDeserializer);

    private DistanceFeatureQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.origin = ApiTypeHelper.requireNonNull(builder.origin, this, "origin");
        this.pivot = ApiTypeHelper.requireNonNull(builder.pivot, this, "pivot");
    }

    public static DistanceFeatureQuery of(Function<Builder, ObjectBuilder<DistanceFeatureQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.DistanceFeature;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nonnull
    public final JsonData origin() {
        return this.origin;
    }

    @Nonnull
    public final String pivot() {
        return this.pivot;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("origin");
        this.origin.serialize(generator, mapper);
        generator.writeKey("pivot");
        generator.write(this.pivot);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDistanceFeatureQueryDeserializer(ObjectDeserializer<Builder> op) {
        DistanceFeatureQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::origin, JsonData._DESERIALIZER, "origin");
        op.add(Builder::pivot, JsonpDeserializer.stringDeserializer(), "pivot");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.origin.hashCode();
        result = 31 * result + this.pivot.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistanceFeatureQuery other = (DistanceFeatureQuery)o;
        return this.field.equals(other.field) && this.origin.equals(other.origin) && this.pivot.equals(other.pivot);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, DistanceFeatureQuery> {
        private String field;
        private JsonData origin;
        private String pivot;

        public Builder() {
        }

        private Builder(DistanceFeatureQuery o) {
            super(o);
            this.field = o.field;
            this.origin = o.origin;
            this.pivot = o.pivot;
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.origin = o.origin;
            this.pivot = o.pivot;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder origin(JsonData value) {
            this.origin = value;
            return this;
        }

        @Nonnull
        public final Builder pivot(String value) {
            this.pivot = value;
            return this;
        }

        @Override
        @Nonnull
        public DistanceFeatureQuery build() {
            this._checkSingleUse();
            return new DistanceFeatureQuery(this);
        }
    }
}

