/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch.indices.Alias;
import org.opensearch.client.opensearch.indices.PutTemplateResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class PutTemplateRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PutTemplateRequest> {
    @Nonnull
    private final Map<String, Alias> aliases;
    @Nullable
    private final Time clusterManagerTimeout;
    @Nullable
    private final Boolean create;
    @Nonnull
    private final List<String> indexPatterns;
    @Nullable
    private final TypeMapping mappings;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nonnull
    private final String name;
    @Nullable
    private final Integer order;
    @Nonnull
    private final Map<String, JsonData> settings;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<PutTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutTemplateRequest::setupPutTemplateRequestDeserializer);
    public static final Endpoint<PutTemplateRequest, PutTemplateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutTemplateRequest, PutTemplateResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_template/");
        SimpleEndpoint.pathEncode(request.name, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutTemplateResponse._DESERIALIZER);

    private PutTemplateRequest(Builder builder) {
        super(builder);
        this.aliases = ApiTypeHelper.unmodifiable(builder.aliases);
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.create = builder.create;
        this.indexPatterns = ApiTypeHelper.unmodifiable(builder.indexPatterns);
        this.mappings = builder.mappings;
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.order = builder.order;
        this.settings = ApiTypeHelper.unmodifiable(builder.settings);
        this.version = builder.version;
    }

    public static PutTemplateRequest of(Function<Builder, ObjectBuilder<PutTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, Alias> aliases() {
        return this.aliases;
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nullable
    public final Boolean create() {
        return this.create;
    }

    @Nonnull
    public final List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Nullable
    public final TypeMapping mappings() {
        return this.mappings;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nullable
    public final Integer order() {
        return this.order;
    }

    @Nonnull
    public final Map<String, JsonData> settings() {
        return this.settings;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartObject();
            for (Map.Entry entry : this.aliases.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((Alias)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indexPatterns)) {
            generator.writeKey("index_patterns");
            generator.writeStartArray();
            for (String string : this.indexPatterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.mappings != null) {
            generator.writeKey("mappings");
            this.mappings.serialize(generator, mapper);
        }
        if (this.order != null) {
            generator.writeKey("order");
            generator.write(this.order.intValue());
        }
        if (ApiTypeHelper.isDefined(this.settings)) {
            generator.writeKey("settings");
            generator.writeStartObject();
            for (Map.Entry entry : this.settings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPutTemplateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(Alias._DESERIALIZER), "aliases");
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns");
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings");
        op.add(Builder::order, JsonpDeserializer.integerDeserializer(), "order");
        op.add(Builder::settings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "settings");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.create != null) {
            params.put("create", String.valueOf(this.create));
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.aliases);
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.create);
        result = 31 * result + Objects.hashCode(this.indexPatterns);
        result = 31 * result + Objects.hashCode(this.mappings);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.order);
        result = 31 * result + Objects.hashCode(this.settings);
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutTemplateRequest other = (PutTemplateRequest)o;
        return Objects.equals(this.aliases, other.aliases) && Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.create, other.create) && Objects.equals(this.indexPatterns, other.indexPatterns) && Objects.equals(this.mappings, other.mappings) && Objects.equals(this.masterTimeout, other.masterTimeout) && this.name.equals(other.name) && Objects.equals(this.order, other.order) && Objects.equals(this.settings, other.settings) && Objects.equals(this.version, other.version);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PutTemplateRequest> {
        @Nullable
        private Map<String, Alias> aliases;
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private Boolean create;
        @Nullable
        private List<String> indexPatterns;
        @Nullable
        private TypeMapping mappings;
        @Nullable
        private Time masterTimeout;
        private String name;
        @Nullable
        private Integer order;
        @Nullable
        private Map<String, JsonData> settings;
        @Nullable
        private Long version;

        public Builder() {
        }

        private Builder(PutTemplateRequest o) {
            super(o);
            this.aliases = Builder._mapCopy(o.aliases);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.create = o.create;
            this.indexPatterns = Builder._listCopy(o.indexPatterns);
            this.mappings = o.mappings;
            this.masterTimeout = o.masterTimeout;
            this.name = o.name;
            this.order = o.order;
            this.settings = Builder._mapCopy(o.settings);
            this.version = o.version;
        }

        private Builder(Builder o) {
            super(o);
            this.aliases = Builder._mapCopy(o.aliases);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.create = o.create;
            this.indexPatterns = Builder._listCopy(o.indexPatterns);
            this.mappings = o.mappings;
            this.masterTimeout = o.masterTimeout;
            this.name = o.name;
            this.order = o.order;
            this.settings = Builder._mapCopy(o.settings);
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder aliases(Map<String, Alias> map) {
            this.aliases = Builder._mapPutAll(this.aliases, map);
            return this;
        }

        @Nonnull
        public final Builder aliases(String key, Alias value) {
            this.aliases = Builder._mapPut(this.aliases, key, value);
            return this;
        }

        @Nonnull
        public final Builder aliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.aliases(key, fn.apply(new Alias.Builder()).build());
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder create(@Nullable Boolean value) {
            this.create = value;
            return this;
        }

        @Nonnull
        public final Builder indexPatterns(List<String> list) {
            this.indexPatterns = Builder._listAddAll(this.indexPatterns, list);
            return this;
        }

        @Nonnull
        public final Builder indexPatterns(String value, String ... values) {
            this.indexPatterns = Builder._listAdd(this.indexPatterns, value, values);
            return this;
        }

        @Nonnull
        public final Builder mappings(@Nullable TypeMapping value) {
            this.mappings = value;
            return this;
        }

        @Nonnull
        public final Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder order(@Nullable Integer value) {
            this.order = value;
            return this;
        }

        @Nonnull
        public final Builder settings(Map<String, JsonData> map) {
            this.settings = Builder._mapPutAll(this.settings, map);
            return this;
        }

        @Nonnull
        public final Builder settings(String key, JsonData value) {
            this.settings = Builder._mapPut(this.settings, key, value);
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public PutTemplateRequest build() {
            this._checkSingleUse();
            return new PutTemplateRequest(this);
        }
    }
}

