/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.instantiator.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.ProtectionDomain;
import org.objenesis.ObjenesisException;
import org.objenesis.instantiator.util.UnsafeUtils;
import org.objenesis.strategy.PlatformDescription;
import sun.misc.Unsafe;

public final class DefineClassHelper {
    private static final Helper privileged = PlatformDescription.isAfterJava11() ? new Java11() : new Java8();

    public static Class<?> defineClass(String name, byte[] b, int off, int len, Class<?> neighbor, ClassLoader loader, ProtectionDomain protectionDomain) {
        return privileged.defineClass(name, b, off, len, neighbor, loader, protectionDomain);
    }

    private DefineClassHelper() {
    }

    private static class Java11
    extends Helper {
        private final Class<?> module = this.module();
        private final MethodHandles.Lookup lookup = MethodHandles.lookup();
        private final MethodHandle getModule = this.getModule();
        private final MethodHandle addReads = this.addReads();
        private final MethodHandle privateLookupIn = this.privateLookupIn();
        private final MethodHandle defineClass = this.defineClass();

        private Java11() {
        }

        private Class<?> module() {
            try {
                return Class.forName("java.lang.Module");
            }
            catch (ClassNotFoundException e) {
                throw new ObjenesisException(e);
            }
        }

        private MethodHandle getModule() {
            try {
                return this.lookup.findVirtual(Class.class, "getModule", MethodType.methodType(this.module));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new ObjenesisException(e);
            }
        }

        private MethodHandle addReads() {
            try {
                return this.lookup.findVirtual(this.module, "addReads", MethodType.methodType(this.module, this.module));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new ObjenesisException(e);
            }
        }

        private MethodHandle privateLookupIn() {
            try {
                return this.lookup.findStatic(MethodHandles.class, "privateLookupIn", MethodType.methodType(MethodHandles.Lookup.class, Class.class, MethodHandles.Lookup.class));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new ObjenesisException(e);
            }
        }

        private MethodHandle defineClass() {
            try {
                return this.lookup.findVirtual(MethodHandles.Lookup.class, "defineClass", MethodType.methodType(Class.class, byte[].class));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new ObjenesisException(e);
            }
        }

        @Override
        Class<?> defineClass(String className, byte[] b, int off, int len, Class<?> neighbor, ClassLoader loader, ProtectionDomain protectionDomain) {
            try {
                Object module = this.getModule.invokeWithArguments(DefineClassHelper.class);
                Object neighborModule = this.getModule.invokeWithArguments(neighbor);
                this.addReads.invokeWithArguments(module, neighborModule);
                MethodHandles.Lookup prvlookup = this.privateLookupIn.invokeExact(neighbor, this.lookup);
                return this.defineClass.invokeExact(prvlookup, b);
            }
            catch (Throwable e) {
                throw new ObjenesisException(neighbor.getName() + " has no permission to define the class", e);
            }
        }
    }

    private static class Java8
    extends Helper {
        private final MethodHandle defineClass = this.defineClass();

        private Java8() {
        }

        private MethodHandle defineClass() {
            MethodHandle m;
            MethodType mt = MethodType.methodType(Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
            try {
                m = MethodHandles.publicLookup().findVirtual(Unsafe.class, "defineClass", mt);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new ObjenesisException(e);
            }
            Unsafe unsafe = UnsafeUtils.getUnsafe();
            return m.bindTo(unsafe);
        }

        @Override
        Class<?> defineClass(String className, byte[] b, int off, int len, Class<?> neighbor, ClassLoader loader, ProtectionDomain protectionDomain) {
            try {
                return this.defineClass.invokeExact(className, b, off, len, loader, protectionDomain);
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ObjenesisException(e);
            }
        }
    }

    private static abstract class Helper {
        private Helper() {
        }

        abstract Class<?> defineClass(String var1, byte[] var2, int var3, int var4, Class<?> var5, ClassLoader var6, ProtectionDomain var7);
    }
}

