/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.security.securityconf.ConfigModel;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.RoleMappingsV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.support.ConfigConstants;
import org.opensearch.security.support.HostResolverMode;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;

public class ConfigModelV7
extends ConfigModel {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private ConfigConstants.RolesMappingResolution rolesMappingResolution;
    private RoleMappingHolder roleMappingHolder;
    private SecurityDynamicConfiguration<RoleV7> roles;

    public ConfigModelV7(SecurityDynamicConfiguration<RoleV7> roles, SecurityDynamicConfiguration<RoleMappingsV7> rolemappings, DynamicConfigModel dcm, Settings opensearchSettings) {
        this.roles = roles;
        try {
            this.rolesMappingResolution = ConfigConstants.RolesMappingResolution.valueOf(opensearchSettings.get("plugins.security.roles_mapping_resolution", ConfigConstants.RolesMappingResolution.MAPPING_ONLY.toString()).toUpperCase());
        }
        catch (Exception e) {
            this.log.error("Cannot apply roles mapping resolution", (Throwable)e);
            this.rolesMappingResolution = ConfigConstants.RolesMappingResolution.MAPPING_ONLY;
        }
        this.roleMappingHolder = new RoleMappingHolder(rolemappings, dcm.getHostsResolverMode());
    }

    @Override
    public Set<String> mapSecurityRoles(User user, TransportAddress caller) {
        return this.roleMappingHolder.map(user, caller);
    }

    private class RoleMappingHolder {
        private ListMultimap<String, String> users;
        private ListMultimap<List<WildcardMatcher>, String> abars;
        private ListMultimap<String, String> bars;
        private ListMultimap<String, String> hosts;
        private final String hostResolverMode;
        private List<WildcardMatcher> userMatchers;
        private List<WildcardMatcher> barMatchers;
        private List<WildcardMatcher> hostMatchers;

        private RoleMappingHolder(SecurityDynamicConfiguration<RoleMappingsV7> rolemappings, String hostResolverMode) {
            this.hostResolverMode = hostResolverMode;
            if (ConfigModelV7.this.roles != null) {
                this.users = ArrayListMultimap.create();
                this.abars = ArrayListMultimap.create();
                this.bars = ArrayListMultimap.create();
                this.hosts = ArrayListMultimap.create();
                for (Map.Entry<String, RoleMappingsV7> roleMap : rolemappings.getCEntries().entrySet()) {
                    String roleMapKey = roleMap.getKey();
                    RoleMappingsV7 roleMapValue = roleMap.getValue();
                    for (String u : roleMapValue.getUsers()) {
                        this.users.put((Object)u, (Object)roleMapKey);
                    }
                    HashSet<String> abar = new HashSet<String>(roleMapValue.getAnd_backend_roles());
                    if (!abar.isEmpty()) {
                        this.abars.put(WildcardMatcher.matchers(abar), (Object)roleMapKey);
                    }
                    for (String bar : roleMapValue.getBackend_roles()) {
                        this.bars.put((Object)bar, (Object)roleMapKey);
                    }
                    for (String host : roleMapValue.getHosts()) {
                        this.hosts.put((Object)host, (Object)roleMapKey);
                    }
                }
                this.userMatchers = WildcardMatcher.matchers(this.users.keySet());
                this.barMatchers = WildcardMatcher.matchers(this.bars.keySet());
                this.hostMatchers = WildcardMatcher.matchers(this.hosts.keySet());
            }
        }

        private Set<String> map(User user, TransportAddress caller) {
            if (user == null || this.users == null || this.abars == null || this.bars == null || this.hosts == null) {
                return Collections.emptySet();
            }
            HashSet<String> securityRoles = new HashSet<String>((Collection<String>)user.getSecurityRoles());
            if (ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BOTH || ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BACKENDROLES_ONLY) {
                if (ConfigModelV7.this.log.isDebugEnabled()) {
                    ConfigModelV7.this.log.debug("Pass backendroles from {}", (Object)user);
                }
                securityRoles.addAll((Collection<String>)user.getRoles());
            }
            if (ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.BOTH || ConfigModelV7.this.rolesMappingResolution == ConfigConstants.RolesMappingResolution.MAPPING_ONLY) {
                for (String p2 : WildcardMatcher.getAllMatchingPatterns(this.userMatchers, user.getName())) {
                    securityRoles.addAll(this.users.get((Object)p2));
                }
                for (String p2 : WildcardMatcher.getAllMatchingPatterns(this.barMatchers, user.getRoles())) {
                    securityRoles.addAll(this.bars.get((Object)p2));
                }
                for (Object patterns : this.abars.keySet()) {
                    if (!patterns.stream().allMatch(p -> p.matchAny((Collection<String>)user.getRoles()))) continue;
                    securityRoles.addAll(this.abars.get(patterns));
                }
                if (caller != null) {
                    String ipAddress = caller.getAddress();
                    for (String p3 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, ipAddress)) {
                        securityRoles.addAll(this.hosts.get((Object)p3));
                    }
                    if (caller.address() != null && (this.hostResolverMode.equalsIgnoreCase(HostResolverMode.IP_HOSTNAME.getValue()) || this.hostResolverMode.equalsIgnoreCase(HostResolverMode.IP_HOSTNAME_LOOKUP.getValue()))) {
                        String hostName = caller.address().getHostString();
                        for (String p4 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, hostName)) {
                            securityRoles.addAll(this.hosts.get((Object)p4));
                        }
                    }
                    if (caller.address() != null && this.hostResolverMode.equalsIgnoreCase(HostResolverMode.IP_HOSTNAME_LOOKUP.getValue())) {
                        String resolvedHostName = caller.address().getHostName();
                        for (String p4 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, resolvedHostName)) {
                            securityRoles.addAll(this.hosts.get((Object)p4));
                        }
                    }
                }
            }
            return Collections.unmodifiableSet(securityRoles);
        }
    }
}

