/*
 * Decompiled with CFR 0.152.
 */
package hughai.ui;

import hughai.PlayerObjects;
import hughai.utils.ReflectionHelper;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UiReflectionHelper {
    PlayerObjects playerObjects;

    public UiReflectionHelper(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
    }

    public void dispose() {
    }

    JComponent objectToEditComponent(Object object, Annotation[] annotationArray) {
        Class<?> clazz = object.getClass();
        if (clazz == String.class) {
            JTextField jTextField = new JTextField();
            jTextField.setText("" + object);
            return jTextField;
        }
        if (clazz == Boolean.TYPE) {
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setSelected((Boolean)object);
            return jCheckBox;
        }
        if (clazz == Float.TYPE) {
            JTextField jTextField = new JTextField();
            jTextField.setText("" + object);
            return jTextField;
        }
        if (clazz == Integer.TYPE) {
            JTextField jTextField = new JTextField();
            jTextField.setText("" + object);
            return jTextField;
        }
        if (List.class.isAssignableFrom(clazz)) {
            // empty if block
        }
        for (Field field : clazz.getDeclaredFields()) {
        }
        throw new RuntimeException("UiReflectionhelper: unhandled type: " + clazz.getSimpleName());
    }

    public JComponent objectToDisplayComponent(final Object object, final Annotation[] annotationArray, DisplayContext displayContext, final boolean bl) {
        try {
            if (object == null) {
                return new JLabel("<null>");
            }
            final Class<?> clazz = object.getClass();
            if (clazz == String.class) {
                if (bl) {
                    JTextField jTextField = new JTextField();
                    jTextField.setText("" + object);
                    return jTextField;
                }
                JLabel jLabel = new JLabel();
                jLabel.setText("" + object);
                return jLabel;
            }
            if (clazz.equals(Float.class)) {
                if (bl) {
                    JTextField jTextField = new JTextField();
                    jTextField.setText("" + object);
                    return jTextField;
                }
                JLabel jLabel = new JLabel();
                jLabel.setText("" + object);
                return jLabel;
            }
            if (clazz.equals(Integer.class)) {
                if (bl) {
                    JTextField jTextField = new JTextField();
                    jTextField.setText("" + object);
                    return jTextField;
                }
                JLabel jLabel = new JLabel();
                jLabel.setText("" + object);
                return jLabel;
            }
            if (clazz.equals(Boolean.class)) {
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setEnabled(bl);
                jCheckBox.setSelected((Boolean)object);
                return jCheckBox;
            }
            if (List.class.isAssignableFrom(clazz)) {
                Class<?> clazz2 = this.getListItemClass(annotationArray);
                if (clazz2 == null) {
                    throw new RuntimeException("Missing ListTypeInfo annotation on list");
                }
                if (displayContext.equals((Object)DisplayContext.brief) || displayContext.equals((Object)DisplayContext.listrow)) {
                    final JButton jButton = new JButton("...");
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            System.out.println("creating child dialog...");
                            JDialog jDialog = UiReflectionHelper.this.createDialog(jButton, "List", true);
                            JComponent jComponent = UiReflectionHelper.this.objectToDisplayComponent(object, annotationArray, DisplayContext.detailed, bl);
                            jDialog.add(jComponent);
                            jDialog.setSize(300, 300);
                            jDialog.setVisible(true);
                        }
                    });
                    return jButton;
                }
                List list = (List)object;
                GridLayout gridLayout = new GridLayout(0, 1);
                JPanel jPanel = new JPanel(gridLayout);
                JComponent jComponent = this.listToHeaders(clazz2);
                if (jComponent != null) {
                    this.addGridLayoutRow(gridLayout);
                    jPanel.add(jComponent);
                }
                for (Object e : list) {
                    JComponent jComponent2 = this.objectToDisplayComponent(e, annotationArray, DisplayContext.listrow, bl);
                    this.addGridLayoutRow(gridLayout);
                    jPanel.add(jComponent2);
                }
                return jPanel;
            }
            if (displayContext.equals((Object)DisplayContext.brief)) {
                final JButton jButton = new JButton("...");
                jButton.setSize(50, 50);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        System.out.println("creating child dialog...");
                        JDialog jDialog = UiReflectionHelper.this.createDialog(jButton, clazz.getSimpleName(), true);
                        JComponent jComponent = UiReflectionHelper.this.objectToDisplayComponent(object, new Annotation[0], DisplayContext.detailed, bl);
                        jDialog.add(jComponent);
                        jDialog.setSize(300, 300);
                        jDialog.setVisible(true);
                    }
                });
                return jButton;
            }
            if (displayContext.equals((Object)DisplayContext.listrow)) {
                GridLayout gridLayout = new GridLayout(1, 0);
                JPanel jPanel = new JPanel(gridLayout);
                for (Field field : clazz.getDeclaredFields()) {
                    JComponent jComponent = this.objectToDisplayComponent(field.get(object), field.getAnnotations(), DisplayContext.brief, bl);
                    gridLayout.setColumns(gridLayout.getColumns() + 1);
                    jPanel.add(jComponent);
                }
                return jPanel;
            }
            GridLayout gridLayout = new GridLayout(0, 2);
            JPanel jPanel = new JPanel(gridLayout);
            for (Field field : clazz.getDeclaredFields()) {
                JLabel jLabel = new JLabel(field.getName());
                JComponent jComponent = this.objectToDisplayComponent(field.get(object), field.getAnnotations(), DisplayContext.brief, bl);
                gridLayout.setRows(gridLayout.getRows() + 1);
                jPanel.add(jLabel);
                jPanel.add(jComponent);
            }
            return jPanel;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    JComponent listToHeaders(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return null;
        }
        if (clazz.equals(String.class)) {
            return null;
        }
        GridLayout gridLayout = new GridLayout(1, 0);
        JPanel jPanel = new JPanel(gridLayout);
        for (Field field : clazz.getDeclaredFields()) {
            if (this.isExcluded(field)) continue;
            JLabel jLabel = new JLabel(field.getName());
            this.addGridLayoutColumn(gridLayout);
            jPanel.add(jLabel);
        }
        return jPanel;
    }

    void addGridLayoutRow(GridLayout gridLayout) {
        gridLayout.setRows(gridLayout.getRows() + 1);
    }

    void addGridLayoutColumn(GridLayout gridLayout) {
        gridLayout.setColumns(gridLayout.getColumns() + 1);
    }

    boolean isExcluded(Annotation[] annotationArray) {
        for (Annotation annotation : annotationArray) {
            if (!ReflectionHelper.Exclude.class.isAssignableFrom(annotation.getClass())) continue;
            return true;
        }
        return false;
    }

    boolean isExcluded(Field field) {
        return this.isExcluded(field.getAnnotations());
    }

    Class<?> getListItemClass(Annotation[] annotationArray) {
        for (Annotation annotation : annotationArray) {
            if (!ReflectionHelper.ListTypeInfo.class.isAssignableFrom(annotation.getClass())) continue;
            ReflectionHelper.ListTypeInfo listTypeInfo = (ReflectionHelper.ListTypeInfo)annotation;
            return listTypeInfo.value();
        }
        return null;
    }

    JDialog createDialog(Component component, String string, boolean bl) {
        if (JFrame.class.isAssignableFrom(component.getClass())) {
            JDialog jDialog = new JDialog((JFrame)component, string, bl);
            return jDialog;
        }
        if (JDialog.class.isAssignableFrom(component.getClass())) {
            JDialog jDialog = new JDialog((JDialog)component, string, bl);
            return jDialog;
        }
        if (component == null) {
            throw new RuntimeException("UiReflectionHelper: couldn't find parent frame or dialog");
        }
        return this.createDialog(component.getParent(), string, bl);
    }

    public static enum DisplayContext {
        detailed,
        listrow,
        brief;

    }
}

