/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.ThreadUtils;
import org.zaproxy.zap.utils.TimeStampUtils;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.view.OutputSource;

public class OutputPanel
extends AbstractPanel {
    private static final long serialVersionUID = -947074835463140074L;
    private static final String CLEAR_BUTTON_LABEL = Constant.messages.getString("output.panel.clear.button.label");
    private static final String CLEAR_BUTTON_TOOL_TIP = Constant.messages.getString("output.panel.clear.button.toolTip");
    private JPanel mainPanel;
    private JToolBar mainToolBar;
    private JScrollPane jScrollPane = null;
    private ZapTextArea txtOutput = null;

    public OutputPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setName(Constant.messages.getString("output.panel.title"));
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(243, 119);
        }
        this.setIcon(new ImageIcon(OutputPanel.class.getResource("/resource/icon/16/172.png")));
        this.setDefaultAccelerator(View.getSingleton().getMenuShortcutKeyStroke(79, 64, false));
        this.setMnemonic(Constant.messages.getChar("output.panel.mnemonic"));
        this.add((Component)this.getMainPanel(), "Center");
        this.setShowByDefault(true);
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            this.mainPanel.add((Component)this.getToolBar(), "First");
            this.mainPanel.add((Component)this.getJScrollPane(), "Center");
        }
        return this.mainPanel;
    }

    private JToolBar getToolBar() {
        if (this.mainToolBar == null) {
            this.mainToolBar = new JToolBar();
            this.mainToolBar.setEnabled(true);
            this.mainToolBar.setFloatable(false);
            this.mainToolBar.setRollover(true);
            JButton clearButton = new JButton(CLEAR_BUTTON_LABEL);
            clearButton.setToolTipText(CLEAR_BUTTON_TOOL_TIP);
            clearButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(OutputPanel.class.getResource("/resource/icon/fugue/broom.png"))));
            clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OutputPanel.this.getTxtOutput().setText("");
                }
            });
            this.mainToolBar.add(clearButton);
        }
        return this.mainToolBar;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTxtOutput());
            this.jScrollPane.setName("jScrollPane");
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
        }
        return this.jScrollPane;
    }

    private ZapTextArea getTxtOutput() {
        if (this.txtOutput == null) {
            this.txtOutput = new ZapTextArea();
            this.txtOutput.setEditable(false);
            this.txtOutput.setLineWrap(true);
            this.txtOutput.setName("");
            this.txtOutput.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showPopupMenuIfTriggered(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.showPopupMenuIfTriggered(e);
                }

                private void showPopupMenuIfTriggered(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        View.getSingleton().getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        return this.txtOutput;
    }

    @Deprecated
    public void appendDirty(String msg) {
        this.doAppend(msg);
    }

    public void append(String msg) {
        ThreadUtils.invokeAndWaitHandled(() -> this.doAppend(msg));
    }

    public void append(String msg, String sourceName) {
        ThreadUtils.invokeAndWaitHandled(() -> this.doAppend(msg, sourceName));
    }

    public void append(Exception e) {
        this.append(ExceptionUtils.getStackTrace((Throwable)e));
    }

    public void clear() {
        this.getTxtOutput().setText("");
    }

    public void clear(String sourceName) {
        this.clear();
    }

    private void doAppend(String message, String sourceName) {
        this.doAppend("[" + sourceName + "] " + message);
    }

    private void doAppend(String message) {
        if (Model.getSingleton().getOptionsParam().getViewParam().isOutputTabTimeStampingEnabled()) {
            this.getTxtOutput().append(TimeStampUtils.getTimeStampedMessage(message, Model.getSingleton().getOptionsParam().getViewParam().getOutputTabTimeStampsFormat()));
        } else {
            this.getTxtOutput().append(message);
        }
    }

    public void appendAsync(String message) {
        ThreadUtils.invokeLater(() -> this.doAppend(message));
    }

    public void appendAsync(String message, String sourceName) {
        ThreadUtils.invokeLater(() -> this.doAppend(message, sourceName));
    }

    public void registerOutputSource(OutputSource source) {
    }

    public void unregisterOutputSource(OutputSource source) {
    }
}

