﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/swf/SWF_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/swf/model/RecordMarkerFailedCause.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SWF
{
namespace Model
{

  /**
   * <p>Provides the details of the <code>RecordMarkerFailed</code>
   * event.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/swf-2012-01-25/RecordMarkerFailedEventAttributes">AWS
   * API Reference</a></p>
   */
  class RecordMarkerFailedEventAttributes
  {
  public:
    AWS_SWF_API RecordMarkerFailedEventAttributes() = default;
    AWS_SWF_API RecordMarkerFailedEventAttributes(Aws::Utils::Json::JsonView jsonValue);
    AWS_SWF_API RecordMarkerFailedEventAttributes& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SWF_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The marker's name.</p>
     */
    inline const Aws::String& GetMarkerName() const { return m_markerName; }
    inline bool MarkerNameHasBeenSet() const { return m_markerNameHasBeenSet; }
    template<typename MarkerNameT = Aws::String>
    void SetMarkerName(MarkerNameT&& value) { m_markerNameHasBeenSet = true; m_markerName = std::forward<MarkerNameT>(value); }
    template<typename MarkerNameT = Aws::String>
    RecordMarkerFailedEventAttributes& WithMarkerName(MarkerNameT&& value) { SetMarkerName(std::forward<MarkerNameT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The cause of the failure. This information is generated by the system and can
     * be useful for diagnostic purposes.</p>  <p>If <code>cause</code> is set to
     * <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
     * sufficient permissions. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using
     * IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer
     * Guide</i>.</p> 
     */
    inline RecordMarkerFailedCause GetCause() const { return m_cause; }
    inline bool CauseHasBeenSet() const { return m_causeHasBeenSet; }
    inline void SetCause(RecordMarkerFailedCause value) { m_causeHasBeenSet = true; m_cause = value; }
    inline RecordMarkerFailedEventAttributes& WithCause(RecordMarkerFailedCause value) { SetCause(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the
     * decision task that resulted in the <code>RecordMarkerFailed</code> decision for
     * this cancellation request. This information can be useful for diagnosing
     * problems by tracing back the chain of events leading up to this event.</p>
     */
    inline long long GetDecisionTaskCompletedEventId() const { return m_decisionTaskCompletedEventId; }
    inline bool DecisionTaskCompletedEventIdHasBeenSet() const { return m_decisionTaskCompletedEventIdHasBeenSet; }
    inline void SetDecisionTaskCompletedEventId(long long value) { m_decisionTaskCompletedEventIdHasBeenSet = true; m_decisionTaskCompletedEventId = value; }
    inline RecordMarkerFailedEventAttributes& WithDecisionTaskCompletedEventId(long long value) { SetDecisionTaskCompletedEventId(value); return *this;}
    ///@}
  private:

    Aws::String m_markerName;
    bool m_markerNameHasBeenSet = false;

    RecordMarkerFailedCause m_cause{RecordMarkerFailedCause::NOT_SET};
    bool m_causeHasBeenSet = false;

    long long m_decisionTaskCompletedEventId{0};
    bool m_decisionTaskCompletedEventIdHasBeenSet = false;
  };

} // namespace Model
} // namespace SWF
} // namespace Aws
