<!-- markdownlint-disable -->
<div align="center">

# Shuttle CLI

<p align=center>
  <a href="https://docs.shuttle.dev/">
    <img alt="docs" src="https://img.shields.io/badge/docs-reference-orange">
  </a>
  <a href="https://github.com/shuttle-hq/shuttle/search?l=rust">
    <img alt="language" src="https://img.shields.io/badge/language-Rust-orange.svg">
  </a>
  <a href="https://discord.gg/shuttle">
    <img alt="discord" src="https://img.shields.io/discord/803236282088161321?logo=discord"/>
  </a>
</p>
<!-- markdownlint-restore -->

This is the command line tool for deploying Rust apps on [Shuttle](https://www.shuttle.dev/), the Rust-native cloud deployment platform.

</div>

## Installation

For the full list of installation options, refer to the [Installation docs](https://docs.shuttle.dev/getting-started/installation).

Linux and macOS:

```sh
curl -sSfL https://www.shuttle.dev/install | bash
```

Windows (powershell):

```powershell
iwr https://www.shuttle.dev/install-win | iex
```

Build from source:

```bash
cargo install cargo-shuttle
```

## Documentation

Run `shuttle help` to see the basic usage.

Full list of commands and more documentation can be viewed on the [CLI docs](https://docs.shuttle.dev/guides/cli).

## Development

To contribute to `cargo-shuttle` or stay updated with our development, please [open an issue, discussion or PR on Github](https://github.com/shuttle-hq/shuttle) and [join our Discord](https://discord.gg/shuttle)! 🚀
