/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ProjectLocationSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public class CopyProjectOperation {
    private MultiStatus errorStatus;
    private Shell parentShell;
    private String[] modelProviderIds;

    protected static boolean validateCopy(Shell shell, IProject project, String newName, String[] modelProviderIds) {
        IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        factory.copy((IResource)project, (IPath)new Path(newName));
        return IDE.promptToConfirm(shell, IDEWorkbenchMessages.CopyProjectAction_confirm, NLS.bind((String)IDEWorkbenchMessages.CopyProjectAction_warning, (Object)project.getName()), factory.getDelta(), modelProviderIds, false);
    }

    public CopyProjectOperation(Shell shell) {
        this.parentShell = shell;
    }

    public void copyProject(IProject project) {
        this.errorStatus = null;
        ProjectLocationSelectionDialog dialog = new ProjectLocationSelectionDialog(this.parentShell, project);
        dialog.setTitle(IDEWorkbenchMessages.CopyProjectOperation_copyProject);
        if (dialog.open() != 0) {
            return;
        }
        Object[] destinationPaths = dialog.getResult();
        if (destinationPaths == null) {
            return;
        }
        String newName = (String)destinationPaths[0];
        URI newLocation = URIUtil.toURI((String)((String)destinationPaths[1]));
        boolean completed = this.performProjectCopy(project, newName, newLocation);
        if (!completed) {
            return;
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.parentShell, (String)IDEWorkbenchMessages.CopyProjectOperation_copyFailedTitle, null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }

    private boolean performProjectCopy(final IProject project, final String projectName, final URI newLocation) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                org.eclipse.ui.ide.undo.CopyProjectOperation op = new org.eclipse.ui.ide.undo.CopyProjectOperation(project, projectName, newLocation, IDEWorkbenchMessages.CopyProjectOperation_copyProject);
                op.setModelProviderIds(CopyProjectOperation.this.getModelProviderIds());
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter(CopyProjectOperation.this.parentShell));
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof CoreException) {
                        CopyProjectOperation.this.recordError((CoreException)e.getCause());
                    }
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.parentShell).run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            final String message = e.getTargetException().getMessage();
            this.parentShell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)CopyProjectOperation.this.parentShell, (String)IDEWorkbenchMessages.CopyProjectOperation_copyFailedTitle, (String)NLS.bind((String)IDEWorkbenchMessages.CopyProjectOperation_internalError, (Object)message));
                }
            });
            return false;
        }
        return true;
    }

    private void recordError(CoreException error) {
        if (this.errorStatus == null) {
            this.errorStatus = new MultiStatus("org.eclipse.ui", 4, IDEWorkbenchMessages.CopyProjectOperation_copyFailedMessage, (Throwable)error);
        }
        this.errorStatus.merge(error.getStatus());
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }
}

