/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.application;

import com.nvidia.viper.Viper;
import com.nvidia.viper.application.ApplicationActionBarAdvisor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.wizards.AbstractExtensionWizardRegistry;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    protected static final List<String> IMPORT_ALLOWED_WIZARDS = Collections.unmodifiableList(Arrays.asList(ApplicationWorkbenchWindowAdvisor.getAllowedImports()));

    private static String[] getAllowedImports() {
        if (Viper.isPgiProduct()) {
            return new String[]{"com.nvidia.viper.importpgprofwizard"};
        }
        if (System.getenv("EMBED_REBEL") != null) {
            return new String[]{"com.nvidia.viper.importnvprofwizard", "com.nvidia.viper.importcsvwizard", "com.nvidia.viper.rebelreportwizard"};
        }
        return new String[]{"com.nvidia.viper.importnvprofwizard", "com.nvidia.viper.importcsvwizard"};
    }

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    private void hideQuickAccess() {
        UIJob job = new UIJob("hide quick access"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window instanceof WorkbenchWindow) {
                    MTrimBar topTrim = ((WorkbenchWindow)window).getTopTrim();
                    for (MTrimElement element : topTrim.getChildren()) {
                        if (!"SearchField".equals(element.getElementId())) continue;
                        ((Control)element.getWidget()).dispose();
                        break;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void preWindowOpen() {
        this.hideQuickAccess();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(new Point(1200, 800));
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(false);
        configurer.setShowProgressIndicator(false);
    }

    public void postWindowOpen() {
        AbstractExtensionWizardRegistry wizardRegistry = (AbstractExtensionWizardRegistry)WorkbenchPlugin.getDefault().getImportWizardRegistry();
        IWizardCategory[] categories = WorkbenchPlugin.getDefault().getImportWizardRegistry().getRootCategory().getCategories();
        IWizardDescriptor[] iWizardDescriptorArray = this.getAllWizards(categories);
        int n = iWizardDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardDescriptor wizard = iWizardDescriptorArray[n2];
            WorkbenchWizardElement wizardElement = (WorkbenchWizardElement)wizard;
            if (!this.allowedWizard(wizardElement.getId())) {
                wizardRegistry.removeExtension(wizardElement.getConfigurationElement().getDeclaringExtension(), new Object[]{wizardElement});
            }
            ++n2;
        }
    }

    public void openIntro() {
        if ("win32".equals(Platform.getOS()) && !Viper.isPgiProduct()) {
            super.openIntro();
        } else {
            IIntroPart introPart;
            IIntroManager introManager = PlatformUI.getWorkbench().getIntroManager();
            if (introManager != null && (introPart = introManager.getIntro()) != null) {
                introManager.closeIntro(introPart);
            }
        }
    }

    private IWizardDescriptor[] getAllWizards(IWizardCategory[] categories) {
        ArrayList<IWizardDescriptor> results = new ArrayList<IWizardDescriptor>();
        IWizardCategory[] iWizardCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardCategory wizardCategory = iWizardCategoryArray[n2];
            results.addAll(Arrays.asList(wizardCategory.getWizards()));
            results.addAll(Arrays.asList(this.getAllWizards(wizardCategory.getCategories())));
            ++n2;
        }
        return results.toArray(new IWizardDescriptor[0]);
    }

    protected boolean allowedWizard(String wizardId) {
        return IMPORT_ALLOWED_WIZARDS.contains(wizardId);
    }
}

