/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.util;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public final class ColumnsDragSupport
implements MouseListener,
MouseMoveListener,
MouseTrackListener {
    private static final int HANDLE_THRESHOLD = 2;
    private final AtomicReference<State> currentState = new AtomicReference<State>(State.none);
    private int draggedColumnIndex = -1;
    private int draggedColumnWidth;
    private final Tree tree;

    public ColumnsDragSupport(Tree tree) {
        this.tree = tree;
        tree.addMouseListener((MouseListener)this);
        tree.addMouseMoveListener((MouseMoveListener)this);
        tree.addMouseTrackListener((MouseTrackListener)this);
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 27) {
                    ColumnsDragSupport.this.cancelDrag();
                }
            }
        });
    }

    protected void cancelDrag() {
        if (this.stopDrag()) {
            this.setColumnsWidth(this.draggedColumnWidth);
        }
    }

    private boolean stopDrag() {
        if (this.currentState.compareAndSet(State.dragging, State.hovering)) {
            this.hideCursor();
            return true;
        }
        return false;
    }

    private int getColumnToDrag(int x) {
        TreeColumn[] columns = this.tree.getColumns();
        int marginX = 0;
        int i = 0;
        while (i < columns.length) {
            TreeColumn treeColumn = columns[i];
            if (x >= (marginX += treeColumn.getWidth()) - 2 && x <= marginX + 2 && treeColumn.getResizable()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void hideCursor() {
        if (this.currentState.compareAndSet(State.hovering, State.none)) {
            this.tree.setCursor(null);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.draggedColumnIndex = this.getColumnToDrag(e.x);
        if (this.draggedColumnIndex >= 0 && this.currentState.compareAndSet(State.hovering, State.dragging)) {
            this.draggedColumnWidth = this.tree.getColumn(this.draggedColumnIndex).getWidth();
        }
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        this.hideCursor();
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseMove(MouseEvent e) {
        if (this.currentState.get() == State.dragging) {
            int columnX = 0;
            int i = 0;
            while (i < this.draggedColumnIndex) {
                columnX += this.tree.getColumn(i).getWidth();
                ++i;
            }
            int newWidth = e.x - columnX;
            if (newWidth < 0) {
                newWidth = 0;
            }
            this.setColumnsWidth(newWidth);
        } else {
            int hovered = this.getColumnToDrag(e.x);
            if (hovered >= 0) {
                this.showCursor();
            } else {
                this.hideCursor();
            }
        }
    }

    public void mouseUp(MouseEvent e) {
        this.stopDrag();
    }

    private void setColumnsWidth(int newWidth) {
        TreeColumn column = this.tree.getColumn(this.draggedColumnIndex);
        column.setWidth(newWidth);
    }

    private void showCursor() {
        if (this.currentState.compareAndSet(State.none, State.hovering)) {
            this.tree.setCursor(this.tree.getDisplay().getSystemCursor(9));
        }
    }

    private static enum State {
        dragging,
        hovering,
        none;

    }
}

