/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFFilterException;
import org.apache.fop.util.FlateEncodeOutputStream;

public class FlateFilter
extends PDFFilter {
    public static final int PREDICTION_NONE = 1;
    public static final int PREDICTION_TIFF2 = 2;
    public static final int PREDICTION_PNG_NONE = 10;
    public static final int PREDICTION_PNG_SUB = 11;
    public static final int PREDICTION_PNG_UP = 12;
    public static final int PREDICTION_PNG_AVG = 13;
    public static final int PREDICTION_PNG_PAETH = 14;
    public static final int PREDICTION_PNG_OPT = 15;
    private int predictor = 1;
    private int colors;
    private int bitsPerComponent;
    private int columns;

    public String getName() {
        return "/FlateDecode";
    }

    public String getDecodeParms() {
        if (this.predictor > 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("<< /Predictor ");
            sb.append(this.predictor);
            if (this.colors > 0) {
                sb.append(" /Colors " + this.colors);
            }
            if (this.bitsPerComponent > 0) {
                sb.append(" /BitsPerComponent " + this.bitsPerComponent);
            }
            if (this.columns > 0) {
                sb.append(" /Columns " + this.columns);
            }
            sb.append(" >> ");
            return sb.toString();
        }
        return null;
    }

    public void setPredictor(int predictor) throws PDFFilterException {
        this.predictor = predictor;
    }

    public int getPredictor() {
        return this.predictor;
    }

    public void setColors(int colors) throws PDFFilterException {
        if (this.predictor == 1) {
            throw new PDFFilterException("Prediction must not be PREDICTION_NONE in order to set Colors");
        }
        this.colors = colors;
    }

    public int getColors() {
        return this.colors;
    }

    public void setBitsPerComponent(int bits) throws PDFFilterException {
        if (this.predictor == 1) {
            throw new PDFFilterException("Prediction must not be PREDICTION_NONE in order to set bitsPerComponent");
        }
        this.bitsPerComponent = bits;
    }

    public int getBitsPerComponent() {
        return this.bitsPerComponent;
    }

    public void setColumns(int columns) throws PDFFilterException {
        if (this.predictor == 1) {
            throw new PDFFilterException("Prediction must not be PREDICTION_NONE in order to set Columns");
        }
        this.columns = columns;
    }

    public int getColumns() {
        return this.columns;
    }

    public OutputStream applyFilter(OutputStream out) throws IOException {
        return new FlateEncodeOutputStream(out);
    }
}

