/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.core.runtime.CoreException;

public class CPPQualifierType
implements IQualifierType,
ITypeContainer,
ISerializableType {
    private final boolean isConst;
    private final boolean isVolatile;
    private IType type;

    public CPPQualifierType(IType type, boolean isConst, boolean isVolatile) {
        this.isConst = isConst;
        this.isVolatile = isVolatile;
        this.setType(type);
    }

    @Override
    public boolean isSameType(IType o) {
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (!(o instanceof IQualifierType)) {
            return false;
        }
        IQualifierType pt = (IQualifierType)o;
        if (this.isConst() == pt.isConst() && this.isVolatile() == pt.isVolatile() && this.type != null) {
            return this.type.isSameType(pt.getType());
        }
        return false;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public IType getType() {
        return this.type;
    }

    @Override
    public void setType(IType t) {
        assert (t != null);
        this.type = t;
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        short firstBytes = 4;
        if (this.isConst()) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        if (this.isVolatile()) {
            firstBytes = (short)(firstBytes | 0x40);
        }
        buffer.putShort(firstBytes);
        buffer.marshalType(this.getType());
    }

    public static IType unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IType nested = buffer.unmarshalType();
        return new CPPQualifierType(nested, (firstBytes & 0x20) != 0, (firstBytes & 0x40) != 0);
    }
}

