/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.commenthandler;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.ASTCommenter;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.CommentHandler;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommenter;

public class ASTCommenterVisitor
extends ASTVisitor {
    protected CommentHandler commentHandler;
    protected NodeCommentMap commentMap;
    private NodeCommenter nodeCommenter;
    private IASTDeclaration lastDecl;

    public ASTCommenterVisitor(CommentHandler commentHandler, NodeCommentMap commentMap) {
        this.shouldVisitBaseSpecifiers = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitDeclarators = true;
        this.shouldVisitDeclSpecifiers = true;
        this.shouldVisitExpressions = true;
        this.shouldVisitInitializers = true;
        this.shouldVisitNames = true;
        this.shouldVisitNamespaces = true;
        this.shouldVisitParameterDeclarations = true;
        this.shouldVisitStatements = true;
        this.shouldVisitTemplateParameters = true;
        this.shouldVisitTypeIds = true;
        this.shouldVisitTranslationUnit = true;
        this.commentHandler = commentHandler;
        this.commentMap = commentMap;
        this.init();
    }

    private void init() {
        this.nodeCommenter = new NodeCommenter(this, this.commentHandler, this.commentMap);
    }

    @Override
    public int visit(IASTName name) {
        return this.nodeCommenter.appendComments((ASTNode)((Object)name));
    }

    @Override
    public int visit(IASTDeclSpecifier declSpec) {
        return this.nodeCommenter.appendComments((ASTNode)((Object)declSpec));
    }

    @Override
    public int visit(IASTExpression expression) {
        return this.nodeCommenter.appendComments((ASTNode)((Object)expression));
    }

    @Override
    public int visit(IASTStatement statement) {
        return this.nodeCommenter.appendComments((ASTNode)((Object)statement));
    }

    @Override
    public int visit(IASTTypeId typeId) {
        return this.nodeCommenter.appendComments((ASTNode)((Object)typeId));
    }

    @Override
    public int visit(IASTDeclaration declaration) {
        if (ASTCommenter.isInWorkspace(declaration)) {
            return this.nodeCommenter.appendComments((ASTNode)((Object)declaration));
        }
        return 1;
    }

    @Override
    public int visit(IASTDeclarator declarator) {
        return this.nodeCommenter.appendComments((ASTNode)((Object)declarator));
    }

    @Override
    public int visit(IASTInitializer initializer) {
        return this.nodeCommenter.appendComments((ASTNode)((Object)initializer));
    }

    @Override
    public int visit(IASTParameterDeclaration parameterDeclaration) {
        return this.nodeCommenter.appendComments((ASTNode)((Object)parameterDeclaration));
    }

    @Override
    public int visit(ICPPASTNamespaceDefinition namespace) {
        return this.nodeCommenter.appendComments((ASTNode)((Object)namespace));
    }

    @Override
    public int visit(ICPPASTTemplateParameter parameter) {
        return this.nodeCommenter.appendComments((ASTNode)((Object)parameter));
    }

    @Override
    public int leave(IASTTranslationUnit tu) {
        this.nodeCommenter.appendComments((ASTNode)((Object)tu));
        if (this.lastDecl != null) {
            this.nodeCommenter.appendRemainingComments(this.lastDecl);
        }
        return 3;
    }

    @Override
    public int leave(IASTName name) {
        this.nodeCommenter.appendComments((ASTNode)((Object)name));
        return 3;
    }

    @Override
    public int leave(IASTDeclaration declaration) {
        this.lastDecl = declaration;
        this.nodeCommenter.appendComments((ASTNode)((Object)declaration));
        return 3;
    }

    @Override
    public int leave(ICPPASTNamespaceDefinition namespaceDefinition) {
        return this.nodeCommenter.appendFreestandingComments((ASTNode)((Object)namespaceDefinition));
    }

    @Override
    public int leave(IASTInitializer initializer) {
        this.nodeCommenter.appendComments((ASTNode)((Object)initializer));
        return 3;
    }

    @Override
    public int leave(IASTParameterDeclaration parameterDeclaration) {
        this.nodeCommenter.appendComments((ASTNode)((Object)parameterDeclaration));
        return 3;
    }

    @Override
    public int leave(IASTDeclarator declarator) {
        this.nodeCommenter.appendComments((ASTNode)((Object)declarator));
        return 3;
    }

    @Override
    public int leave(IASTDeclSpecifier declSpec) {
        if (declSpec instanceof CPPASTCompositeTypeSpecifier) {
            return this.nodeCommenter.appendFreestandingComments((ASTNode)((Object)declSpec));
        }
        this.nodeCommenter.appendComments((ASTNode)((Object)declSpec));
        return 3;
    }

    @Override
    public int leave(IASTExpression expression) {
        this.nodeCommenter.appendComments((ASTNode)((Object)expression));
        return 3;
    }

    @Override
    public int leave(IASTStatement statement) {
        if (statement instanceof IASTCompoundStatement) {
            return this.nodeCommenter.appendFreestandingComments((ASTNode)((Object)statement));
        }
        this.nodeCommenter.appendComments((ASTNode)((Object)statement));
        return 3;
    }

    @Override
    public int leave(IASTTypeId typeId) {
        this.nodeCommenter.appendComments((ASTNode)((Object)typeId));
        return 3;
    }

    @Override
    public int leave(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        this.nodeCommenter.appendComments((ASTNode)((Object)enumerator));
        return 3;
    }

    @Override
    public int leave(IASTProblem problem) {
        this.nodeCommenter.appendComments((ASTNode)((Object)problem));
        return 3;
    }

    @Override
    public int leave(IASTComment comment) {
        this.nodeCommenter.appendComments((ASTNode)((Object)comment));
        return 3;
    }
}

