/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CreateElementInTUOperation;
import org.eclipse.cdt.internal.core.model.Util;

public class CreateNamespaceOperation
extends CreateElementInTUOperation {
    protected String fNamespace;

    public CreateNamespaceOperation(String namespace, ITranslationUnit parentElement) {
        super(parentElement);
        this.fNamespace = namespace;
    }

    @Override
    protected ICElement generateResultHandle() {
        return this.getTranslationUnit().getNamespace(this.fNamespace);
    }

    @Override
    public String getMainTaskName() {
        return "operation.createNamespaceProgress";
    }

    @Override
    protected void initializeDefaultPosition() {
        try {
            ITranslationUnit cu = this.getTranslationUnit();
            IInclude[] includes = cu.getIncludes();
            if (includes.length > 0) {
                this.createAfter(includes[includes.length - 1]);
                return;
            }
        }
        catch (CModelException cModelException) {}
    }

    @Override
    protected String generateElement(ITranslationUnit unit) throws CModelException {
        StringBuffer sb = new StringBuffer();
        sb.append("namespace ");
        sb.append(this.fNamespace).append(' ').append('{');
        sb.append(Util.LINE_SEPARATOR);
        sb.append('}');
        sb.append(Util.LINE_SEPARATOR);
        return sb.toString();
    }
}

