/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.view;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.files.ui.resources.SystemUniversalTempFileListener;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.files.ui.actions.SystemRemoteFileLineOpenWithMenu;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.swt.widgets.Display;

public class DownloadAndOpenJob
extends Job {
    private ISystemEditableRemoteObject _editable;
    private boolean _systemEditor;
    private int _line;
    private int _charStart;
    private int _charEnd;

    public DownloadAndOpenJob(ISystemEditableRemoteObject editable, boolean systemEditor) {
        super(FileResources.RESID_FILES_DOWNLOAD);
        this._editable = editable;
        this._systemEditor = systemEditor;
        this._line = -1;
        this._charStart = -1;
        this._charEnd = -1;
    }

    public DownloadAndOpenJob(ISystemEditableRemoteObject editable, boolean systemEditor, int line, int charStart, int charEnd) {
        super(FileResources.RESID_FILES_DOWNLOAD);
        this._editable = editable;
        this._systemEditor = systemEditor;
        this._line = line;
        this._charStart = charStart;
        this._charEnd = charEnd;
    }

    public IStatus run(IProgressMonitor monitor) {
        boolean downloadSuccessful = false;
        try {
            IFile localFile = this._editable.getLocalResource();
            ISubSystem ss = this._editable.getSubSystem();
            if (!ss.isConnected()) {
                ss.connect(monitor, false);
            }
            if (!ss.isConnected()) {
                return Status.CANCEL_STATUS;
            }
            SystemUniversalTempFileListener listener = SystemUniversalTempFileListener.getListener();
            listener.addIgnoreFile(localFile);
            downloadSuccessful = this._editable.download(monitor);
            listener.removeIgnoreFile(localFile);
        }
        catch (Exception exception) {}
        if (downloadSuccessful) {
            OpenEditorRunnable oe = null;
            oe = this._line > -1 || this._charStart > -1 && this._charEnd > -1 ? new OpenEditorRunnable(this._editable, this._systemEditor, this._line, this._charStart, this._charEnd) : new OpenEditorRunnable(this._editable, this._systemEditor);
            Display.getDefault().asyncExec((Runnable)oe);
        }
        return Status.OK_STATUS;
    }

    private static class OpenEditorRunnable
    implements Runnable {
        private ISystemEditableRemoteObject _editable;
        private boolean _systemEditor;
        private int _line;
        private int _charStart;
        private int _charEnd;

        public OpenEditorRunnable(ISystemEditableRemoteObject editable, boolean systemEditor) {
            this._editable = editable;
            this._systemEditor = systemEditor;
            this._line = -1;
            this._charStart = -1;
            this._charEnd = -1;
        }

        public OpenEditorRunnable(ISystemEditableRemoteObject editable, boolean systemEditor, int line, int charStart, int charEnd) {
            this._editable = editable;
            this._systemEditor = systemEditor;
            this._line = line;
            this._charStart = charStart;
            this._charEnd = charEnd;
        }

        public void run() {
            try {
                this._editable.addAsListener();
                this._editable.setLocalResourceProperties();
                if (this._systemEditor) {
                    ((SystemEditableRemoteFile)this._editable).openSystemEditor();
                } else {
                    this._editable.openEditor();
                }
                if (this._line > -1 || this._charStart > -1 && this._charEnd > -1) {
                    SystemRemoteFileLineOpenWithMenu.handleGotoLine((IRemoteFile)this._editable.getRemoteObject(), this._line, this._charStart, this._charEnd);
                }
            }
            catch (Exception exception) {}
        }
    }
}

