/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ToolFactory;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterUtil {
    public static String createIndentString(int indentationUnits, ICProject project) {
        HashMap options = project != null ? project.getOptions(true) : CCorePlugin.getOptions();
        return ToolFactory.createDefaultCodeFormatter((Map)options).createIndentationString(indentationUnits);
    }

    public static int getTabWidth(ICProject project) {
        String key = "space".equals(CodeFormatterUtil.getCoreOption(project, "org.eclipse.cdt.core.formatter.tabulation.char")) ? "org.eclipse.cdt.core.formatter.indentation.size" : "org.eclipse.cdt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(project, key, 4);
    }

    public static int getIndentWidth(ICProject project) {
        String key = "mixed".equals(CodeFormatterUtil.getCoreOption(project, "org.eclipse.cdt.core.formatter.tabulation.char")) ? "org.eclipse.cdt.core.formatter.indentation.size" : "org.eclipse.cdt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(project, key, 4);
    }

    private static String getCoreOption(ICProject project, String key) {
        if (project == null) {
            return CCorePlugin.getOption((String)key);
        }
        return project.getOption(key, true);
    }

    private static int getCoreOption(ICProject project, String key, int def) {
        try {
            return Integer.parseInt(CodeFormatterUtil.getCoreOption(project, key));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator, Map<String, ?> options) {
        if (offset < 0 || length < 0 || offset + length > source.length()) {
            throw new IllegalArgumentException("offset or length outside of string. offset: " + offset + ", length: " + length + ", string size: " + source.length());
        }
        CodeFormatter formatter = ToolFactory.createCodeFormatter(options);
        if (formatter != null) {
            return formatter.format(kind, source, offset, length, indentationLevel, lineSeparator);
        }
        return null;
    }

    public static TextEdit format(int kind, String source, int indentationLevel, String lineSeparator, Map<String, ?> options) {
        String prefix = "";
        String suffix = "";
        switch (kind) {
            case 1: {
                prefix = "int __dummy__=";
                suffix = ";";
                break;
            }
            case 2: {
                prefix = "void __dummy__() {";
                suffix = "}";
                --indentationLevel;
            }
        }
        String tuSource = String.valueOf(prefix) + source + suffix;
        return CodeFormatterUtil.format(tuSource, prefix.length(), source.length(), indentationLevel, lineSeparator, options);
    }

    private static TextEdit format(String source, int offset, int length, int indentationLevel, String lineSeparator, Map<String, ?> options) {
        TextEdit edit = CodeFormatterUtil.format(8, source, offset, length, indentationLevel, lineSeparator, options);
        if (edit != null && offset > 0) {
            edit.moveTree(-offset);
        }
        return edit;
    }

    public static int getTabWidth() {
        return CodeFormatterUtil.getTabWidth(null);
    }
}

