/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiOpenMPEventKind;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;

public class CuptiActivityOpenMP
extends CuptiActivityBase
implements ICuptiActivity {
    public int eventKind;
    public int version;
    public int threadId;
    public int cuProcessId;
    public int cuThreadId;
    public long start;
    public long end;

    public CuptiActivityOpenMP() {
        this.kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_INVALID.getCode();
        this.start = 0L;
        this.end = 0L;
    }

    public CuptiActivityOpenMP(int eventKind, int version, int threadId, int cuProcessId, int cuThreadId, long start, long end) {
        this.eventKind = eventKind;
        this.version = version;
        this.threadId = threadId;
        this.cuProcessId = cuProcessId;
        this.cuThreadId = cuThreadId;
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.start > 0L && this.end > 0L && this.start < this.end;
    }

    @Override
    public void appendToPDM(long hPdm) throws CuptiException {
        NativeCupti.cuptiPDMAppendActivity(hPdm, this);
    }

    public static String getCuptiEventName(CuptiOpenMPEventKind event) {
        if (event == null) {
            return "<unknown>";
        }
        switch (event) {
            case CUPTI_OPENMP_EVENT_KIND_IDLE: {
                return "OMP_Idle";
            }
            case CUPTI_OPENMP_EVENT_KIND_PARALLEL: {
                return "OMP_Parallel";
            }
            case CUPTI_OPENMP_EVENT_KIND_TASK: {
                return "OMP_Task";
            }
            case CUPTI_OPENMP_EVENT_KIND_THREAD: {
                return "OMP_Thread";
            }
            case CUPTI_OPENMP_EVENT_KIND_WAIT_BARRIER: {
                return "OMP_Wait_barrier";
            }
            case CUPTI_OPENMP_EVENT_KIND_WAIT_TASKWAIT: {
                return "OMP_Wait_taskwait";
            }
        }
        return "<unknown>";
    }

    public String getName() {
        String name = CuptiActivityOpenMP.getCuptiEventName(CuptiOpenMPEventKind.valueOf(this.eventKind));
        return name;
    }

    public CuptiOpenMPEventKind getOpenMPKind() {
        return CuptiOpenMPEventKind.valueOf(this.eventKind);
    }
}

