/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.ResultOutput;
import java.util.EnumMap;

public enum AnalysisDescriptor {
    ANALYSIS_OK(ViperMessages.Analysis_OK_Label, ViperMessages.Analysis_OK_Desc, AnalysisStage.NONE, Severity.OK),
    GPU_UTILIZATION_NO_TIMELINE(ViperMessages.Analysis_NoTimeline_Label, ViperMessages.Analysis_NoTimeline_Desc, AnalysisStage.TIMELINE, Severity.NODATA),
    GPU_UTILIZATION_NO_DEVICE(ViperMessages.GpuUtilization_NoDevice_Label, ViperMessages.GpuUtilization_NoDevice_Desc, AnalysisStage.TIMELINE, Severity.NODATA),
    GPU_COMPUTE_MEMCPY_EFFICIENCY_BAD(ViperMessages.GpuComputeMemcpyEfficiency_Label, ViperMessages.GpuComputeMemcpyEfficiency_Desc, AnalysisStage.TIMELINE, Severity.EFFICIENCY),
    GPU_COMPUTE_MEMCPY_OVERLAP_BAD(ViperMessages.GpuComputeMemcpyOverlap_Label, ViperMessages.GpuComputeMemcpyOverlap_Desc, AnalysisStage.TIMELINE, Severity.OVERLAP),
    GPU_COMPUTE_OVERLAP_BAD(ViperMessages.GpuComputeOverlap_Label, ViperMessages.GpuComputeOverlap_Desc, AnalysisStage.TIMELINE, Severity.OVERLAP),
    MEMCPY_NO_TIMELINE(ViperMessages.Analysis_NoTimeline_Label, ViperMessages.Analysis_NoTimeline_Desc, AnalysisStage.TIMELINE, Severity.NODATA),
    MEMCPY_NO_DEVICE(ViperMessages.Memcpy_NoDevice_Label, ViperMessages.Memcpy_NoDevice_Desc, AnalysisStage.TIMELINE, Severity.NODATA),
    MEMCPY_SIZE_BAD(ViperMessages.MemcpySize_Label, ViperMessages.MemcpySize_Desc, AnalysisStage.TIMELINE, Severity.EFFICIENCY),
    MEMCPY_THROUGHPUT_BAD(ViperMessages.MemcpyThroughput_Label, ViperMessages.MemcpyThroughput_Desc, AnalysisStage.TIMELINE, Severity.EFFICIENCY),
    MEMCPY_OVERLAP_BAD(ViperMessages.MemcpyOverlap_Label, ViperMessages.MemcpyOverlap_Desc, AnalysisStage.TIMELINE, Severity.OVERLAP),
    KERNELS_NO_TIMELINE(ViperMessages.Analysis_NoTimeline_Label, ViperMessages.Analysis_NoTimeline_Desc, AnalysisStage.KERNELS, Severity.NODATA),
    KERNELS_NO_DEVICE(ViperMessages.Kernels_NoDevice_Label, ViperMessages.Kernels_NoDevice_Desc, AnalysisStage.KERNELS, Severity.NODATA),
    KERNELS_OCCUPANCY_BAD(ViperMessages.Occupancy_Bad_Label, ViperMessages.Occupancy_Bad_Desc, AnalysisStage.KERNELS, Severity.UTILIZATION),
    KERNELS_OCCUPANCY_GOOD(ViperMessages.Analysis_OK_Label, ViperMessages.Analysis_OK_Desc, AnalysisStage.KERNELS, Severity.OK),
    KERNELS_OCCUPANCY_NO_DATA(ViperMessages.Occupancy_NoData_Label, ViperMessages.Occupancy_NoData_Desc, AnalysisStage.KERNELS, Severity.NODATA),
    KERNELS_PRIORITY(ViperMessages.KernelsPriority_Label, ViperMessages.KernelsPriority_Desc, AnalysisStage.KERNELS, Severity.INFO),
    KERNELS_UTILIZATION_BAD(ViperMessages.KernelsUtilization_Bad_Label, ViperMessages.KernelsUtilization_Bad_Desc, AnalysisStage.KERNELS, Severity.UTILIZATION),
    KERNELS_UTILIZATION(ViperMessages.KernelsUtilization_Label, ViperMessages.KernelsUtilization_Desc, AnalysisStage.KERNELS, Severity.INFO),
    KERNELMEMORY_NO_TIMELINE(ViperMessages.Analysis_NoTimeline_Label, ViperMessages.Analysis_NoTimeline_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.NODATA),
    KERNELMEMORY_NO_DEVICE(ViperMessages.KernelMemory_NoDevice_Label, ViperMessages.KernelMemory_NoDevice_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.NODATA),
    KERNELMEMORY_GLD_EFFICIENCY_BAD(ViperMessages.GldEfficiency_Bad_Label, ViperMessages.GldEfficiency_Bad_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.EFFICIENCY),
    KERNELMEMORY_GLD_EFFICIENCY_GOOD(ViperMessages.Analysis_OK_Label, ViperMessages.Analysis_OK_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.OK),
    KERNELMEMORY_GLD_EFFICIENCY_NO_DATA(ViperMessages.GldEfficiency_NoData_Label, ViperMessages.GldEfficiency_NoData_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.NODATA),
    KERNELMEMORY_GLD_EFFICIENCY_NOT_AVAILABLE(ViperMessages.GldEfficiency_NotAvail_Label, ViperMessages.GldEfficiency_NotAvail_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.NODATA),
    KERNELMEMORY_GST_EFFICIENCY_BAD(ViperMessages.GstEfficiency_Bad_Label, ViperMessages.GstEfficiency_Bad_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.EFFICIENCY),
    KERNELMEMORY_GST_EFFICIENCY_GOOD(ViperMessages.Analysis_OK_Label, ViperMessages.Analysis_OK_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.OK),
    KERNELMEMORY_GST_EFFICIENCY_NO_DATA(ViperMessages.GstEfficiency_NoData_Label, ViperMessages.GstEfficiency_NoData_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.NODATA),
    KERNELMEMORY_GST_EFFICIENCY_NOT_AVAILABLE(ViperMessages.GstEfficiency_NotAvail_Label, ViperMessages.GstEfficiency_NotAvail_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.NODATA),
    KERNELMEMORY_SHARED_EFFICIENCY_BAD(ViperMessages.SharedEfficiency_Bad_Label, ViperMessages.SharedEfficiency_Bad_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.EFFICIENCY),
    KERNELMEMORY_SHARED_EFFICIENCY_GOOD(ViperMessages.Analysis_OK_Label, ViperMessages.Analysis_OK_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.OK),
    KERNELMEMORY_SHARED_EFFICIENCY_NO_DATA(ViperMessages.SharedEfficiency_NoData_Label, ViperMessages.SharedEfficiency_NoData_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.NODATA),
    KERNELINST_NO_TIMELINE(ViperMessages.Analysis_NoTimeline_Label, ViperMessages.Analysis_NoTimeline_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.NODATA),
    KERNELINST_NO_DEVICE(ViperMessages.KernelInst_NoDevice_Label, ViperMessages.KernelInst_NoDevice_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.NODATA),
    KERNELINST_WARP_EXECUTION_EFFICIENCY_BAD(ViperMessages.WarpExecEfficiency_Bad_Label, ViperMessages.WarpExecEfficiency_Bad_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.EFFICIENCY),
    KERNELINST_WARP_EXECUTION_EFFICIENCY_GOOD(ViperMessages.Analysis_OK_Label, ViperMessages.Analysis_OK_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.OK),
    KERNELINST_WARP_EXECUTION_EFFICIENCY_NO_DATA(ViperMessages.WarpExecEfficiency_NoData_Label, ViperMessages.WarpExecEfficiency_NoData_Desc, AnalysisStage.KERNELS_PERFORMANCE, Severity.NODATA),
    KERNEL_BOUNDS_NO_KERNEL(ViperMessages.Analysis_NoKernel_Label, ViperMessages.Analysis_NoKernel_Desc, AnalysisStage.KERNEL_INSTANCE_BOUNDS, Severity.NODATA),
    KERNEL_BOUNDS_NO_DATA(ViperMessages.KernelBounds_NoData_Label, ViperMessages.KernelBounds_NoData_Desc, AnalysisStage.KERNEL_INSTANCE_BOUNDS, Severity.NODATA),
    KERNEL_BOUNDS(ViperMessages.KernelBounds_Label, ViperMessages.KernelBounds_None_Desc, AnalysisStage.KERNEL_INSTANCE_BOUNDS, Severity.INFO),
    KERNEL_MEMORY_NO_KERNEL(ViperMessages.Analysis_NoKernel_Label, ViperMessages.Analysis_NoKernel_Desc, AnalysisStage.KERNEL_INSTANCE_MEMORY, Severity.NODATA),
    KERNEL_MEMORY_NO_DATA(ViperMessages.KernelMemory_NoData_Label, ViperMessages.KernelMemory_NoData_Desc, AnalysisStage.KERNEL_INSTANCE_MEMORY, Severity.NODATA),
    KERNEL_MEMORY(ViperMessages.KernelMemory_Label, ViperMessages.KernelMemory_Desc, AnalysisStage.KERNEL_INSTANCE_MEMORY, Severity.INFO),
    KERNEL_MEMORY_BANDWIDTH_LIMITER(ViperMessages.KernelMemory_BandwidthLimiter_Label, ViperMessages.KernelMemory_BandwidthLimiter_Desc, ViperMessages.KernelMemory_BandwidthLimiter_ActionDesc, AnalysisStage.KERNEL_INSTANCE_MEMORY, Severity.UTILIZATION),
    KERNEL_MEMORY_FU_LIMITER(ViperMessages.KernelMemory_FuLimiter_Label, ViperMessages.KernelMemory_FuLimiter_Desc, ViperMessages.KernelMemory_FuLimiter_ActionDesc, AnalysisStage.KERNEL_INSTANCE_MEMORY, Severity.UTILIZATION),
    KERNEL_MEMORY_LMEM_OVERHEAD(ViperMessages.KernelMemory_LmemOverhead_Label, ViperMessages.KernelMemory_LmemOverhead_Desc, ViperMessages.KernelMemory_LmemOverhead_ActionDesc, AnalysisStage.KERNEL_INSTANCE_MEMORY, Severity.EFFICIENCY),
    KERNEL_COMPUTE_NO_KERNEL(ViperMessages.Analysis_NoKernel_Label, ViperMessages.Analysis_NoKernel_Desc, AnalysisStage.KERNEL_INSTANCE_SM, Severity.NODATA),
    KERNEL_COMPUTE_NO_DATA(ViperMessages.KernelSM_NoData_Label, ViperMessages.KernelSM_NoData_Desc, AnalysisStage.KERNEL_INSTANCE_SM, Severity.NODATA),
    KERNEL_COMPUTE_EXEC_EFFICIENCY(ViperMessages.KernelSM_ExecEfficiency_Label, ViperMessages.KernelSM_ExecEfficiency_Desc, ViperMessages.KernelSM_ExecEfficiency_ActionDesc, AnalysisStage.KERNEL_INSTANCE_SM, Severity.EFFICIENCY),
    KERNEL_COMPUTE_PIPE_BUSY(ViperMessages.KernelSM_PipeBusy_Label, ViperMessages.KernelSM_PipeBusy_NoLimiter_Desc, AnalysisStage.KERNEL_INSTANCE_SM, Severity.INFO),
    KERNEL_COMPUTE_PIPE_BUSY_LIMITER(ViperMessages.KernelSM_PipeBusy_Limiter_Label, ViperMessages.KernelSM_PipeBusy_Limiter_Desc, AnalysisStage.KERNEL_INSTANCE_SM, Severity.UTILIZATION),
    KERNEL_COMPUTE_INSTRUCTION_CLASS(ViperMessages.KernelSM_InstClass_Label, ViperMessages.KernelSM_InstClass_Desc, AnalysisStage.KERNEL_INSTANCE_SM, Severity.INFO),
    KERNEL_COMPUTE_FLOPS(ViperMessages.KernelSM_Flops_Label, ViperMessages.KernelSM_Flops_Desc, AnalysisStage.KERNEL_INSTANCE_SM, Severity.INFO),
    KERNEL_LATENCY_NO_KERNEL(ViperMessages.Analysis_NoKernel_Label, ViperMessages.Analysis_NoKernel_Desc, AnalysisStage.KERNEL_INSTANCE_LATENCY, Severity.NODATA),
    KERNEL_LATENCY_NO_DATA(ViperMessages.KernelLatency_NoData_Label, ViperMessages.KernelLatency_NoData_Desc, AnalysisStage.KERNEL_INSTANCE_LATENCY, Severity.NODATA),
    KERNEL_LATENCY_STALL(ViperMessages.KernelLatency_Stall_Label, ViperMessages.KernelLatency_Stall_Desc, ViperMessages.KernelLatency_Stall_ActionDesc, AnalysisStage.KERNEL_INSTANCE_LATENCY, Severity.EFFICIENCY),
    KERNEL_LATENCY_NOSTALL(ViperMessages.KernelLatency_NoStall_Label, ViperMessages.KernelLatency_NoStall_Desc, AnalysisStage.KERNEL_INSTANCE_LATENCY, Severity.INFO),
    KERNEL_LATENCY_GRID_SIZE(ViperMessages.KernelLatency_GridSize_Label, ViperMessages.KernelLatency_GridSize_Desc, ViperMessages.KernelLatency_GridSize_ActionDesc, AnalysisStage.KERNEL_INSTANCE_LATENCY, Severity.UTILIZATION),
    KERNEL_LATENCY_BAD_ACHIEVED(ViperMessages.KernelLatency_BadAchieved_Label, ViperMessages.KernelLatency_BadAchieved_Desc, ViperMessages.KernelLatency_BadAchieved_ActionDesc, AnalysisStage.KERNEL_INSTANCE_LATENCY, Severity.UTILIZATION),
    KERNEL_LATENCY_ACHIEVED_OCCUPANCY(ViperMessages.KernelLatency_SMUtilization_Label, ViperMessages.KernelLatency_SMUtilization_Desc, AnalysisStage.KERNEL_INSTANCE_LATENCY, Severity.INFO),
    KERNEL_OCCUPANCY_NO_DATA(ViperMessages.Occupancy_NoData_Label, ViperMessages.Occupancy_NoData_Desc, AnalysisStage.KERNEL_INSTANCE_LATENCY, Severity.NODATA),
    KERNEL_OCCUPANCY_GOOD(ViperMessages.KernelLatency_Occupancy_Good_Label, ViperMessages.KernelLatency_Occupancy_Good_Desc, AnalysisStage.KERNEL_INSTANCE_LATENCY, Severity.INFO, 78),
    KERNEL_OCCUPANCY_LIMIT_BLOCK(ViperMessages.KernelLatency_Occupancy_BlockLimit_Label, ViperMessages.KernelLatency_Occupancy_BlockLimit_Desc, ViperMessages.KernelLatency_Occupancy_BlockLimit_ActionDesc, AnalysisStage.KERNEL_INSTANCE_LATENCY, Severity.UTILIZATION, 78),
    KERNEL_OCCUPANCY_LIMIT_REGISTER(ViperMessages.KernelLatency_Occupancy_RegisterLimit_Label, ViperMessages.KernelLatency_Occupancy_RegisterLimit_Desc, ViperMessages.KernelLatency_Occupancy_RegisterLimit_ActionDesc, AnalysisStage.KERNEL_INSTANCE_LATENCY, Severity.UTILIZATION, 78),
    KERNEL_OCCUPANCY_LIMIT_SHARED_MEMORY(ViperMessages.KernelLatency_Occupancy_SharedMemoryLimit_Label, ViperMessages.KernelLatency_Occupancy_SharedMemoryLimit_Desc, ViperMessages.KernelLatency_Occupancy_SharedMemoryLimit_ActionDesc, AnalysisStage.KERNEL_INSTANCE_LATENCY, Severity.UTILIZATION, 78),
    KERNEL_OCCUPANCY_CHARTS(ViperMessages.Analysis_OK_Label, ViperMessages.Analysis_OK_Desc, AnalysisStage.KERNEL_INSTANCE_LATENCY, Severity.INFO, 79),
    SL_GLOBALMEMORYUNCOALESCED_NO_KERNEL(ViperMessages.Analysis_NoKernel_Label, ViperMessages.Analysis_NoKernel_Desc, AnalysisStage.KERNEL_INSTANCE_UNCOALESCED_GLOBAL, Severity.NODATA),
    SL_GLOBALMEMORYUNCOALESCED_NO_DATA(ViperMessages.GlobalMemory_Uncoalesced_NoData_Label, ViperMessages.GlobalMemory_Uncoalesced_NoData_Desc, AnalysisStage.KERNEL_INSTANCE_UNCOALESCED_GLOBAL, Severity.NODATA),
    SL_GLOBALMEMORY_UNCOALESCED(AnalysisDescriptor.enumMapInitializer(new Object[]{ResultOutput.UI, ViperMessages.GlobalMemory_Uncoalesced_Label, ResultOutput.REPORT, ViperMessages.GlobalMemory_Uncoalesced_Label}), AnalysisDescriptor.enumMapInitializer(new Object[]{ResultOutput.UI, ViperMessages.GlobalMemory_Uncoalesced_Desc, ResultOutput.REPORT, ViperMessages.GlobalMemory_Uncoalesced_Desc}), AnalysisDescriptor.enumMapInitializer(new Object[]{ResultOutput.UI, ViperMessages.GlobalMemory_Uncoalesced_ActionDesc, ResultOutput.REPORT, ViperMessages.GlobalMemory_Uncoalesced_ActionDesc_Report}), AnalysisStage.KERNEL_INSTANCE_UNCOALESCED_GLOBAL, Severity.EFFICIENCY),
    SL_GLOBALMEMORY_UNCOALESCED_FEW_SOURCE(ViperMessages.Analysis_FewSourceMapp_Label, ViperMessages.Analysis_FewSourceMapp_Desc, AnalysisStage.KERNEL_INSTANCE_UNCOALESCED_GLOBAL, Severity.NODATA),
    SL_GLOBALMEMORY_UNCOALESCED_NO_DISASM(ViperMessages.Analysis_NoNvdisasm_Label, ViperMessages.Analysis_NoNvdisasm_Desc, AnalysisStage.KERNEL_INSTANCE_UNCOALESCED_GLOBAL, Severity.NODATA),
    SL_GLOBALMEMORYUNCOALESCED_NO_SOURCE(ViperMessages.Analysis_NoSource_Label, ViperMessages.Analysis_NoSource_Desc, AnalysisStage.KERNEL_INSTANCE_UNCOALESCED_GLOBAL, Severity.NODATA, SL_GLOBALMEMORY_UNCOALESCED.getRank() - 1),
    SL_SHAREDACCESS_NO_KERNEL(ViperMessages.Analysis_NoKernel_Label, ViperMessages.Analysis_NoKernel_Desc, AnalysisStage.KERNEL_INSTANCE_SHARED_ACCESS, Severity.NODATA),
    SL_SHAREDACCESS_NO_DATA(ViperMessages.SharedAccess_NoData_Label, ViperMessages.SharedAccess_NoData_Desc, AnalysisStage.KERNEL_INSTANCE_SHARED_ACCESS, Severity.NODATA),
    SL_SHAREDACCESS_BAD(ViperMessages.SharedAccess_Bad_Label, ViperMessages.SharedAccess_Bad_Desc, ViperMessages.SharedAccess_Bad_ActionDesc, AnalysisStage.KERNEL_INSTANCE_SHARED_ACCESS, Severity.EFFICIENCY),
    SL_SHAREDACCESS_FEW_SOURCE(ViperMessages.Analysis_FewSourceMapp_Label, ViperMessages.Analysis_FewSourceMapp_Desc, AnalysisStage.KERNEL_INSTANCE_SHARED_ACCESS, Severity.NODATA),
    SL_SHAREDACCESS_NO_DISASM(ViperMessages.Analysis_NoNvdisasm_Label, ViperMessages.Analysis_NoNvdisasm_Desc, AnalysisStage.KERNEL_INSTANCE_SHARED_ACCESS, Severity.NODATA),
    SL_SHAREDACCESS_NO_SOURCE(ViperMessages.Analysis_NoSource_Label, ViperMessages.Analysis_NoSource_Desc, AnalysisStage.KERNEL_INSTANCE_SHARED_ACCESS, Severity.NODATA, SL_SHAREDACCESS_BAD.getRank() - 1),
    SL_DIVERGENTBRANCH_NO_KERNEL(ViperMessages.Analysis_NoKernel_Label, ViperMessages.Analysis_NoKernel_Desc, AnalysisStage.KERNEL_INSTANCE_DIVERGENT_BRANCH, Severity.NODATA),
    SL_DIVERGENTBRANCH_NO_DATA(ViperMessages.Divergent_Branch_NoData_Label, ViperMessages.Divergent_Branch_NoData_Desc, AnalysisStage.KERNEL_INSTANCE_DIVERGENT_BRANCH, Severity.NODATA),
    SL_DIVERGENT_BRANCH_FEW_SOURCE(ViperMessages.Analysis_FewSourceMapp_Label, ViperMessages.Analysis_FewSourceMapp_Desc, AnalysisStage.KERNEL_INSTANCE_DIVERGENT_BRANCH, Severity.NODATA),
    SL_DIVERGENT_BRANCH_NO_DISASM(ViperMessages.Analysis_NoNvdisasm_Label, ViperMessages.Analysis_NoNvdisasm_Desc, AnalysisStage.KERNEL_INSTANCE_DIVERGENT_BRANCH, Severity.NODATA),
    SL_DIVERGENT_BRANCH(AnalysisDescriptor.enumMapInitializer(new Object[]{ResultOutput.UI, ViperMessages.Divergent_Branch_Label, ResultOutput.REPORT, ViperMessages.Divergent_Branch_Label}), AnalysisDescriptor.enumMapInitializer(new Object[]{ResultOutput.UI, ViperMessages.Divergent_Branch_Desc, ResultOutput.REPORT, ViperMessages.Divergent_Branch_Desc}), AnalysisDescriptor.enumMapInitializer(new Object[]{ResultOutput.UI, ViperMessages.Divergent_Branch_ActionDesc, ResultOutput.REPORT, ViperMessages.Divergent_Branch_ActionDesc_Report}), AnalysisStage.KERNEL_INSTANCE_DIVERGENT_BRANCH, Severity.EFFICIENCY),
    SL_DIVERGENTBRANCH_NO_SOURCE(ViperMessages.Analysis_NoSource_Label, ViperMessages.Analysis_NoSource_Desc, AnalysisStage.KERNEL_INSTANCE_DIVERGENT_BRANCH, Severity.NODATA, SL_DIVERGENT_BRANCH.getRank() - 1),
    SL_INSTRUCTION_EXECUTION_FEW_SOURCE(ViperMessages.Analysis_FewSourceMapp_Label, ViperMessages.Analysis_FewSourceMapp_Desc, AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION, Severity.NODATA),
    SL_INSTRUCTION_EXECUTION_NO_KERNEL(ViperMessages.Analysis_NoKernel_Label, ViperMessages.Analysis_NoKernel_Desc, AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION, Severity.NODATA),
    SL_INSTRUCTION_EXECUTION_NO_DATA(ViperMessages.Instruction_Execution_Failed_Title, ViperMessages.Instruction_Execution_Failed_Message, AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION, Severity.NODATA),
    SL_INSTRUCTION_EXECUTION_NO_DISASM(ViperMessages.Analysis_NoNvdisasm_Label, ViperMessages.Analysis_NoNvdisasm_Desc, AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION, Severity.NODATA),
    SL_INSTRUCTION_EXECUTION(AnalysisDescriptor.enumMapInitializer(new Object[]{ResultOutput.UI, ViperMessages.Instruction_Execution_Label, ResultOutput.REPORT, ViperMessages.Instruction_Execution_Label}), AnalysisDescriptor.enumMapInitializer(new Object[]{ResultOutput.UI, ViperMessages.Instruction_Execution_Desc, ResultOutput.REPORT, ViperMessages.Instruction_Execution_Desc}), AnalysisDescriptor.enumMapInitializer(new Object[]{ResultOutput.UI, ViperMessages.Instruction_Execution_ActionDesc, ResultOutput.REPORT, ViperMessages.Instruction_Execution_ActionDesc_Report}), AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION, Severity.EFFICIENCY),
    SL_INSTRUCTION_EXECUTION_NO_SOURCE(ViperMessages.Analysis_NoSource_Label, ViperMessages.Analysis_NoSource_Sass_Desc, AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION, Severity.NODATA, SL_INSTRUCTION_EXECUTION.getRank() - 1),
    SL_PC_SAMPLING_FEW_SOURCE(ViperMessages.Analysis_FewSourceMapp_Label, ViperMessages.Analysis_FewSourceMapp_Desc, AnalysisStage.KERNEL_INSTANCE_PC_SAMPLING, Severity.NODATA),
    SL_PC_SAMPLING_NO_DATA(ViperMessages.Pc_Sampling_Failed_Title, ViperMessages.Pc_Sampling_Failed_Message, AnalysisStage.KERNEL_INSTANCE_PC_SAMPLING, Severity.NODATA),
    SL_PC_SAMPLING_NO_KERNEL(ViperMessages.Analysis_NoKernel_Label, ViperMessages.Analysis_NoKernel_Desc, AnalysisStage.KERNEL_INSTANCE_PC_SAMPLING, Severity.NODATA),
    SL_PC_SAMPLING_NO_DISASM(ViperMessages.Analysis_NoNvdisasm_Label, ViperMessages.Analysis_NoNvdisasm_Desc, AnalysisStage.KERNEL_INSTANCE_PC_SAMPLING, Severity.NODATA),
    SL_PC_SAMPLING(AnalysisDescriptor.enumMapInitializer(new Object[]{ResultOutput.UI, ViperMessages.Pc_Sampling_Label, ResultOutput.REPORT, ViperMessages.Pc_Sampling_Label}), AnalysisDescriptor.enumMapInitializer(new Object[]{ResultOutput.UI, ViperMessages.Pc_Sampling_Desc, ResultOutput.REPORT, ViperMessages.Pc_Sampling_Desc}), AnalysisDescriptor.enumMapInitializer(new Object[]{ResultOutput.UI, ViperMessages.Pc_Sampling_ActionDesc, ResultOutput.REPORT, ViperMessages.Pc_Sampling_ActionDesc_Report}), AnalysisStage.KERNEL_INSTANCE_PC_SAMPLING, Severity.EFFICIENCY),
    SL_PC_SAMPLING_NO_SOURCE(ViperMessages.Analysis_NoSource_Label, ViperMessages.Analysis_NoSource_Sass_Desc, AnalysisStage.KERNEL_INSTANCE_PC_SAMPLING, Severity.NODATA, SL_PC_SAMPLING.getRank() - 1),
    DEPENDENCY_ANALYSIS(ViperMessages.Dependency_Analysis_Label, ViperMessages.Dependency_Analysis_Desc, AnalysisStage.DEPENDENCY_ANALYSIS, Severity.INFO),
    DEPENDENCY_ANALYSIS_NO_DATA(ViperMessages.Dependency_Analysis_NoData_Label, ViperMessages.Dependency_Analysis_NoData_Desc, AnalysisStage.DEPENDENCY_ANALYSIS, Severity.NODATA),
    DEPENDENCY_ANALYSIS_NO_THREAD_DATA(ViperMessages.Dependency_Analysis_NoThreadData_Label, ViperMessages.Dependency_Analysis_NoThreadData_Desc, AnalysisStage.DEPENDENCY_ANALYSIS, Severity.WARNING),
    DEPENDENCY_ANALYSIS_OLD_PDM(ViperMessages.Dependency_Analysis_OldPdm_Label, ViperMessages.Dependency_Analysis_OldPdm_Desc, AnalysisStage.DEPENDENCY_ANALYSIS, Severity.INFO),
    NVLINK_TOPOLOGY(ViperMessages.NvLink_Analysis_Label, ViperMessages.NvLink_Analysis_Desc, AnalysisStage.NVLINK_TOPOLOGY, Severity.INFO),
    NVSWITCH_TOPOLOGY(ViperMessages.NvLink_Analysis_Label, ViperMessages.NvSwitch_Analysis_Desc, AnalysisStage.NVLINK_TOPOLOGY, Severity.INFO),
    NVLINK_TOPOLOGY_NO_DATA(ViperMessages.NvLink_Analysis_NoData_Label, ViperMessages.NvLink_Analysis_NoData_Desc, AnalysisStage.NVLINK_TOPOLOGY, Severity.NODATA),
    NVLINK_TOPOLOGY_OLD_PDM(ViperMessages.NvLink_Analysis_OldPdm_Label, ViperMessages.NvLink_Analysis_OldPdm_Desc, AnalysisStage.NVLINK_TOPOLOGY, Severity.WARNING),
    NVLINK_TOPOLOGY_NOT_SUPPORTED(ViperMessages.NvLink_Analysis_OldPdm_Label, ViperMessages.NvLink_Analysis_Not_Supported_Desc, AnalysisStage.NVLINK_TOPOLOGY, Severity.WARNING),
    UVM_ANALYSIS(ViperMessages.UvmAnalysis_Label, ViperMessages.UvmAnalysis_Desc, AnalysisStage.UNIFIED_MEMORY, Severity.INFO),
    UVM_ANALYSIS_NO_DATA(ViperMessages.UvmAnalysis_NoData_Label, ViperMessages.UvmAnalysis_NoData_Desc, AnalysisStage.UNIFIED_MEMORY, Severity.NODATA),
    UVM_ANALYSIS_NOT_PROFILED(ViperMessages.UvmAnalysis_NotProfiled_Label, ViperMessages.UvmAnalysis_NotProfiled_Desc, AnalysisStage.UNIFIED_MEMORY, Severity.WARNING),
    UVM_ANALYSIS_OLD_PDM(ViperMessages.Dependency_Analysis_OldPdm_Label, ViperMessages.Dependency_Analysis_OldPdm_Desc, AnalysisStage.UNIFIED_MEMORY, Severity.INFO),
    MEMORY_STAT_NO_DATA(ViperMessages.Memory_Stat_NoData_Label, ViperMessages.Memory_Stat_NoData_Desc, AnalysisStage.KERNEL_INSTANCE_MEMORY_STAT, Severity.NODATA),
    MEMORY_STAT(ViperMessages.Memory_Stat_Label, ViperMessages.Memory_Stat_Desc, AnalysisStage.KERNEL_INSTANCE_MEMORY_STAT, Severity.INFO);

    private final EnumMap<ResultOutput, String> label;
    private final EnumMap<ResultOutput, String> desc;
    private final EnumMap<ResultOutput, String> actionDesc;
    private final AnalysisStage stage;
    private final Severity severity;
    private final int rank;

    private AnalysisDescriptor(String label, String desc, String actionDesc, AnalysisStage stage, Severity severity, int rank) {
        this.label = new EnumMap(ResultOutput.class);
        this.label.put(ResultOutput.UI, label);
        this.label.put(ResultOutput.REPORT, label);
        this.desc = new EnumMap(ResultOutput.class);
        this.desc.put(ResultOutput.UI, desc);
        this.desc.put(ResultOutput.REPORT, desc);
        this.actionDesc = new EnumMap(ResultOutput.class);
        this.actionDesc.put(ResultOutput.UI, actionDesc);
        this.actionDesc.put(ResultOutput.REPORT, actionDesc);
        this.stage = stage;
        this.severity = severity;
        this.rank = rank;
    }

    private AnalysisDescriptor(EnumMap<ResultOutput, String> label, EnumMap<ResultOutput, String> desc, EnumMap<ResultOutput, String> actionDesc, AnalysisStage stage, Severity severity) {
        this(label, desc, actionDesc, stage, severity, -1);
    }

    private AnalysisDescriptor(EnumMap<ResultOutput, String> label, EnumMap<ResultOutput, String> desc, EnumMap<ResultOutput, String> actionDesc, AnalysisStage stage, Severity severity, int rank) {
        this.label = label;
        this.desc = desc;
        this.actionDesc = actionDesc;
        this.stage = stage;
        this.severity = severity;
        this.rank = rank;
    }

    private AnalysisDescriptor(String label, String desc, String actionDesc, AnalysisStage stage, Severity severity) {
        this(label, desc, actionDesc, stage, severity, -1);
    }

    private AnalysisDescriptor(String label, String desc, AnalysisStage stage, Severity severity, int rank) {
        this(label, desc, null, stage, severity, rank);
    }

    private AnalysisDescriptor(String label, String desc, AnalysisStage stage, Severity severity) {
        this(label, desc, stage, severity, -1);
    }

    public String getLabel(ResultOutput otpt) {
        return this.label.get((Object)otpt);
    }

    public String getDescription(ResultOutput otpt) {
        return this.desc.get((Object)otpt);
    }

    public String getActionDescription(ResultOutput otpt) {
        return this.actionDesc.get((Object)otpt);
    }

    public AnalysisStage getStage() {
        return this.stage;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public int getRank() {
        if (this.rank < 0) {
            switch (this.getSeverity()) {
                case OK: {
                    return 100;
                }
                case INFO: {
                    return 90;
                }
                case NODATA: {
                    return 80;
                }
            }
            return 50;
        }
        return this.rank;
    }

    private static EnumMap<ResultOutput, String> enumMapInitializer(Object ... objs) {
        if (objs.length % 2 != 0) {
            throw new RuntimeException("Internal Error: EnumMap initializer not used correctly!");
        }
        EnumMap<ResultOutput, String> map = new EnumMap<ResultOutput, String>(ResultOutput.class);
        int i = 0;
        while (i < objs.length) {
            Object key = objs[i];
            Object value = objs[i + 1];
            if (!(key instanceof ResultOutput)) {
                throw new RuntimeException("Internal Error: " + key.toString() + " not an instance of AnalysisResult.ResultOutput");
            }
            if (!(value instanceof String)) {
                throw new RuntimeException("Internal Error: " + value.toString() + " not an instance of String");
            }
            map.put((ResultOutput)((Object)key), (String)value);
            i += 2;
        }
        return map;
    }

    public static enum Severity {
        INFO,
        OK,
        UTILIZATION,
        OVERLAP,
        EFFICIENCY,
        NODATA,
        WARNING;

    }
}

