/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.FileUtils;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.activity.CuptiActivityPCSamplingStallReason;
import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.editor.SourceSassEditorInput;
import com.nvidia.viper.editor.ViewerControl;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SourceSassModel;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.CudaViewer;
import com.nvidia.viper.ui.SassViewer;
import com.nvidia.viper.ui.analysis.AnalysisViewMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class SourceSassEditor
extends EditorPart {
    private Session session;
    private SourceSassModel sourceSassModel;
    private SashForm sashForm;
    private int SASH_FORM_WIDTH = 5;
    private String cudaFileName;
    private ViewerControl cudaViewerControl;
    private ViewerControl sassViewerControl;
    private final String labelTextFormat = "File - %s";
    private String viewerFileName;
    private Map<String, String> resolvedFileMap = new HashMap<String, String>();
    private IPartListener2 partListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference partRef) {
            if (partRef != null) {
                this.handleNewActivePart(partRef.getPart(true));
            }
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        private void handleNewActivePart(IWorkbenchPart part) {
            SourceSassEditor editor;
            if (part != null && part instanceof SourceSassEditor && (editor = (SourceSassEditor)part) == SourceSassEditor.this) {
                IEditorInput editorInput = editor.getEditorInput();
                if (editorInput instanceof SourceSassEditorInput) {
                    SourceSassEditorInput sourceSassInput = (SourceSassEditorInput)editorInput;
                    TimelineIntervalKernel interval = sourceSassInput.getKernelInterval();
                    Timeline timeline = interval.getPrimaryTimeline();
                    TimelineIntervalPair newSelection = new TimelineIntervalPair(timeline, interval);
                    SourceSassEditor.this.session.setPrimarySelected(newSelection, true);
                    Analysis analysis = SourceSassEditor.this.session.getAnalysis();
                    analysis.setCurrentAnalysisMode(AnalysisViewMode.unguided);
                    SourceSassEditor.this.sassViewerControl.selectAnalysisStage(analysis);
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.nvidia.viper.analysisview");
                        }
                        catch (PartInitException partInitException) {
                            ViperExceptionHandler.logError("unable to show analysis view");
                        }
                    }
                });
            }
        }
    };

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.resolvedFileMap.clear();
        this.sourceSassModel = ((SourceSassEditorInput)input).getSourceSassModel();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        if (this.sourceSassModel != null) {
            this.sourceSassModel.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                @Override
                public void propertyChange(IModel model, String propertyName) {
                    if (propertyName.equals("sourcesassmodel:filechanged")) {
                        CuptiActivitySourceLocator locator = SourceSassEditor.this.sourceSassModel.getLocatorToOpen();
                        if (locator != null && SourceSassEditor.this.resolvedFileMap.containsKey(locator.fileName)) {
                            SourceSassEditor.this.resolvedFileMap.remove(locator.fileName);
                        }
                        SourceSassEditor.this.updateCudaViewOnFileChange();
                    }
                    if (propertyName.equals("sourcesassmodel:analysischanged")) {
                        if (SourceSassEditor.this.cudaViewerControl != null) {
                            SourceSassEditor.this.cudaViewerControl.updateAnalysis();
                        }
                        SourceSassEditor.this.sassViewerControl.updateAnalysis();
                    }
                }
            });
            this.session = this.sourceSassModel.getSession();
        }
    }

    private String resolveFilePathInViewer(CuptiActivitySourceLocator sourceLocator) {
        String fileName = null;
        if (this.resolvedFileMap.containsKey(sourceLocator.fileName)) {
            fileName = this.resolvedFileMap.get(sourceLocator.fileName);
        } else {
            fileName = FileUtils.resolveFilePathInBrowser(sourceLocator, this.session);
            this.resolvedFileMap.put(sourceLocator.fileName, fileName);
        }
        if (fileName != null) {
            this.cudaFileName = sourceLocator.fileName;
            ((CudaViewer)this.cudaViewerControl.getViewer()).setFileName(sourceLocator.fileName);
            this.cudaViewerControl.changeSourceColLabel(String.format("File - %s", fileName), fileName);
            this.viewerFileName = fileName;
        } else {
            ((CudaViewer)this.cudaViewerControl.getViewer()).highlightLine(-1);
        }
        return fileName;
    }

    public String getViewerFileName() {
        return this.viewerFileName;
    }

    protected void setInputWithNotify(IEditorInput input) {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.sashForm = new SashForm(parent, 256);
        this.sashForm.setLayout((Layout)new RowLayout());
        this.sashForm.setSashWidth(this.SASH_FORM_WIDTH);
        if (this.sourceSassModel.getLocatorToOpen() != null) {
            this.createCudaViewerControl();
        }
        this.createSassViewerControl();
        this.updateViews();
    }

    private void createSassViewerControl() {
        this.sassViewerControl = new ViewerControl(this, (Composite)this.sashForm, 2048, ViewerControl.ViewerControlType.SASS_VIEWER_CONTROL);
    }

    private void createCudaViewerControl() {
        this.cudaViewerControl = new ViewerControl(this, (Composite)this.sashForm, 2048, ViewerControl.ViewerControlType.SOURCE_VIEWER_CONTOL);
    }

    private void updateCudaViewOnFileChange() {
        CuptiActivitySourceLocator locator = this.sourceSassModel.getLocatorToOpen();
        if (locator != null && !locator.fileName.equals(this.cudaFileName) && this.resolveFilePathInViewer(locator) != null) {
            this.cudaViewerControl.updateCudaViewer();
        }
    }

    public void highlightSassLines(int cudaLine) {
        List<Integer> sassLines = this.getSassLines(cudaLine);
        if (sassLines != null && sassLines.size() > 0) {
            ((SassViewer)this.sassViewerControl.getViewer()).highlightLines(sassLines);
        } else {
            ((SassViewer)this.sassViewerControl.getViewer()).highlightLines(null);
        }
    }

    public long getInstructionExecutedSass(int sassLine) {
        SassViewer sassViewer = (SassViewer)this.sassViewerControl.getViewer();
        if (sassViewer != null) {
            return sassViewer.getInstructionExecuted(sassLine);
        }
        return -1L;
    }

    public long getThreadInstExecutedSass(int sassLine) {
        SassViewer sassViewer = (SassViewer)this.sassViewerControl.getViewer();
        if (sassViewer != null) {
            return sassViewer.getThreadInstructionExecuted(sassLine);
        }
        return -1L;
    }

    public long getNoPredicateOffSass(int sassLine) {
        SassViewer sassViewer = (SassViewer)this.sassViewerControl.getViewer();
        if (sassViewer != null) {
            return sassViewer.getNoPredicateOff(sassLine);
        }
        return -1L;
    }

    public List<Integer> getSassLines(int cudaLine) {
        return this.sourceSassModel.getSassLines(this.cudaFileName, cudaLine + 1);
    }

    public void highlightCudaLines(int sassLine) {
        int cudaLine = -1;
        CuptiActivitySourceLocator locator = this.sourceSassModel.getSourceLocator(sassLine);
        if (this.cudaViewerControl != null) {
            CudaViewer cudaViewer = (CudaViewer)this.cudaViewerControl.getViewer();
            if (locator == null) {
                cudaViewer.highlightLine(-1);
                return;
            }
            cudaLine = locator.lineNumber - 1;
            if (!locator.fileName.equals(this.cudaFileName)) {
                if (this.resolveFilePathInViewer(locator) == null) {
                    return;
                }
                this.cudaViewerControl.updateCudaViewer();
            }
            cudaViewer.highlightLine(cudaLine);
            if (cudaLine < cudaViewer.getTopIndex() || cudaLine > cudaViewer.getBottomIndex()) {
                cudaViewer.setTopIndex(cudaLine);
            }
        }
    }

    public void updateViews() {
        this.sassViewerControl.updateSassViewer();
        this.updateCudaViewOnFileChange();
    }

    public void tileViewerWindows(int orientation) {
        this.restoreViewerLayout();
        this.sashForm.setOrientation(orientation);
    }

    public void maximizeCudaView() {
        if (this.cudaViewerControl != null && !((Object)((Object)this.cudaViewerControl)).equals(this.sashForm.getMaximizedControl())) {
            this.sashForm.setMaximizedControl((Control)this.cudaViewerControl);
        }
    }

    public void maximizeSassView() {
        if (!((Object)((Object)this.sassViewerControl)).equals(this.sashForm.getMaximizedControl())) {
            this.sashForm.setMaximizedControl((Control)this.sassViewerControl);
        }
    }

    private void restoreViewerLayout() {
        if (this.sashForm.getMaximizedControl() != null) {
            this.sashForm.setMaximizedControl(null);
        }
    }

    public void setFocus() {
    }

    public SourceSassModel getSourceSassModel() {
        return this.sourceSassModel;
    }

    public Session getSession() {
        return this.session;
    }

    public long getNumSamples(Integer sassLine, CuptiActivityPCSamplingStallReason res) {
        SassViewer sassViewer = (SassViewer)this.sassViewerControl.getViewer();
        if (sassViewer != null) {
            return sassViewer.getNumSamples(sassLine, res);
        }
        return -1L;
    }

    public long getNumLatencySamples(Integer sassLine, CuptiActivityPCSamplingStallReason res) {
        SassViewer sassViewer = (SassViewer)this.sassViewerControl.getViewer();
        if (sassViewer != null) {
            return sassViewer.getNumLatencySamples(sassLine, res);
        }
        return -1L;
    }

    public ViewerControl getViewerControl(ViewerControl.ViewerControlType controlType) {
        if (controlType.equals((Object)ViewerControl.ViewerControlType.SOURCE_VIEWER_CONTOL)) {
            return this.cudaViewerControl;
        }
        return this.sassViewerControl;
    }

    public long getIdealL2TransactionsSass(Integer sassLine) {
        SassViewer sassViewer = (SassViewer)this.sassViewerControl.getViewer();
        if (sassViewer != null) {
            return sassViewer.getTheoreticalL2Transactions(sassLine);
        }
        return -1L;
    }

    public long getL2TransactionsSass(Integer sassLine) {
        SassViewer sassViewer = (SassViewer)this.sassViewerControl.getViewer();
        if (sassViewer != null) {
            return sassViewer.getL2Transactions(sassLine);
        }
        return -1L;
    }

    public long getIdealSharedTransactionsSass(Integer sassLine) {
        SassViewer sassViewer = (SassViewer)this.sassViewerControl.getViewer();
        if (sassViewer != null) {
            return sassViewer.getTheoreticalSharedTransactions(sassLine);
        }
        return -1L;
    }

    public long getSharedTransactionsSass(Integer sassLine) {
        SassViewer sassViewer = (SassViewer)this.sassViewerControl.getViewer();
        if (sassViewer != null) {
            return sassViewer.getSharedTransactions(sassLine);
        }
        return -1L;
    }

    public long getDivergentBranchSass(Integer sassLine) {
        SassViewer sassViewer = (SassViewer)this.sassViewerControl.getViewer();
        if (sassViewer != null) {
            return sassViewer.getNumDivergedBranch(sassLine);
        }
        return -1L;
    }

    public long getL2InstructionExecutedSass(Integer sassLine) {
        SassViewer sassViewer = (SassViewer)this.sassViewerControl.getViewer();
        if (sassViewer != null) {
            return sassViewer.getL2InstExecuted(sassLine);
        }
        return -1L;
    }

    public long getSharedInstructionExecutedSass(Integer sassLine) {
        SassViewer sassViewer = (SassViewer)this.sassViewerControl.getViewer();
        if (sassViewer != null) {
            return sassViewer.getSharedInstExecuted(sassLine);
        }
        return -1L;
    }

    public long getDivergentInstExecutedSass(Integer sassLine) {
        SassViewer sassViewer = (SassViewer)this.sassViewerControl.getViewer();
        if (sassViewer != null) {
            return sassViewer.getDivergeInstExecuted(sassLine);
        }
        return -1L;
    }

    public static enum AnnotationType {
        HOTSPOT_HIGH("hotspot1.type", ViperColors.COLOR_HOTSPOT_HIGH, "HIGH"),
        HOTSPOT_MED("hotspot2.type", ViperColors.COLOR_HOTSPOT_MED, "MID");

        private final String type;
        private final Color color;
        private final String desc;

        private AnnotationType(String type, Color color, String desc) {
            this.type = type;
            this.color = color;
            this.desc = desc;
        }

        public String getType() {
            return this.type;
        }

        public Color getColor() {
            return this.color;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    class InfoControlCreator
    implements IInformationControlCreator {
        InfoControlCreator() {
        }

        public IInformationControl createInformationControl(Shell parent) {
            return new DefaultInformationControl(parent);
        }
    }

    class SharedColor
    implements ISharedTextColors {
        SharedColor() {
        }

        public Color getColor(RGB rgb) {
            return new Color((Device)Display.getDefault(), rgb);
        }

        public void dispose() {
        }
    }
}

