/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.expertsystem;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultIntervalNoData;
import com.nvidia.viper.analysis.AnalysisResultKernelBounds;
import com.nvidia.viper.analysis.AnalysisResultKernelMemory;
import com.nvidia.viper.analysis.AnalysisResultLocalMemoryOverhead;
import com.nvidia.viper.analysis.AnalysisResultMemoryStat;
import com.nvidia.viper.analysis.AnalysisResultSharedAccess;
import com.nvidia.viper.analysis.AnalysisResultUncoalescedGlobalMemory;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.expertsystem.ExpertSystemStageKind;
import com.nvidia.viper.expertsystem.ExpertSystemStepAction;
import com.nvidia.viper.expertsystem.IExpertSystemStage;
import com.nvidia.viper.expertsystem.KernelInstanceStage;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.ITimelineInterval;
import java.util.LinkedList;

public class MemoryStage
extends KernelInstanceStage
implements IExpertSystemStage {
    public MemoryStage(ExpertSystem expertSystem) {
        super(expertSystem);
    }

    @Override
    public ExpertSystemStageKind getStageKind() {
        return ExpertSystemStageKind.MEMORY;
    }

    @Override
    public String getTitle(ResultOutput otpt) {
        return ViperMessages.ExpertSystem_Memory_Title;
    }

    public static ExpertSystemStepAction getAnalysisRunAction(boolean force) {
        return new ExpertSystemStepAction(new ExpertSystemStepAction(force, AnalysisStage.KERNEL_INSTANCE_MEMORY, AnalysisStage.KERNEL_INSTANCE_UNCOALESCED_GLOBAL, AnalysisStage.KERNEL_INSTANCE_SHARED_ACCESS, AnalysisStage.KERNEL_INSTANCE_MEMORY_STAT));
    }

    @Override
    public ExpertSystemStepAction update() {
        this.stageDesc = ViperMessages.ExpertSystem_Memory_Desc;
        this.numSteps = 0;
        this.stepTitles = null;
        this.stepDescs = null;
        this.stepActions = null;
        ExpertSystemStepAction updateAction = ExpertSystemStepAction.NONE;
        ITimelineInterval kernel = this.getSelectedInDepthKernel();
        AnalysisResultIntervalNoData failResult = this.getFailResult();
        AnalysisResultKernelBounds boundsResult = this.getBoundsResult();
        AnalysisResultKernelMemory memoryResult = this.getMemoryResult();
        AnalysisResultUncoalescedGlobalMemory uncoalResult = this.getUncoalescedResult();
        AnalysisResultSharedAccess sharedAccessResult = this.getSharedResult();
        AnalysisResultLocalMemoryOverhead lmemResult = this.getLmemOverheadResult();
        AnalysisResult uncoalNoSourceResult = this.getUncoalescedNoSourceResult();
        AnalysisResult sharedAccessNoSourceResult = this.getSharedAccessNoSourceResult();
        if (memoryResult != null && boundsResult != null && (AnalysisResultKernelBounds.Bound.BALANCED_COMPUTE_MEMORY.equals((Object)boundsResult.getBound()) || AnalysisResultKernelBounds.Bound.MEMORY.equals((Object)boundsResult.getBound()))) {
            memoryResult.SetIsPerformanceLimiter(boundsResult.getMemoryBound());
        }
        if (kernel == null) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_DescNoKernel;
            updateAction = ExpertSystemStepAction.CLEAR_RESULTS;
        } else if (failResult != null) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_DescFailResult;
            this.numSteps = 0;
            this.stepTitles = null;
            this.stepDescs = null;
            this.stepActions = null;
            updateAction = new ExpertSystemStepAction(AnalysisStage.KERNEL_INSTANCE_MEMORY, AnalysisResultIntervalNoData.class);
        } else if (memoryResult == null) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_DescNoResult;
            this.numSteps = 1;
            this.stepTitles = new String[]{ViperMessages.ExpertSystem_StepNoResult_Title};
            this.stepDescs = new String[]{ViperMessages.ExpertSystem_StepNoResult_Desc};
            this.stepActions = new ExpertSystemStepAction[]{KernelInstanceStage.getAnalysisRunAction(false)};
            updateAction = ExpertSystemStepAction.CLEAR_RESULTS;
        } else {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + this.getDescriptionForMemoryResult(memoryResult);
            LinkedList<ExpertSystemStepAction.ShowResultsData> showResults = new LinkedList<ExpertSystemStepAction.ShowResultsData>();
            if (memoryResult.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.L1SHARED) || memoryResult.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.UNIFIED) || memoryResult.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.L2) || memoryResult.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.DRAM)) {
                if (uncoalNoSourceResult != null || sharedAccessNoSourceResult != null) {
                    if (uncoalNoSourceResult != null) {
                        showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_UNCOALESCED_GLOBAL, AnalysisResult.class, AnalysisDescriptor.SL_GLOBALMEMORYUNCOALESCED_NO_SOURCE));
                    } else {
                        showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_SHARED_ACCESS, AnalysisResult.class, AnalysisDescriptor.SL_SHAREDACCESS_NO_SOURCE));
                    }
                }
                if (uncoalResult != null) {
                    showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_UNCOALESCED_GLOBAL, AnalysisResultUncoalescedGlobalMemory.class));
                }
                if (lmemResult != null) {
                    showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_MEMORY, AnalysisResultLocalMemoryOverhead.class));
                }
            }
            if ((memoryResult.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.L1SHARED) || memoryResult.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.SHARED)) && sharedAccessResult != null) {
                showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_SHARED_ACCESS, AnalysisResultSharedAccess.class));
            }
            showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_MEMORY, AnalysisResultKernelMemory.class));
            showResults.add(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_MEMORY_STAT, AnalysisResultMemoryStat.class));
            this.numSteps = 1;
            this.stepTitles = new String[]{ViperMessages.ExpertSystem_StepRerun_Title};
            this.stepDescs = new String[]{ViperMessages.ExpertSystem_StepRerun_Desc};
            this.stepActions = new ExpertSystemStepAction[]{KernelInstanceStage.getAnalysisRunAction(true)};
            updateAction = new ExpertSystemStepAction(showResults.toArray(new ExpertSystemStepAction.ShowResultsData[0]));
        }
        return updateAction;
    }

    private String getDescriptionForMemoryResult(AnalysisResultKernelMemory memoryResult) {
        if (memoryResult.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.L1SHARED)) {
            return ViperMessages.ExpertSystem_Memory_DescL1SharedLimited;
        }
        if (memoryResult.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.SHARED)) {
            return ViperMessages.ExpertSystem_Memory_DescSharedLimited;
        }
        if (memoryResult.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.L2)) {
            return ViperMessages.ExpertSystem_Memory_DescL2Limited;
        }
        if (memoryResult.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.TEX)) {
            return ViperMessages.ExpertSystem_Memory_DescTextureLimited;
        }
        if (memoryResult.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.UNIFIED)) {
            return ViperMessages.ExpertSystem_Memory_DescUnifiedLimited;
        }
        if (memoryResult.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.DRAM)) {
            return ViperMessages.ExpertSystem_Memory_DescDramLimited;
        }
        if (memoryResult.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.SYSMEM)) {
            return ViperMessages.ExpertSystem_Memory_DescSystemLimited;
        }
        return "";
    }

    private AnalysisResultIntervalNoData getFailResult() {
        return (AnalysisResultIntervalNoData)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_MEMORY, AnalysisResultIntervalNoData.class);
    }

    private AnalysisResultKernelBounds getBoundsResult() {
        return (AnalysisResultKernelBounds)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_BOUNDS, AnalysisResultKernelBounds.class);
    }

    private AnalysisResultKernelMemory getMemoryResult() {
        return (AnalysisResultKernelMemory)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_MEMORY, AnalysisResultKernelMemory.class);
    }

    private AnalysisResultUncoalescedGlobalMemory getUncoalescedResult() {
        return (AnalysisResultUncoalescedGlobalMemory)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_UNCOALESCED_GLOBAL, AnalysisResultUncoalescedGlobalMemory.class);
    }

    private AnalysisResultSharedAccess getSharedResult() {
        return (AnalysisResultSharedAccess)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_SHARED_ACCESS, AnalysisResultSharedAccess.class);
    }

    private AnalysisResultLocalMemoryOverhead getLmemOverheadResult() {
        return (AnalysisResultLocalMemoryOverhead)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_MEMORY, AnalysisResultLocalMemoryOverhead.class);
    }

    private AnalysisResult getUncoalescedNoSourceResult() {
        return this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_UNCOALESCED_GLOBAL, AnalysisResult.class, AnalysisDescriptor.SL_GLOBALMEMORYUNCOALESCED_NO_SOURCE);
    }

    private AnalysisResult getSharedAccessNoSourceResult() {
        return this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_SHARED_ACCESS, AnalysisResult.class, AnalysisDescriptor.SL_SHAREDACCESS_NO_SOURCE);
    }
}

