/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.jni;

import java.util.HashMap;
import java.util.Map;

public enum CuptiMetricEvaluationMode {
    CUPTI_METRIC_EVALUATION_MODE_PER_INSTANCE(1),
    CUPTI_METRIC_EVALUATION_MODE_AGGREGATE(2),
    CUPTI_METRIC_EVALUATION_MODE_BOTH(3);

    private int code;
    private static Map<Integer, CuptiMetricEvaluationMode> codeMap;

    static {
        codeMap = new HashMap<Integer, CuptiMetricEvaluationMode>();
        CuptiMetricEvaluationMode[] cuptiMetricEvaluationModeArray = CuptiMetricEvaluationMode.values();
        int n = cuptiMetricEvaluationModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuptiMetricEvaluationMode res = cuptiMetricEvaluationModeArray[n2];
            codeMap.put(res.getCode(), res);
            ++n2;
        }
    }

    private CuptiMetricEvaluationMode(int code) {
        this.code = code;
    }

    public boolean isAggregateMode() {
        return CUPTI_METRIC_EVALUATION_MODE_AGGREGATE.equals((Object)this) || CUPTI_METRIC_EVALUATION_MODE_BOTH.equals((Object)this);
    }

    public boolean isPerInstanceMode() {
        return CUPTI_METRIC_EVALUATION_MODE_PER_INSTANCE.equals((Object)this) || CUPTI_METRIC_EVALUATION_MODE_BOTH.equals((Object)this);
    }

    public int getCode() {
        return this.code;
    }

    public static CuptiMetricEvaluationMode valueOf(String string) {
        return Enum.valueOf(CuptiMetricEvaluationMode.class, string);
    }
}

