/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.Activator;
import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.fs.RemoteFileSystem;
import com.nvidia.viper.ui.ConnectionControl;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class ImportMultipleFilesControl
extends Composite {
    private List multiplePathsList;
    private ConnectionControl connection;
    private PropertyChangeSupport listeners = new PropertyChangeSupport((Object)this);
    public static final String LIST_UPDATED = "ImportMultipleFilesControl:updated";
    public static final String LIST_SELECTION_CHANGED = "ImportMultipleFilesControl:listselectionchanged";
    public static final String LIST_ITEMS_REMOVED = "ImportMultipleFilesControl:listitemsremoved";

    public ImportMultipleFilesControl(Composite parent, ConnectionControl connection) {
        super(parent, 0);
        this.connection = connection;
        this.setLayoutData(new GridData(4, 4, true, true));
        GridLayout mainLayout = new GridLayout(2, false);
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        this.setLayout((Layout)mainLayout);
        this.multiplePathsList = new List((Composite)this, 2562);
        this.multiplePathsList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.multiplePathsList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportMultipleFilesControl.this.firePropertyChange(ImportMultipleFilesControl.LIST_SELECTION_CHANGED);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ButtonControl buttons = new ButtonControl(this, 8);
        buttons.setLayoutData(new GridData(4, 4, false, false));
    }

    public List getMultipleFilesListControl() {
        return this.multiplePathsList;
    }

    public String[] getFiles() throws ViperException, CoreException {
        if (this.multiplePathsList.getItemCount() > 0) {
            if (this.connection.isLocalConnection()) {
                return this.multiplePathsList.getItems();
            }
            RemoteFileSystem remote = (RemoteFileSystem)this.connection.getFileSystem();
            NullProgressMonitor monitor = new NullProgressMonitor();
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)600);
            String[] items = this.multiplePathsList.getItems();
            String[] localFiles = new String[this.multiplePathsList.getItemCount()];
            int i = 0;
            while (i < items.length) {
                File[] result = remote.dowloadProfilingResultFile((IPath)new Path(items[i]), m, null);
                if (result != null && result.length == 1) {
                    localFiles[i] = result[0].getAbsolutePath();
                }
                ++i;
            }
            return localFiles;
        }
        return null;
    }

    public void addListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName) {
        this.listeners.firePropertyChange(propertyName, null, null);
    }

    private class ButtonControl
    extends Composite {
        ButtonControl(Composite parent, int style) {
            super(parent, style);
            this.setLayoutData(new GridData(4, 4, true, true));
            GridLayout mainLayout = new GridLayout(1, false);
            mainLayout.marginWidth = 0;
            mainLayout.marginHeight = 0;
            this.setLayout((Layout)mainLayout);
            Button multiBrowseButton = new Button((Composite)this, 8);
            multiBrowseButton.setText("Browse...");
            multiBrowseButton.setLayoutData((Object)new GridData(4, 4, true, false));
            multiBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String dialogPath = Activator.getDefault().getPreferenceStore().getString("ImportPath");
                    FileSystem fileSystem = null;
                    if (ImportMultipleFilesControl.this.connection != null) {
                        fileSystem = ImportMultipleFilesControl.this.connection.getFileSystem();
                    } else {
                        String name = null;
                        try {
                            fileSystem = FileSystem.getFilesystem(name);
                        }
                        catch (ConnectionNotFoundException e1) {
                            ViperExceptionHandler.logError(e1.getMessage());
                        }
                    }
                    String[] filenames = null;
                    try {
                        filenames = fileSystem.browseForFileMulti(ButtonControl.this.getShell(), "Select files", "Select " + Viper.COMMANDLINE_PRODUCT_NAME + " profile file containing timeline data", dialogPath);
                    }
                    catch (CoreException e1) {
                        ViperExceptionHandler.logError(e1.getMessage());
                    }
                    if (filenames != null) {
                        Activator.getDefault().getPreferenceStore().setValue("ImportPath", (String)filenames[filenames.length - 1]);
                        if (ImportMultipleFilesControl.this.multiplePathsList.getItemCount() == 0) {
                            ImportMultipleFilesControl.this.multiplePathsList.setItems(filenames);
                        } else {
                            String[] stringArray = filenames;
                            int n = filenames.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String filename = stringArray[n2];
                                ImportMultipleFilesControl.this.multiplePathsList.add(filename);
                                ++n2;
                            }
                        }
                        ImportMultipleFilesControl.this.firePropertyChange(ImportMultipleFilesControl.LIST_UPDATED);
                    }
                }
            });
            Button removeButton = new Button((Composite)this, 8);
            removeButton.setText("Remove");
            removeButton.setLayoutData((Object)new GridData(4, 4, true, false));
            removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ImportMultipleFilesControl.this.firePropertyChange(ImportMultipleFilesControl.LIST_ITEMS_REMOVED);
                    ImportMultipleFilesControl.this.multiplePathsList.remove(ImportMultipleFilesControl.this.multiplePathsList.getSelectionIndices());
                    ImportMultipleFilesControl.this.firePropertyChange(ImportMultipleFilesControl.LIST_UPDATED);
                }
            });
        }
    }
}

