/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.ConnectionControl;
import com.nvidia.viper.ui.ImportMultipleFilesControl;
import com.nvidia.viper.ui.TimelineOptionsControl;
import com.nvidia.viper.ui.UVMSegmentComposite;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ImportNvprofMultiProcessPage
extends WizardPage {
    private ImportMultipleFilesControl multipleFilesControl;
    private ConnectionControl connectionControl;
    private Button normalizeIndependently;
    private UVMSegmentComposite segmentControl;
    private Session session;
    private TimelineOptionsControl timelineOptionControl;

    public ImportNvprofMultiProcessPage(String pageName) {
        super(pageName);
        this.setTitle(ViperMessages.ImportNvprof_WizardPageMulti_Title);
        this.setDescription(ViperMessages.ImportNvprof_WizardPageMulti_Message);
        this.session = new Session();
    }

    public void createControl(Composite parent) {
        final TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                int index = tabFolder.getSelectionIndex();
                if (index == 0) {
                    ImportNvprofMultiProcessPage.this.setTitle(ViperMessages.ImportNvprof_WizardPageMulti_Title);
                    ImportNvprofMultiProcessPage.this.setDescription(ViperMessages.ImportNvprof_WizardPageMulti_Message);
                } else if (index == 1) {
                    ImportNvprofMultiProcessPage.this.setTitle(ViperMessages.TimelineOptionsPage_Title);
                    ImportNvprofMultiProcessPage.this.setDescription(ViperMessages.TimelineOptionsPage_Message);
                }
            }
        });
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Profile Files");
        Composite composite = new Composite((Composite)tabFolder, 0);
        tabItem.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label labelConnection = new Label(composite, 0);
        labelConnection.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        labelConnection.setText(ViperMessages.Connection_Label);
        this.connectionControl = new ConnectionControl(composite);
        this.connectionControl.setLayoutData(new GridData(4, 4, false, false));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        label.setText("The " + Viper.COMMANDLINE_PRODUCT_NAME + " profile files:");
        this.multipleFilesControl = new ImportMultipleFilesControl(composite, this.connectionControl);
        this.multipleFilesControl.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.multipleFilesControl.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("ImportMultipleFilesControl:updated")) {
                    List listFiles = ImportNvprofMultiProcessPage.this.multipleFilesControl.getMultipleFilesListControl();
                    if (listFiles.getItemCount() > 0) {
                        ImportNvprofMultiProcessPage.this.setErrorMessage(null);
                        ImportNvprofMultiProcessPage.this.setPageComplete(true);
                    } else {
                        ImportNvprofMultiProcessPage.this.setPageComplete(false);
                    }
                }
            }
        });
        this.normalizeIndependently = new Button(composite, 32);
        this.normalizeIndependently.setText("Normalize each profile file independently");
        this.normalizeIndependently.setToolTipText("If the application is using barrier on each node before the first CUDA API call (e.g. by using MPI barrier) then the first timestamp in each file can be assumed to be in sync. Normalizing each file independently will cause them to be aligned correctly.");
        this.normalizeIndependently.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.segmentControl = new UVMSegmentComposite(composite, 0);
        this.segmentControl.setLayoutData(new GridData(1, 0x1000000, false, false, 3, 1));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(ViperMessages.TimelineOptionsPage_Title);
        this.timelineOptionControl = new TimelineOptionsControl((Composite)tabFolder, 0);
        this.timelineOptionControl.setInput(this.session);
        this.timelineOptionControl.addListener(new TimelineOptionsControl.ITimelineOptionListener(){

            @Override
            public void firePageComplete(boolean complete, String message) {
                ImportNvprofMultiProcessPage.this.setPageComplete(complete);
                ImportNvprofMultiProcessPage.this.setErrorMessage(message);
            }
        });
        tabItem.setControl((Control)this.timelineOptionControl);
        this.setControl((Control)tabFolder);
        this.setPageComplete(false);
    }

    public boolean isCurrent() {
        return this.isCurrentPage();
    }

    public String[] getFilePaths() throws ViperException, CoreException {
        return this.multipleFilesControl.getFiles();
    }

    public Session getUpdatedSession() {
        this.session.setNormalizeIndependently(this.normalizeIndependently.getSelection());
        this.session.setNumSegmentsUVM(this.segmentControl.getNumSegments());
        this.session.setIsUVMSegmentEnabled(this.segmentControl.isSegmentEnabled());
        return this.session;
    }
}

