/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ViewUtils;
import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.SessionActionConstants;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.jni.OpenAccAggregate;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SummaryType;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.TimelineProcess;
import com.nvidia.viper.ui.IContextOwner;
import com.nvidia.viper.ui.OpenAccContentProvider;
import com.nvidia.viper.ui.OpenAccLabelProvider;
import com.nvidia.viper.ui.OpenAccLabelType;
import com.nvidia.viper.ui.SessionEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class OpenAccView
extends ViewPart
implements IContextOwner,
ISessionPropertyChangeListener {
    public static final String ID = "com.nvidia.viper.ui.OpenACCView";
    private ActivePartListener asListener = new ActivePartListener();
    private Session session;
    private Composite parent;
    private TreeViewer tree;
    private SummaryType mode = SummaryType.inclusive;
    private clusivityAction inclusiveAction;
    private clusivityAction exclusiveAction;
    private OpenAccLabelProvider totalTimeLabelContentProvider;
    private int processId;
    private static String processLabelPrefix = "Summary of OpenACC events on process: ";
    private Label processLabel;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        GridLayout layout = new GridLayout();
        this.processLabel = new Label(form.getBody(), 128);
        this.processLabel.setBackground(form.getBackground());
        form.getBody().setLayout((Layout)layout);
        this.tree = new TreeViewer(form.getBody(), 4);
        this.tree.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree.setContentProvider((IContentProvider)new OpenAccContentProvider());
        OpenAccLabelProvider NameLabelContentProvider = new OpenAccLabelProvider(OpenAccLabelType.name);
        TreeViewerColumn column = new TreeViewerColumn(this.tree, 16384);
        column.getColumn().setWidth(220);
        column.setLabelProvider((CellLabelProvider)NameLabelContentProvider);
        column.getColumn().setText(NameLabelContentProvider.getTitle());
        OpenAccLabelProvider PercentageLabelContentProvider = new OpenAccLabelProvider(OpenAccLabelType.percentage);
        column = new TreeViewerColumn(this.tree, 16384);
        column.getColumn().setWidth(100);
        column.setLabelProvider((CellLabelProvider)PercentageLabelContentProvider);
        column.getColumn().setText(PercentageLabelContentProvider.getTitle());
        this.totalTimeLabelContentProvider = new OpenAccLabelProvider(OpenAccLabelType.totalTime);
        column = new TreeViewerColumn(this.tree, 16384);
        column.getColumn().setWidth(100);
        column.setLabelProvider((CellLabelProvider)this.totalTimeLabelContentProvider);
        column.getColumn().setText(this.totalTimeLabelContentProvider.getTitle());
        OpenAccLabelProvider CallsLabelContentProvider = new OpenAccLabelProvider(OpenAccLabelType.calls);
        column = new TreeViewerColumn(this.tree, 16384);
        column.getColumn().setWidth(100);
        column.setLabelProvider((CellLabelProvider)CallsLabelContentProvider);
        column.getColumn().setText(CallsLabelContentProvider.getTitle());
        this.tree.getTree().pack();
        this.tree.getTree().setHeaderVisible(true);
        this.tree.getTree().setLinesVisible(true);
        this.tree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection select = (IStructuredSelection)event.getSelection();
                OpenAccAggregate node = (OpenAccAggregate)select.getFirstElement();
                if (node != null && node.getRelativeFilePath().compareTo("Unknown Filename") != 0) {
                    ViewUtils.openSourceView(OpenAccView.this.session, OpenAccView.this.parent.getShell(), node.getRelativeFilePath(), node.getFullFilePath(), node.getLineNo());
                }
            }
        });
        this.createActions();
        this.createToolBar(parent);
        ViperHelp.setContextHelp((Control)parent, ViperHelp.OPEN_ACC_DETAILS_VIEW_CONTEXT_ID);
    }

    private void createToolBar(Composite parent) {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.inclusiveAction);
        mgr.add((IAction)this.exclusiveAction);
    }

    private void handleClosedActivePart(IWorkbenchPart part) {
        if (part instanceof SessionEditor) {
            this.tree.setInput(null);
            this.processId = 0;
        }
    }

    @Override
    public void ownerChanged(IContextOwner oldOwner, IContextOwner newOwner) {
    }

    private void handleNewActivePart(IWorkbenchPart part) {
        Session newSession = null;
        if (part instanceof SessionEditor) {
            newSession = ((SessionEditor)part).getSession();
        } else if (part instanceof SourceSassEditor) {
            newSession = ((SourceSassEditor)part).getSession();
        } else if (part instanceof OpenAccView) {
            newSession = ((OpenAccView)part).session;
        }
        Session oldSession = this.session;
        if (newSession != null) {
            this.session = newSession;
            this.session.addPropertyChangeListener(this);
            this.processId = this.session.getSummaryViewDefaultProcess();
            if (oldSession != null) {
                this.refreshView();
            }
        }
    }

    private void refreshView() {
        if (this.tree != null && this.tree.getControl() != null && !this.tree.getControl().isDisposed()) {
            this.tree.getTree().setVisible(false);
            this.tree.setInput((Object)this.session.getOpenAccSummary(this.processId).getRoot());
            if (this.processId != 0) {
                this.processLabel.setText(String.valueOf(processLabelPrefix) + new Integer(this.processId).toString());
            } else {
                this.processLabel.setText("");
            }
            this.tree.refresh();
            this.tree.getTree().setVisible(true);
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.asListener);
    }

    private void createActions() {
        this.inclusiveAction = new clusivityAction(SummaryType.inclusive);
        this.exclusiveAction = new clusivityAction(SummaryType.exclusive);
        this.inclusiveAction.setChecked(true);
        this.exclusiveAction.setChecked(false);
    }

    public void setFocus() {
        if (this.parent != null) {
            this.parent.setFocus();
        }
    }

    @Override
    public void propertyChange(IModel model, String propertyName) {
        if ("session:sInterval".equals(propertyName) && this.session != null && this.session.getPrimarySelected() != null) {
            Timeline timeline = this.session.getPrimarySelected().getTimeline();
            if (timeline.getKind() != TimelineKind.PROCESS) {
                timeline = timeline.getAncestor(TimelineKind.PROCESS);
            }
            if (timeline == null) {
                return;
            }
            this.processId = ((TimelineProcess)timeline).getId();
            this.tree.setInput((Object)this.session.getOpenAccSummary(this.processId).getRoot());
            if (this.processId != 0) {
                this.processLabel.setText(String.valueOf(processLabelPrefix) + new Integer(this.processId).toString());
            } else {
                this.processLabel.setText("");
            }
        }
    }

    private class ActivePartListener
    implements IPartListener {
        private ActivePartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            OpenAccView.this.handleNewActivePart(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            OpenAccView.this.handleNewActivePart(part);
        }

        public void partOpened(IWorkbenchPart part) {
            OpenAccView.this.handleNewActivePart(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            OpenAccView.this.handleClosedActivePart(part);
        }
    }

    private class clusivityAction
    extends Action {
        private SummaryType mode;

        public clusivityAction(SummaryType m) {
            super("", 8);
            this.mode = m;
            switch (this.mode) {
                case inclusive: {
                    this.setText(ViperMessages.OpenAccViewInclusive_Label);
                    this.setImageDescriptor(ViperImages.DESC_OPENACC_INCLUSIVE);
                    this.setToolTipText(ViperMessages.OpenAccInclusive_Tooltip);
                    this.setId(SessionActionConstants.OPENACC_INCLUSIVE);
                    break;
                }
                case exclusive: {
                    this.setText(ViperMessages.OpenAccViewExclusive_Label);
                    this.setImageDescriptor(ViperImages.DESC_OPENACC_EXCLUSIVE);
                    this.setToolTipText(ViperMessages.OpenAccExclusive_Tooltip);
                    this.setId(SessionActionConstants.OPENACC_EXCLUSIVE);
                }
            }
        }

        public void run() {
            OpenAccView.this.totalTimeLabelContentProvider.setMode(this.mode);
            OpenAccView.this.tree.refresh();
        }
    }
}

