/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEStructEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSDataTypeSerial;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt2;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt3;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt4;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKeyColumn;
import org.jkiss.dbeaver.model.virtual.DBVException;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CSmartCombo;
import org.jkiss.dbeaver.ui.controls.ObjectContainerSelectorPanel;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.editors.object.internal.ObjectEditorMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorContentProvider;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilterObjectType;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class EditForeignKeyPage
extends BaseObjectEditPage {
    private static final String CONTAINER_LOGICAL_FK = "container.logical-fk";
    private static final Log log = Log.getLog(EditForeignKeyPage.class);
    private static final FKType FK_TYPE_PHYSICAL = new FKType("Physical", true);
    public static final FKType FK_TYPE_LOGICAL = new FKType("Logical", false);
    private static final String NEW_COLUMN_LABEL = "<new>";
    private static final String SELECT_COLUMN_LABEL = "<click>";
    private final DBSForeignKeyModifyRule[] supportedModifyRules;
    private final DBSEntityAssociation foreignKey;
    private final DBNModel navigatorModel;
    private DBSEntity curRefTable;
    private List<DBSEntityConstraint> curConstraints;
    private DBNDatabaseNode ownerTableNode;
    private DBNDatabaseNode ownerContainerNode;
    private DatabaseNavigatorTree tableList;
    private Combo uniqueKeyCombo;
    private Text fkNameText;
    private Table columnsTable;
    private Button customUKButton;
    private String fkName;
    private DBSEntityConstraint curConstraint;
    private List<? extends DBSEntityAttribute> ownAttributes;
    private List<DBSEntityAttribute> sourceAttributes;
    private List<DBSEntityAttribute> refAttributes;
    private final List<FKColumnInfo> fkColumns = new ArrayList<FKColumnInfo>();
    private DBSForeignKeyModifyRule onDeleteRule;
    private DBSForeignKeyModifyRule onUpdateRule;
    private boolean enableCustomKeys = false;
    private boolean supportsCustomName = false;
    private FKType[] allowedKeyTypes = new FKType[]{FK_TYPE_PHYSICAL};
    private FKType preferredKeyType = FK_TYPE_PHYSICAL;
    private FKType selectedKeyType = FK_TYPE_PHYSICAL;
    private final List<Control> physicalKeyComponents = new ArrayList<Control>();
    private Button columnOptionsButton;

    public EditForeignKeyPage(String title, DBSEntityAssociation foreignKey, DBSForeignKeyModifyRule[] supportedModifyRules, Map<String, Object> options) {
        super(title);
        DBSEntityConstraint refConstraint;
        this.navigatorModel = foreignKey.getDataSource().getContainer().getProject().getNavigatorModel();
        assert (this.navigatorModel != null);
        this.foreignKey = foreignKey;
        this.ownerTableNode = this.navigatorModel.findNode((DBSObject)foreignKey.getParentObject());
        this.supportedModifyRules = supportedModifyRules;
        if (this.ownerTableNode == null) {
            try {
                DBSEntity realEntity;
                if (foreignKey.getParentObject() instanceof DBVEntity && (realEntity = ((DBVEntity)foreignKey.getParentObject()).getRealEntity((DBRProgressMonitor)new VoidProgressMonitor())) != null) {
                    this.ownerTableNode = this.navigatorModel.getNodeByObject((DBSObject)realEntity);
                    if (this.ownerTableNode == null) {
                        try {
                            UIUtils.runInProgressDialog(monitor -> {
                                DBNDatabaseNode dBNDatabaseNode = this.ownerTableNode = this.navigatorModel.getNodeByObject(monitor, (DBSObject)realEntity, true);
                            });
                        }
                        catch (InvocationTargetException e) {
                            this.setErrorMessage(e.getTargetException().getMessage());
                            log.error((Object)e.getTargetException());
                        }
                    }
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        if (this.ownerTableNode != null) {
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)this.ownerTableNode.getNodeIcon()));
            this.setTitle(NLS.bind((String)ObjectEditorMessages.dialog_struct_edit_fk_title, (Object)title, (Object)this.ownerTableNode.getNodeDisplayName()));
        }
        if (!(foreignKey.getParentObject() instanceof DBVEntity) && (refConstraint = foreignKey.getReferencedConstraint()) != null) {
            this.curRefTable = refConstraint.getParentObject();
            this.curConstraint = refConstraint;
        }
        this.sourceAttributes = (List)options.get("ownAttributes");
    }

    public boolean isEnableCustomKeys() {
        return this.enableCustomKeys;
    }

    private void setEnableCustomKeys(boolean enableCustomKeys) {
        this.enableCustomKeys = enableCustomKeys;
    }

    private void setAllowedKeyTypes(FKType[] allowedKeyTypes) {
        this.allowedKeyTypes = allowedKeyTypes;
        this.setPreferredKeyType(allowedKeyTypes[0]);
    }

    private void setPreferredKeyType(FKType preferredKeyType) {
        this.preferredKeyType = preferredKeyType;
        this.selectedKeyType = preferredKeyType;
    }

    private void setRefTable(DBSEntity curRefTable) {
        this.curRefTable = curRefTable;
    }

    protected void addPhysicalKeyComponent(Control control) {
        this.physicalKeyComponents.add(control);
    }

    @Override
    public DBSObject getObject() {
        return this.foreignKey;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateControlsVisibility();
        if (this.curRefTable != null) {
            this.handleRefTableSelect();
        }
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.columnsTable, (boolean)true));
    }

    protected Composite createPageContents(Composite parent) {
        Composite panel = UIUtils.createComposite((Composite)parent, (int)1);
        panel.setLayoutData((Object)new GridData(1808));
        Composite tableGroup = UIUtils.createComposite((Composite)panel, (int)2);
        tableGroup.setLayoutData((Object)new GridData(768));
        UIUtils.createLabelText((Composite)tableGroup, (String)ObjectEditorMessages.dialog_struct_edit_fk_label_table, (String)DBUtils.getObjectFullName((DBPNamedObject)this.foreignKey.getParentObject(), (DBPEvaluationContext)DBPEvaluationContext.UI), (int)2056);
        if (this.allowedKeyTypes.length > 1) {
            UIUtils.createControlLabel((Composite)tableGroup, (String)ObjectEditorMessages.dialog_struct_edit_fk_label_key_type);
            Composite ktPanel = UIUtils.createFormPlaceholder((Composite)tableGroup, (int)this.allowedKeyTypes.length, (int)1);
            FKType[] fKTypeArray = this.allowedKeyTypes;
            int n = this.allowedKeyTypes.length;
            int n2 = 0;
            while (n2 < n) {
                FKType type = fKTypeArray[n2];
                Button keyTypeButton = UIUtils.createRadioButton((Composite)ktPanel, (String)type.getName(), (Object)type, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        EditForeignKeyPage.this.selectedKeyType = (FKType)e.widget.getData();
                        EditForeignKeyPage.this.updateControlsVisibility();
                    }
                });
                if (type == this.preferredKeyType) {
                    keyTypeButton.setSelection(true);
                }
                ++n2;
            }
        }
        if (this.curRefTable == null) {
            try {
                if (this.foreignKey instanceof DBVEntityForeignKey) {
                    this.createContainerSelector(tableGroup);
                } else if (this.ownerTableNode != null) {
                    this.createSchemaSelector(tableGroup);
                }
            }
            catch (Throwable e2) {
                log.debug((Object)"Can't create schema selector", e2);
            }
        } else {
            UIUtils.createLabelText((Composite)tableGroup, (String)ObjectEditorMessages.dialog_struct_edit_fk_label_ref_table, (String)DBUtils.getObjectFullName((DBPNamedObject)this.curRefTable, (DBPEvaluationContext)DBPEvaluationContext.UI), (int)2056);
        }
        if (this.curRefTable == null) {
            DBNNode dBNNode;
            DBNNode rootNode;
            DBNNode containerNode = this.ownerTableNode == null ? null : this.ownerTableNode.getParentNode();
            while (containerNode instanceof DBNDatabaseFolder) {
                containerNode = containerNode.getParentNode();
            }
            Object object = rootNode = containerNode == null ? this.navigatorModel.getRoot() : containerNode;
            if (rootNode instanceof DBNDatabaseNode) {
                DBNDatabaseNode dbNode = (DBNDatabaseNode)rootNode;
                dBNNode = this.getTablesNode(dbNode);
            } else {
                dBNNode = rootNode;
            }
            DBNNode tablesNode = dBNNode;
            UIUtils.createControlLabel((Composite)panel, (String)ObjectEditorMessages.dialog_struct_edit_fk_label_ref_table);
            this.tableList = new DatabaseNavigatorTree(panel, tablesNode, 67584, false, (INavigatorFilter)new DatabaseNavigatorTreeFilter()){

                @NotNull
                protected DatabaseNavigatorContentProvider createContentProvider(boolean showRoot) {
                    return new DatabaseNavigatorContentProvider(this, showRoot){

                        public boolean hasChildren(Object parent) {
                            DBNDatabaseNode dbnNode;
                            if (parent instanceof DBNDatabaseNode && (dbnNode = (DBNDatabaseNode)parent).getObject() instanceof DBSEntity) {
                                return false;
                            }
                            return super.hasChildren(parent);
                        }
                    };
                }
            };
            this.tableList.getViewer().addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    DBNDatabaseNode dbnNode;
                    return element instanceof DBNDatabaseNode && (dbnNode = (DBNDatabaseNode)element).getObject() instanceof DBSEntity;
                }
            });
            this.tableList.setFilterObjectType(DatabaseNavigatorTreeFilterObjectType.table);
            NavigatorUtils.createContextMenu(null, (Viewer)this.tableList.getViewer(), manager -> manager.add((IAction)new Action(UIMessages.ui_properties_tree_viewer_action_copy_name){

                public void run() {
                    Object firstElement = EditForeignKeyPage.this.tableList.getViewer().getStructuredSelection().getFirstElement();
                    if (firstElement instanceof DBNNode) {
                        DBNNode node = (DBNNode)firstElement;
                        UIUtils.setClipboardContents((Display)EditForeignKeyPage.this.getShell().getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)node.getNodeDisplayName());
                    }
                }
            }));
            GridData gd = new GridData(1808);
            gd.widthHint = 500;
            gd.heightHint = 150;
            this.tableList.setLayoutData((Object)gd);
            this.tableList.getViewer().addSelectionChangedListener(event -> this.handleRefTableSelect((DBNDatabaseNode)event.getStructuredSelection().getFirstElement()));
            if (tablesNode instanceof DBNDatabaseNode) {
                DBNDatabaseNode dbnNode = (DBNDatabaseNode)tablesNode;
                this.loadTableList(dbnNode);
            }
        }
        Composite pkGroup = UIUtils.createComposite((Composite)panel, (int)(this.enableCustomKeys ? 3 : 2));
        pkGroup.setLayoutData((Object)new GridData(768));
        this.uniqueKeyCombo = UIUtils.createLabelCombo((Composite)pkGroup, (String)ObjectEditorMessages.dialog_struct_edit_fk_combo_unik, (int)12);
        this.uniqueKeyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditForeignKeyPage.this.handleUniqueKeySelect();
                EditForeignKeyPage.this.updatePageState();
            }
        });
        if (this.enableCustomKeys) {
            this.customUKButton = UIUtils.createDialogButton((Composite)pkGroup, (String)ObjectEditorMessages.dialog_struct_edit_fk_custom_uk_button_create, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditForeignKeyPage.this.defineRefTableConstraint();
                }
            });
            this.customUKButton.setEnabled(false);
        }
        if (this.supportsCustomName()) {
            this.fkNameText = UIUtils.createLabelText((Composite)pkGroup, (String)ObjectEditorMessages.dialog_struct_edit_fk_name, (String)"");
            this.fkNameText.addModifyListener(e -> {
                String string = this.fkName = this.fkNameText.getText();
            });
        }
        UIUtils.createControlLabel((Composite)panel, (String)ObjectEditorMessages.dialog_struct_edit_fk_label_columns);
        this.columnsTable = new Table(panel, 67588);
        this.columnsTable.setHeaderVisible(true);
        this.columnsTable.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        gd.heightHint = 100;
        this.columnsTable.setLayoutData((Object)gd);
        UIUtils.createTableColumn((Table)this.columnsTable, (int)16384, (String)ObjectEditorMessages.dialog_struct_edit_fk_column_column);
        UIUtils.createTableColumn((Table)this.columnsTable, (int)16384, (String)ObjectEditorMessages.dialog_struct_edit_fk_column_col_type);
        UIUtils.createTableColumn((Table)this.columnsTable, (int)16384, (String)ObjectEditorMessages.dialog_struct_edit_fk_column_ref_col);
        UIUtils.createTableColumn((Table)this.columnsTable, (int)16384, (String)ObjectEditorMessages.dialog_struct_edit_fk_column_ref_col_type);
        TableEditor tableEditor = new TableEditor(this.columnsTable);
        tableEditor.horizontalAlignment = 0x1000000;
        tableEditor.verticalAlignment = 128;
        tableEditor.grabHorizontal = true;
        tableEditor.minimumWidth = 50;
        this.columnsTable.addMouseListener((MouseListener)new ColumnsMouseListener(tableEditor, this.columnsTable));
        this.columnsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean hasCustomColumn = false;
                FKColumnInfo fki = EditForeignKeyPage.this.getSelectedColumnInfo();
                if (fki != null && fki.ownColumn == null && fki.customName != null) {
                    hasCustomColumn = true;
                }
                EditForeignKeyPage.this.columnOptionsButton.setEnabled(hasCustomColumn);
            }
        });
        boolean supportModifyRules = !ArrayUtils.isEmpty((Object[])this.supportedModifyRules);
        Composite settingsPanel = UIUtils.createComposite((Composite)panel, (int)(supportModifyRules ? 2 : 1));
        settingsPanel.setLayoutData((Object)new GridData(768));
        if (supportModifyRules) {
            Composite cascadeGroup = UIUtils.createComposite((Composite)settingsPanel, (int)4);
            cascadeGroup.setLayoutData((Object)new GridData(768));
            final Combo onDeleteCombo = UIUtils.createLabelCombo((Composite)cascadeGroup, (String)ObjectEditorMessages.dialog_struct_edit_fk_combo_on_delete, (int)12);
            onDeleteCombo.setLayoutData((Object)new GridData(768));
            final Combo onUpdateCombo = UIUtils.createLabelCombo((Composite)cascadeGroup, (String)ObjectEditorMessages.dialog_struct_edit_fk_combo_on_update, (int)12);
            onUpdateCombo.setLayoutData((Object)new GridData(768));
            DBSForeignKeyModifyRule[] dBSForeignKeyModifyRuleArray = this.supportedModifyRules;
            int n = this.supportedModifyRules.length;
            int n3 = 0;
            while (n3 < n) {
                DBSForeignKeyModifyRule modifyRule = dBSForeignKeyModifyRuleArray[n3];
                onDeleteCombo.add(modifyRule.getName());
                onUpdateCombo.add(modifyRule.getName());
                ++n3;
            }
            onDeleteCombo.select(0);
            onUpdateCombo.select(0);
            this.onDeleteRule = this.onUpdateRule = this.supportedModifyRules[0];
            onDeleteCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditForeignKeyPage.this.onDeleteRule = EditForeignKeyPage.this.supportedModifyRules[onDeleteCombo.getSelectionIndex()];
                }
            });
            onUpdateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditForeignKeyPage.this.onUpdateRule = EditForeignKeyPage.this.supportedModifyRules[onUpdateCombo.getSelectionIndex()];
                }
            });
            this.addPhysicalKeyComponent((Control)cascadeGroup);
        }
        Composite columnGroup = UIUtils.createComposite((Composite)settingsPanel, (int)1);
        this.columnOptionsButton = UIUtils.createDialogButton((Composite)columnGroup, (String)"Column options ...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FKColumnInfo fki = EditForeignKeyPage.this.getSelectedColumnInfo();
                if (fki != null) {
                    EditForeignKeyPage.this.editColumnOptions(fki);
                }
            }
        });
        this.columnOptionsButton.setEnabled(false);
        if (this.tableList != null) {
            this.tableList.getViewer().getTree().setFocus();
        }
        this.setErrorMessage("Select reference table");
        return panel;
    }

    private void editColumnOptions(FKColumnInfo fkColumnInfo) {
        FKColumnOptionsDialog dialog = new FKColumnOptionsDialog(this.getShell(), fkColumnInfo);
        if (dialog.open() == 0) {
            fkColumnInfo.customName = dialog.columnName;
            fkColumnInfo.customNotNull = dialog.columnRequired;
            TableItem item = this.columnsTable.getSelection()[0];
            item.setText(0, "<" + fkColumnInfo.customName + ">");
        }
    }

    private FKColumnInfo getSelectedColumnInfo() {
        Object object;
        TableItem[] selection = this.columnsTable.getSelection();
        if (selection.length == 1 && (object = selection[0].getData()) instanceof FKColumnInfo) {
            FKColumnInfo fki = (FKColumnInfo)object;
            return fki;
        }
        return null;
    }

    private void updateControlsVisibility() {
        boolean pkVisible = this.selectedKeyType.isPhysical();
        for (Control pkc : this.physicalKeyComponents) {
            pkc.setVisible(pkVisible);
            if (!(pkc.getLayoutData() instanceof GridData)) continue;
            boolean bl = ((GridData)pkc.getLayoutData()).exclude = !pkVisible;
        }
        ((Composite)this.getControl()).layout(true, true);
    }

    private void defineRefTableConstraint() {
        if (this.curRefTable == null) {
            log.error((Object)"No reference table");
            return;
        }
        DBVEntity vRefEntity = DBVUtils.getVirtualEntity((DBSEntity)this.curRefTable, (boolean)true);
        assert (vRefEntity != null);
        DBVEntityConstraint constraint = vRefEntity.getBestIdentifier();
        EditConstraintPage page = new EditConstraintPage(ObjectEditorMessages.dialog_struct_edit_fk_page_title, (DBSEntityReferrer)constraint);
        if (page.edit()) {
            constraint.setAttributes(page.getSelectedAttributes());
            this.handleRefTableSelect(this.navigatorModel.getNodeByObject((DBSObject)this.curRefTable));
            int constraintIndex = this.curConstraints.indexOf(constraint);
            this.uniqueKeyCombo.select(constraintIndex);
            this.handleUniqueKeySelect();
        }
    }

    private void createSchemaSelector(Composite tableGroup) throws DBException {
        DBNDatabaseNode schemaContainerNode = null;
        DBNNode node = this.ownerTableNode.getParentNode();
        while (node != null) {
            DBSObject nodeObject;
            if (node instanceof DBNDatabaseNode && ((nodeObject = ((DBNDatabaseNode)node).getObject()) instanceof DBSSchema || nodeObject instanceof DBSCatalog) && node.getParentNode() instanceof DBNDatabaseNode) {
                schemaContainerNode = (DBNDatabaseNode)node.getParentNode();
                break;
            }
            node = node.getParentNode();
        }
        if (schemaContainerNode != null) {
            String nodeType;
            LabelProvider labelProvider = new LabelProvider(){

                public Image getImage(Object element) {
                    return DBeaverIcons.getImage((DBPImage)((DBNDatabaseNode)element).getNodeIcon());
                }

                public String getText(Object element) {
                    return ((DBNDatabaseNode)element).getNodeDisplayName();
                }
            };
            Label controlLabel = UIUtils.createControlLabel((Composite)tableGroup, (String)ObjectEditorMessages.edit_foreign_key_page_create_schema_container);
            final CSmartCombo schemaCombo = new CSmartCombo(tableGroup, 2048, (ILabelProvider)labelProvider);
            schemaCombo.setLayoutData((Object)new GridData(32));
            DBNDatabaseNode selectedNode = null;
            DBNDatabaseNode[] dBNDatabaseNodeArray = schemaContainerNode.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
            int n = dBNDatabaseNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBNDatabaseNode dbNode;
                DBNDatabaseNode node2 = dBNDatabaseNodeArray[n2];
                if (node2 instanceof DBNDatabaseNode && (dbNode = node2).getObject() instanceof DBSObjectContainer) {
                    schemaCombo.addItem((Object)dbNode);
                    if (dbNode.getObject() == this.foreignKey.getParentObject().getParentObject()) {
                        selectedNode = dbNode;
                    }
                }
                ++n2;
            }
            List allContainers = schemaCombo.getItems();
            if (!allContainers.isEmpty() && !CommonUtils.isEmpty((String)(nodeType = ((DBNDatabaseNode)allContainers.get(0)).getMeta().getNodeTypeLabel(this.foreignKey.getDataSource(), null)))) {
                controlLabel.setText(nodeType);
            }
            if (selectedNode != null) {
                schemaCombo.select(selectedNode);
            }
            schemaCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DBNDatabaseNode schemaNode = (DBNDatabaseNode)schemaCombo.getSelectedItem();
                    DBNDatabaseNode newContainerNode = EditForeignKeyPage.this.getTablesNode(schemaNode);
                    if (newContainerNode != null) {
                        EditForeignKeyPage.this.loadTableList(newContainerNode);
                    }
                }
            });
        }
    }

    @Nullable
    private DBNDatabaseNode getTablesNode(DBNDatabaseNode schemaNode) {
        DBNDatabaseNode newContainerNode = null;
        DBXTreeNode tableContainerMeta = ((DBNDatabaseNode)this.ownerTableNode.getParentNode()).getMeta();
        if (schemaNode.getMeta() == tableContainerMeta) {
            newContainerNode = schemaNode;
        } else {
            try {
                boolean found = false;
                DBNDatabaseNode[] dBNDatabaseNodeArray = schemaNode.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
                int n = dBNDatabaseNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DBNDatabaseNode child = dBNDatabaseNodeArray[n2];
                    if (child instanceof DBNDatabaseFolder) {
                        DBNDatabaseFolder dbNode = (DBNDatabaseFolder)child;
                        for (DBXTreeNode childItem : dbNode.getMeta().getChildren((DBNNode)child)) {
                            DBXTreeItem dbxItem;
                            Class childrenClass;
                            if (!(childItem instanceof DBXTreeItem) || (childrenClass = schemaNode.getChildrenClass(dbxItem = (DBXTreeItem)childItem)) == null || !DBSEntity.class.isAssignableFrom(childrenClass)) continue;
                            newContainerNode = dbNode;
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            catch (DBException e1) {
                log.debug((Object)e1);
            }
        }
        return newContainerNode;
    }

    private void createContainerSelector(Composite tableGroup) throws DBException {
        ObjectContainerSelectorPanel containerPanel = new ObjectContainerSelectorPanel(tableGroup, this.getOwnerProject(), CONTAINER_LOGICAL_FK, ObjectEditorMessages.edit_foreign_key_page_create_container_reference_table_container, ObjectEditorMessages.edit_foreign_key_page_create_container_select_reference_table_container){

            @Nullable
            protected DBNNode getSelectedNode() {
                Object containerObject;
                if (EditForeignKeyPage.this.ownerContainerNode != null) {
                    return EditForeignKeyPage.this.ownerContainerNode;
                }
                if (EditForeignKeyPage.this.ownerTableNode != null) {
                    DBNNode containerNode = EditForeignKeyPage.this.ownerTableNode.getParentNode();
                    while (containerNode instanceof DBNDatabaseFolder) {
                        containerNode = containerNode.getParentNode();
                    }
                    containerObject = containerNode instanceof DBNDatabaseNode ? ((DBNDatabaseNode)containerNode).getObject() : null;
                } else {
                    containerObject = EditForeignKeyPage.this.foreignKey.getParentObject();
                }
                EditForeignKeyPage.this.ownerContainerNode = EditForeignKeyPage.this.getNodeByContainerObject((DBSObject)containerObject);
                return EditForeignKeyPage.this.ownerContainerNode;
            }

            protected void setSelectedNode(DBNDatabaseNode node) {
                EditForeignKeyPage.this.ownerContainerNode = node;
                if (EditForeignKeyPage.this.ownerContainerNode == null) {
                    this.setContainerInfo(null);
                } else {
                    this.setContainerInfo(node);
                    DBNDatabaseNode tablesNode = EditForeignKeyPage.this.getTablesNode(EditForeignKeyPage.this.ownerContainerNode);
                    EditForeignKeyPage.this.loadTableList(tablesNode);
                }
            }
        };
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        containerPanel.setLayoutData((Object)gd);
        if (this.ownerTableNode != null) {
            DBNNode containerNode = this.ownerTableNode.getParentNode();
            while (containerNode instanceof DBNDatabaseFolder) {
                containerNode = containerNode.getParentNode();
            }
            if (containerNode instanceof DBNDatabaseNode) {
                containerPanel.setContainerInfo((DBNDatabaseNode)containerNode);
            }
        }
    }

    @Nullable
    private DBPProject getOwnerProject() {
        DBNDatabaseNode node;
        if (this.foreignKey != null && (node = this.getNodeByContainerObject((DBSObject)this.foreignKey.getParentObject())) != null) {
            return node.getOwnerProject();
        }
        if (this.ownerTableNode != null) {
            return this.ownerTableNode.getOwnerProject();
        }
        return null;
    }

    @Nullable
    private DBNDatabaseNode getNodeByContainerObject(@Nullable DBSObject containerObject) {
        if (containerObject != null && containerObject.getParentObject() instanceof DBSObjectContainer) {
            containerObject = containerObject.getParentObject();
        }
        if (containerObject instanceof DBVContainer) {
            try {
                containerObject = ((DBVContainer)containerObject).getRealContainer((DBRProgressMonitor)new VoidProgressMonitor());
            }
            catch (DBException e) {
                log.error((Object)"Error getting real object container", (Throwable)e);
            }
        }
        return this.navigatorModel.getNodeByObject(containerObject);
    }

    private void loadTableList(DBNDatabaseNode newContainerNode) {
        this.tableList.setInput((DBNNode)newContainerNode);
    }

    private void handleRefTableSelect(DBNDatabaseNode refTableNode) {
        if (refTableNode != null) {
            DBSObject object = refTableNode.getObject();
            if (object instanceof DBSEntity) {
                this.curRefTable = (DBSEntity)refTableNode.getObject();
            }
        } else {
            this.curRefTable = null;
        }
        this.handleRefTableSelect();
    }

    private void handleRefTableSelect() {
        this.uniqueKeyCombo.removeAll();
        try {
            this.curConstraints = new ArrayList<DBSEntityConstraint>();
            this.curConstraint = null;
            if (this.curRefTable != null) {
                DBSEntity refTable = this.curRefTable;
                UIUtils.runInProgressService(monitor -> {
                    try {
                        DBSTable dbsTable;
                        Collection indexes;
                        this.foreignKey.getParentObject().getAttributes(monitor);
                        refTable.getAttributes(monitor);
                        List constraints = DBVUtils.getAllConstraints((DBRProgressMonitor)monitor, (DBSEntity)refTable);
                        if (!CommonUtils.isEmpty((Collection)constraints)) {
                            for (DBSEntityConstraint constraint : constraints) {
                                if (!constraint.getConstraintType().isUnique() || !(constraint instanceof DBSEntityReferrer) || !this.isValidRefConstraint(monitor, (DBSEntityReferrer)constraint)) continue;
                                this.curConstraints.add(constraint);
                            }
                        }
                        if (refTable instanceof DBSTable && !CommonUtils.isEmpty((Collection)(indexes = (dbsTable = (DBSTable)refTable).getIndexes(monitor)))) {
                            for (DBSTableIndex index : indexes) {
                                if (!index.isUnique() || this.isConstraintIndex(monitor, this.curConstraints, index) || !this.isValidRefConstraint(monitor, (DBSEntityReferrer)index)) continue;
                                this.curConstraints.add((DBSEntityConstraint)index);
                            }
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                if (CommonUtils.isEmpty(this.curConstraints) && this.enableCustomKeys && !CommonUtils.isEmpty(this.refAttributes)) {
                    DBVEntity vRefEntity = DBVUtils.getVirtualEntity((DBSEntity)this.curRefTable, (boolean)true);
                    assert (vRefEntity != null);
                    DBVEntityConstraint vUniqueKey = new DBVEntityConstraint(vRefEntity, DBSEntityConstraintType.VIRTUAL_KEY, vRefEntity.getName() + "_VK");
                    for (DBSEntityAttribute refAttr : this.refAttributes) {
                        vUniqueKey.addAttribute(refAttr.getName());
                    }
                    if (!vRefEntity.addConstraint(vUniqueKey, true)) {
                        throw new DBVException("Virtual Unique Key with name '" + vUniqueKey.getName() + "' already exists");
                    }
                    this.curConstraints.add((DBSEntityConstraint)vUniqueKey);
                }
            }
            for (DBSEntityConstraint constraint : this.curConstraints) {
                this.uniqueKeyCombo.add(constraint.getName() + " (" + constraint.getConstraintType().getLocalizedName() + ")");
            }
            if (this.uniqueKeyCombo.getItemCount() == 0) {
                if (this.curRefTable == null) {
                    this.uniqueKeyCombo.add("<No reference table selected>");
                } else {
                    this.uniqueKeyCombo.add("<No unique keys in table '" + DBUtils.getObjectFullName((DBPNamedObject)this.curRefTable, (DBPEvaluationContext)DBPEvaluationContext.UI) + "'>");
                }
                this.uniqueKeyCombo.select(0);
                this.setErrorMessage(this.uniqueKeyCombo.getText());
                this.curConstraint = null;
            } else {
                this.uniqueKeyCombo.select(0);
                this.curConstraint = this.curConstraints.get(0);
            }
            if (this.enableCustomKeys) {
                this.enableCurConstraintEdit();
            }
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(ObjectEditorMessages.dialog_struct_edit_fk_error_load_constraints_title, ObjectEditorMessages.dialog_struct_edit_fk_error_load_constraints_message, e.getTargetException());
        }
        catch (DBVException e) {
            DBWorkbench.getPlatformUI().showError(ObjectEditorMessages.dialog_struct_edit_fk_error_load_constraints_title, ObjectEditorMessages.dialog_struct_edit_fk_error_load_constraints_message, (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        if (this.fkNameText != null) {
            String fkAutoName = SQLForeignKeyManager.generateConstraintName((DBSEntity)((DBSEntity)this.ownerTableNode.getObject()), (DBSEntityConstraint)this.curConstraint);
            this.fkNameText.setMessage(fkAutoName);
        }
        this.handleUniqueKeySelect();
        this.updatePageState();
    }

    private void enableCurConstraintEdit() {
        if (this.curConstraint instanceof DBVEntityConstraint) {
            this.customUKButton.setEnabled(true);
            this.customUKButton.setText("Edit");
            boolean hasLogicalConstraint = false;
            for (DBSEntityConstraint constraint : this.curConstraints) {
                if (!(constraint instanceof DBVEntityConstraint)) continue;
                hasLogicalConstraint = true;
                break;
            }
            this.customUKButton.setText("Create");
            this.customUKButton.setEnabled(!hasLogicalConstraint);
        }
    }

    private boolean isConstraintIndex(DBRProgressMonitor monitor, List<DBSEntityConstraint> constraints, DBSTableIndex index) throws DBException {
        List<DBSEntityAttribute> iAttrs = Objects.requireNonNull(index.getAttributeReferences(monitor)).stream().map(DBSEntityAttributeRef::getAttribute).toList();
        for (DBSEntityConstraint constraint : constraints) {
            DBSEntityReferrer referrer;
            List<DBSEntityAttribute> cAttrs;
            if (!(constraint instanceof DBSEntityReferrer) || !CommonUtils.equalObjects(iAttrs, cAttrs = Objects.requireNonNull((referrer = (DBSEntityReferrer)constraint).getAttributeReferences(monitor)).stream().map(DBSEntityAttributeRef::getAttribute).toList())) continue;
            return true;
        }
        return false;
    }

    private boolean isValidRefConstraint(DBRProgressMonitor monitor, DBSEntityReferrer constraint) throws DBException {
        if (!CommonUtils.isEmpty(this.refAttributes)) {
            for (DBSEntityAttribute refAttr : this.refAttributes) {
                if (DBUtils.getConstraintAttribute((DBRProgressMonitor)monitor, (DBSEntityReferrer)constraint, (DBSEntityAttribute)refAttr) != null) continue;
                return false;
            }
        }
        return true;
    }

    private void handleUniqueKeySelect() {
        this.fkColumns.clear();
        this.ownAttributes = null;
        this.columnsTable.removeAll();
        int ukSelectionIndex = this.uniqueKeyCombo.getSelectionIndex();
        if ((this.curConstraints.isEmpty() || ukSelectionIndex < 0) && !this.enableCustomKeys) {
            return;
        }
        if (ukSelectionIndex >= 0) {
            this.curConstraint = this.curConstraints.isEmpty() ? null : this.curConstraints.get(ukSelectionIndex);
        }
        DBSEntity curEntity = this.foreignKey.getParentObject();
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        try {
            List tmpColumns = curEntity.getAttributes((DBRProgressMonitor)monitor);
            ArrayList<DBSEntityAttribute> arrayList = this.ownAttributes = tmpColumns == null ? Collections.emptyList() : new ArrayList<DBSEntityAttribute>(EditForeignKeyPage.getValidAttributes(curEntity));
            if (this.curConstraint instanceof DBSEntityReferrer) {
                List attributeReferences = CommonUtils.safeList((List)((DBSEntityReferrer)this.curConstraint).getAttributeReferences((DBRProgressMonitor)monitor));
                int i = 0;
                while (i < attributeReferences.size()) {
                    DBSEntityAttributeRef pkColumn = (DBSEntityAttributeRef)attributeReferences.get(i);
                    DBSEntityAttribute pkAttribute = pkColumn.getAttribute();
                    if (pkAttribute == null) {
                        log.debug((Object)("Constraint " + this.curConstraint.getName() + " column attribute not found"));
                    } else {
                        FKColumnInfo fkColumnInfo = new FKColumnInfo(pkAttribute);
                        if (!CommonUtils.isEmpty(this.sourceAttributes) && this.sourceAttributes.size() > i) {
                            fkColumnInfo.ownColumn = this.sourceAttributes.get(i);
                        }
                        if (fkColumnInfo.ownColumn == null && !CommonUtils.isEmpty(this.ownAttributes)) {
                            for (DBSEntityAttribute dBSEntityAttribute : this.ownAttributes) {
                                if (!dBSEntityAttribute.getName().equals(pkAttribute.getName()) || curEntity == pkAttribute.getParentObject()) continue;
                                fkColumnInfo.ownColumn = dBSEntityAttribute;
                                break;
                            }
                        }
                        this.fkColumns.add(fkColumnInfo);
                        TableItem tableItem = new TableItem(this.columnsTable, 0);
                        if (fkColumnInfo.ownColumn != null) {
                            tableItem.setText(0, fkColumnInfo.ownColumn.getName());
                            tableItem.setImage(0, this.getColumnIcon(fkColumnInfo.ownColumn));
                            tableItem.setText(1, fkColumnInfo.ownColumn.getFullTypeName());
                        } else {
                            tableItem.setText(0, SELECT_COLUMN_LABEL);
                            tableItem.setText(1, "");
                        }
                        tableItem.setText(2, pkAttribute.getName());
                        tableItem.setImage(2, this.getColumnIcon(pkAttribute));
                        tableItem.setText(3, pkAttribute.getFullTypeName());
                        tableItem.setData((Object)fkColumnInfo);
                    }
                    ++i;
                }
            } else if (this.enableCustomKeys) {
                // empty if block
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError(ObjectEditorMessages.dialog_struct_edit_fk_error_load_constraint_columns_title, ObjectEditorMessages.dialog_struct_edit_fk_error_load_constraint_columns_message, (Throwable)e);
        }
        if (this.enableCustomKeys) {
            this.enableCurConstraintEdit();
        }
        this.verifyTableColumns();
        UIUtils.packColumns((Table)this.columnsTable, (boolean)true);
    }

    private void verifyTableColumns() {
        String errorMessage = null;
        TableItem[] tableItemArray = this.columnsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            FKColumnInfo fkColumnInfo = (FKColumnInfo)item.getData();
            if (fkColumnInfo.ownColumn == null && fkColumnInfo.customName == null) {
                errorMessage = "You have to specify column for '" + fkColumnInfo.refColumn.getName() + "'";
                break;
            }
            ++n2;
        }
        this.setErrorMessage(errorMessage);
    }

    private static List<DBSEntityAttribute> getValidAttributes(DBSEntity table) throws DBException {
        ArrayList<DBSEntityAttribute> result = new ArrayList<DBSEntityAttribute>();
        for (DBSEntityAttribute attr : CommonUtils.safeList((List)table.getAttributes((DBRProgressMonitor)new VoidProgressMonitor()))) {
            if (DBUtils.isHiddenObject((Object)attr) || DBUtils.isPseudoAttribute((DBSAttributeBase)attr)) continue;
            result.add(attr);
        }
        return result;
    }

    private Image getColumnIcon(DBSEntityAttribute column) {
        return DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)column));
    }

    @Override
    public boolean isPageComplete() {
        if (this.fkColumns.isEmpty()) {
            return false;
        }
        for (FKColumnInfo col : this.fkColumns) {
            if ((col.ownColumn != null || col.customName != null) && col.refColumn != null) continue;
            return false;
        }
        return true;
    }

    public List<FKColumnInfo> getColumns() {
        return this.fkColumns;
    }

    public DBSForeignKeyModifyRule getOnDeleteRule() {
        return this.onDeleteRule;
    }

    public DBSForeignKeyModifyRule getOnUpdateRule() {
        return this.onUpdateRule;
    }

    public DBSEntityConstraint getUniqueConstraint() {
        return this.curConstraint;
    }

    private void assignForeignKeyRefConstraint(FKColumnInfo fkInfo, CCombo columnsCombo, TableItem item) {
        int selectionIndex = columnsCombo.getSelectionIndex();
        if (selectionIndex == 0) {
            fkInfo.ownColumn = null;
            fkInfo.customName = fkInfo.refColumn.getName();
            item.setText(0, "<" + fkInfo.refColumn.getName() + ">");
            item.setImage(0, this.getColumnIcon(fkInfo.refColumn));
            item.setText(1, fkInfo.refColumn.getFullTypeName());
            this.columnOptionsButton.setEnabled(true);
        } else {
            fkInfo.ownColumn = this.ownAttributes.get(selectionIndex - 1);
            fkInfo.customName = null;
            item.setText(0, fkInfo.ownColumn.getName());
            item.setImage(0, this.getColumnIcon(fkInfo.ownColumn));
            item.setText(1, fkInfo.ownColumn.getFullTypeName());
            this.columnOptionsButton.setEnabled(false);
        }
        this.verifyTableColumns();
        this.updatePageState();
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return this.fkName;
    }

    protected boolean supportsCustomName() {
        return this.supportsCustomName;
    }

    public void setSupportsCustomName(boolean supportsCustomName) {
        this.supportsCustomName = supportsCustomName;
    }

    private void setSourceAttributes(Collection<? extends DBSEntityAttribute> srcAttributes) {
        this.sourceAttributes = CommonUtils.isEmpty(srcAttributes) ? null : new ArrayList<DBSEntityAttribute>(srcAttributes);
    }

    private void setReferenceAttributes(Collection<? extends DBSEntityAttribute> refAttributes) {
        this.refAttributes = CommonUtils.isEmpty(refAttributes) ? null : new ArrayList<DBSEntityAttribute>(refAttributes);
    }

    @Nullable
    public static DBVEntityForeignKey createVirtualForeignKey(@NotNull DBVEntity vEntity) {
        return EditForeignKeyPage.createVirtualForeignKey(vEntity, null, new FKType[]{FK_TYPE_LOGICAL}, null, null);
    }

    @Nullable
    public static DBVEntityForeignKey createVirtualForeignKey(@NotNull DBVEntity vEntity, @Nullable DBSEntity refEntity, @Nullable FKType[] allowedKeyTypes, @Nullable Collection<? extends DBSEntityAttribute> srcAttributes, @Nullable Collection<? extends DBSEntityAttribute> refAttributes) {
        DBVEntityForeignKey virtualFK = new DBVEntityForeignKey(vEntity);
        EditForeignKeyPage editDialog = new EditForeignKeyPage(ObjectEditorMessages.dialog_struct_edit_fk_virtual_page_title, (DBSEntityAssociation)virtualFK, new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION}, Collections.emptyMap());
        editDialog.setEnableCustomKeys(true);
        if (allowedKeyTypes != null) {
            editDialog.setAllowedKeyTypes(allowedKeyTypes);
        }
        if (refEntity != null) {
            editDialog.setRefTable(refEntity);
        }
        if (srcAttributes != null) {
            editDialog.setSourceAttributes(srcAttributes);
        }
        if (refAttributes != null) {
            editDialog.setReferenceAttributes(refAttributes);
        }
        if (!editDialog.edit()) {
            return null;
        }
        try {
            virtualFK.setReferencedConstraint((DBRProgressMonitor)new VoidProgressMonitor(), editDialog.getUniqueConstraint());
        }
        catch (DBException e1) {
            log.error((Object)e1);
            return null;
        }
        ArrayList<DBVEntityForeignKeyColumn> columns = new ArrayList<DBVEntityForeignKeyColumn>();
        for (FKColumnInfo tableColumn : editDialog.getColumns()) {
            Object ownColumn = tableColumn.getOwnColumn();
            if (ownColumn == null) {
                log.error((Object)"Own column not specified");
                continue;
            }
            columns.add(new DBVEntityForeignKeyColumn(virtualFK, ownColumn.getName(), tableColumn.getRefColumn().getName()));
        }
        virtualFK.setAttributes(columns);
        vEntity.addForeignKey(virtualFK);
        return virtualFK;
    }

    private class ColumnsMouseListener
    extends MouseAdapter {
        private final TableEditor tableEditor;
        private final Table columnsTable;

        ColumnsMouseListener(TableEditor tableEditor, Table columnsTable) {
            this.tableEditor = tableEditor;
            this.columnsTable = columnsTable;
        }

        private void disposeOldEditor() {
            Control oldEditor = this.tableEditor.getEditor();
            if (oldEditor != null) {
                oldEditor.dispose();
            }
        }

        public void mouseUp(MouseEvent e) {
            this.handleColumnClick(e);
        }

        private void handleColumnClick(MouseEvent e) {
            this.disposeOldEditor();
            final TableItem item = this.columnsTable.getItem(new Point(e.x, e.y));
            if (item == null) {
                return;
            }
            final FKColumnInfo fkInfo = (FKColumnInfo)item.getData();
            int columnIndex = UIUtils.getColumnAtPos((TableItem)item, (int)e.x, (int)e.y);
            if (fkInfo.ownColumn == null && columnIndex != 0) {
                return;
            }
            if (fkInfo.refColumn == null && columnIndex != 2) {
                return;
            }
            final CCombo columnsCombo = new CCombo((Composite)this.columnsTable, 12);
            columnsCombo.add(EditForeignKeyPage.NEW_COLUMN_LABEL);
            if (!CommonUtils.isEmpty(EditForeignKeyPage.this.ownAttributes)) {
                for (DBSEntityAttribute dBSEntityAttribute : EditForeignKeyPage.this.ownAttributes) {
                    columnsCombo.add(dBSEntityAttribute.getName());
                    if (fkInfo.ownColumn != dBSEntityAttribute) continue;
                    columnsCombo.select(columnsCombo.getItemCount() - 1);
                }
                if (columnsCombo.getSelectionIndex() < 0) {
                    columnsCombo.select(0);
                }
            }
            columnsCombo.setFocus();
            columnsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (columnsCombo.getSelectionIndex() >= 0) {
                        EditForeignKeyPage.this.assignForeignKeyRefConstraint(fkInfo, columnsCombo, item);
                    }
                }
            });
            columnsCombo.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (columnsCombo.getSelectionIndex() >= 0) {
                        EditForeignKeyPage.this.assignForeignKeyRefConstraint(fkInfo, columnsCombo, item);
                    }
                    ColumnsMouseListener.this.disposeOldEditor();
                }
            });
            this.tableEditor.setEditor((Control)columnsCombo, item, 0);
        }
    }

    public static class FKColumnInfo {
        final DBSEntityAttribute refColumn;
        DBSEntityAttribute ownColumn;
        private String customName;
        public boolean customNotNull;

        FKColumnInfo(DBSEntityAttribute refColumn) {
            this.refColumn = refColumn;
        }

        public <T extends DBSEntityAttribute> T getRefColumn() {
            return (T)this.refColumn;
        }

        public <T extends DBSEntityAttribute> T getOwnColumn() {
            return (T)this.ownColumn;
        }

        public <T extends DBSEntityAttribute> T getOrCreateOwnColumn(@NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @NotNull DBSEntity entity) throws DBException {
            if (this.ownColumn != null) {
                return (T)this.ownColumn;
            }
            if (CommonUtils.isEmpty((String)this.customName)) {
                throw new DBException("Custom column name not specified");
            }
            DBEStructEditor entityEditor = (DBEStructEditor)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(entity.getClass(), DBEStructEditor.class);
            if (entityEditor != null) {
                Class[] classArray = entityEditor.getChildTypes();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DBEObjectMaker objectManager;
                    Class childType = classArray[n2];
                    if (DBSEntityAttribute.class.isAssignableFrom(childType) && (objectManager = (DBEObjectMaker)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(childType, DBEObjectMaker.class)) != null) {
                        LinkedHashMap<String, Boolean> options = new LinkedHashMap<String, Boolean>();
                        options.put("skip.object.configuration", true);
                        DBSObject newColumn = objectManager.createNewObject(monitor, commandContext, (Object)entity, null, options);
                        if (newColumn instanceof DBSEntityAttribute) {
                            DBSEntityAttribute attr = (DBSEntityAttribute)newColumn;
                            this.setNewColumnDataType(newColumn);
                            if (newColumn instanceof DBPNamedObject2) {
                                DBPNamedObject2 no = (DBPNamedObject2)newColumn;
                                no.setName(this.customName);
                                this.ownColumn = attr;
                                return (T)attr;
                            }
                        }
                    }
                    ++n2;
                }
            }
            throw new DBException("Cannot create new column in table '" + DBUtils.getObjectFullName((DBPNamedObject)entity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "'");
        }

        /*
         * Enabled aggressive block sorting
         */
        private void setNewColumnDataType(DBSObject newColumn) throws DBException {
            if (newColumn instanceof DBSTypedObjectExt2) {
                DBSTypedObjectExt2 toe = (DBSTypedObjectExt2)newColumn;
                toe.setRequired(this.customNotNull);
                toe.setMaxLength(this.refColumn.getMaxLength());
                toe.setScale(this.refColumn.getScale());
                toe.setPrecision(this.refColumn.getPrecision());
            }
            if (this.refColumn == null) return;
            if (newColumn instanceof DBSTypedObjectExt4) {
                DBSTypedObjectExt4 toe4 = (DBSTypedObjectExt4)newColumn;
                DBSEntityAttribute dBSEntityAttribute = this.refColumn;
                if (dBSEntityAttribute instanceof DBSTypedObjectEx) {
                    DBSDataTypeSerial dts;
                    DBSTypedObjectEx refTO = (DBSTypedObjectEx)dBSEntityAttribute;
                    DBSDataType refDataType = refTO.getDataType();
                    if (refDataType instanceof DBSDataTypeSerial && (dts = (DBSDataTypeSerial)refDataType).isSerialDataType()) {
                        DBSDataType sbDataType = dts.getBaseDataType();
                        if (sbDataType == null) {
                            log.debug((Object)("Base data type for serial data type '" + dts.getFullTypeName() + "'"));
                        } else {
                            refDataType = sbDataType;
                        }
                    }
                    toe4.setDataType(refDataType);
                    return;
                }
            }
            if (newColumn instanceof DBSTypedObjectExt3) {
                DBSTypedObjectExt3 toe3 = (DBSTypedObjectExt3)newColumn;
                toe3.setFullTypeName(this.refColumn.getFullTypeName());
                return;
            }
            if (!(newColumn instanceof DBSTypedObjectExt2)) return;
            DBSTypedObjectExt2 toe = (DBSTypedObjectExt2)newColumn;
            toe.setTypeName(this.refColumn.getTypeName());
        }

        public String getCustomName() {
            return this.customName;
        }
    }

    private static class FKColumnOptionsDialog
    extends BaseDialog {
        private final FKColumnInfo fkColumnInfo;
        private String columnName;
        private boolean columnRequired;

        public FKColumnOptionsDialog(Shell parentShell, FKColumnInfo fkColumnInfo) {
            super(parentShell, "New column options", null);
            this.fkColumnInfo = fkColumnInfo;
            this.columnName = fkColumnInfo.getCustomName();
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            Group group = UIUtils.createControlGroup((Composite)composite, (String)"New column options", (int)2, (int)768, (int)300);
            Text columnNameText = UIUtils.createLabelText((Composite)group, (String)"Column name", (String)this.fkColumnInfo.getCustomName(), (int)2048);
            columnNameText.addModifyListener(e -> {
                String string = this.columnName = columnNameText.getText();
            });
            final Button notNullCheck = UIUtils.createCheckbox((Composite)group, (String)"Not Null", (String)"Make new column required", (boolean)false, (int)2);
            notNullCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    columnRequired = notNullCheck.getSelection();
                }
            });
            return composite;
        }
    }

    public static class FKType
    implements DBPNamedObject {
        private final String name;
        private final boolean physical;

        FKType(String name, boolean physical) {
            this.name = name;
            this.physical = physical;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public boolean isPhysical() {
            return this.physical;
        }
    }
}

