/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.plaf;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.plaf.metal.MetalInternalFrameUI;
import net.sf.freecol.client.gui.panel.FreeColBorder;

public class FreeColInternalFrameUI
extends MetalInternalFrameUI {
    public FreeColInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent b) {
        return new FreeColInternalFrameUI((JInternalFrame)b);
    }

    @Override
    protected MouseInputAdapter createBorderListener(JInternalFrame w) {
        return new FreeColBorderListener();
    }

    private final class FreeColBorderListener
    extends BasicInternalFrameUI.BorderListener {
        private boolean resizing;

        private FreeColBorderListener() {
            super(FreeColInternalFrameUI.this);
            this.resizing = false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.isOutOfBounds(e)) {
                this.handleOutOfBounds(e);
            } else {
                this.resizing = true;
                super.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.resizing && this.isOutOfBounds(e)) {
                this.handleOutOfBounds(e);
            } else {
                this.resizing = false;
                super.mouseReleased(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.resizing && this.isOutOfBounds(e)) {
                this.handleOutOfBounds(e);
            } else {
                super.mouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.resizing && this.isOutOfBounds(e)) {
                this.handleOutOfBounds(e);
            } else {
                super.mouseMoved(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!this.resizing && this.isOutOfBounds(e)) {
                this.handleOutOfBounds(e);
            } else {
                super.mouseClicked(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this.resizing && this.isOutOfBounds(e)) {
                this.handleOutOfBounds(e);
            } else {
                super.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.resizing && this.isOutOfBounds(e)) {
                this.handleOutOfBounds(e);
            } else {
                super.mouseExited(e);
            }
        }

        private void handleOutOfBounds(MouseEvent e) {
            this.resetCursor();
            if (FreeColInternalFrameUI.this.frame.getParent() == null) {
                return;
            }
            this.dispatchTo(e, FreeColInternalFrameUI.this.frame.getParent());
        }

        private void resetCursor() {
            Cursor lastCursor = FreeColInternalFrameUI.this.frame.getLastCursor();
            if (lastCursor == null) {
                lastCursor = Cursor.getPredefinedCursor(0);
            }
            FreeColInternalFrameUI.this.frame.setCursor(lastCursor);
        }

        private boolean isOutOfBounds(MouseEvent e) {
            Border border = FreeColInternalFrameUI.this.frame.getBorder();
            if (!(border instanceof FreeColBorder)) {
                return false;
            }
            List<Rectangle> bounds = ((FreeColBorder)border).getOpenSpace(FreeColInternalFrameUI.this.frame);
            return bounds.stream().anyMatch(b -> b.contains(e.getPoint()));
        }

        private void dispatchTo(MouseEvent e, Component target) {
            Component source = (Component)e.getSource();
            MouseEvent targetEvent = SwingUtilities.convertMouseEvent(source, e, target);
            target.dispatchEvent(targetEvent);
        }
    }
}

