/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterJson;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.AbstractExporterSettings;
import org.gephi.ui.exporter.plugin.UIExporterJsonPanel;
import org.openide.util.NbBundle;

public class UIExporterJson
implements ExporterUI {
    private final ExporterJsonSettings settings = new ExporterJsonSettings();
    private UIExporterJsonPanel panel;
    private ExporterJson exporterJson;

    public void setup(Exporter exporter) {
        this.exporterJson = (ExporterJson)exporter;
        this.settings.load(this.exporterJson);
        if (this.panel != null) {
            this.panel.setup(this.exporterJson);
        }
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterJson);
            this.settings.save(this.exporterJson);
        }
        this.panel = null;
        this.exporterJson = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterJsonPanel();
        return this.panel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterJson;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterJson.class, (String)"UIExporterJson.name");
    }

    private static class ExporterJsonSettings
    extends AbstractExporterSettings {
        private static final String NORMALIZE = "Json_normalize";
        private static final String EXPORT_COLORS = "Json_exportColors";
        private static final String EXPORT_POSITION = "Json_exportPosition";
        private static final String EXPORT_ATTRIBUTES = "Json_exportAttributes";
        private static final String EXPORT_SIZE = "Json_exportSize";
        private static final String EXPORT_DYNAMICS = "Json_exportDynamics";
        private static final String EXPORT_META = "Json_exportMeta";
        private static final String PRETTY_PRINT = "Json_prettyPrint";
        private static final String FORMAT = "Json_format";
        private static final ExporterJson DEFAULT = new ExporterJson();

        private ExporterJsonSettings() {
        }

        private void save(ExporterJson exporterJson) {
            this.put(NORMALIZE, exporterJson.isNormalize());
            this.put(EXPORT_COLORS, exporterJson.isExportColors());
            this.put(EXPORT_POSITION, exporterJson.isExportPosition());
            this.put(EXPORT_SIZE, exporterJson.isExportSize());
            this.put(EXPORT_ATTRIBUTES, exporterJson.isExportAttributes());
            this.put(EXPORT_DYNAMICS, exporterJson.isExportDynamic());
            this.put(EXPORT_META, exporterJson.isExportMeta());
            this.put(FORMAT, exporterJson.getFormat().name());
            this.put(PRETTY_PRINT, exporterJson.isPrettyPrint());
        }

        private void load(ExporterJson exporterJson) {
            exporterJson.setNormalize(this.get(NORMALIZE, DEFAULT.isNormalize()));
            exporterJson.setExportColors(this.get(EXPORT_COLORS, DEFAULT.isExportColors()));
            exporterJson.setExportAttributes(this.get(EXPORT_ATTRIBUTES, DEFAULT.isExportAttributes()));
            exporterJson.setExportPosition(this.get(EXPORT_POSITION, DEFAULT.isExportPosition()));
            exporterJson.setExportSize(this.get(EXPORT_SIZE, DEFAULT.isExportSize()));
            exporterJson.setExportDynamic(this.get(EXPORT_DYNAMICS, DEFAULT.isExportDynamic()));
            exporterJson.setExportMeta(this.get(EXPORT_META, DEFAULT.isExportMeta()));
            exporterJson.setFormat(ExporterJson.Format.valueOf((String)this.get(FORMAT, DEFAULT.getFormat().name())));
            exporterJson.setPrettyPrint(this.get(PRETTY_PRINT, DEFAULT.isPrettyPrint()));
        }
    }
}

