/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.attribute;

import java.util.ArrayList;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.Range;
import org.gephi.filters.plugin.AbstractAttributeFilter;
import org.gephi.filters.plugin.AbstractAttributeFilterBuilder;
import org.gephi.filters.plugin.attribute.AttributeEqualBuilder;
import org.gephi.filters.plugin.graph.RangeUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.RangeFilter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AttributeRangeBuilder
implements CategoryBuilder {
    private static final Category RANGE = new Category(NbBundle.getMessage(AttributeRangeBuilder.class, (String)"AttributeRangeBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    public Category getCategory() {
        return RANGE;
    }

    public FilterBuilder[] getBuilders(Workspace workspace) {
        ArrayList<AttributeRangeFilterBuilder> builders = new ArrayList<AttributeRangeFilterBuilder>();
        GraphModel am = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        ArrayList columns = new ArrayList();
        columns.addAll(am.getNodeTable().toList());
        columns.addAll(am.getEdgeTable().toList());
        for (Column c : columns) {
            if (c.isProperty() || c.isArray() || !AttributeUtils.isNumberType((Class)c.getTypeClass())) continue;
            AttributeRangeFilterBuilder b = new AttributeRangeFilterBuilder(c);
            builders.add(b);
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    public static abstract class AttributeRangeFilter<K extends Element>
    extends AbstractAttributeFilter<K>
    implements RangeFilter {
        private Range range;

        public AttributeRangeFilter(Column column) {
            super(NbBundle.getMessage(AttributeRangeBuilder.class, (String)"AttributeRangeBuilder.name"), column);
            this.addProperty(Range.class, "range");
        }

        public boolean init(Graph graph) {
            if (AttributeUtils.isNodeColumn((Column)this.column)) {
                return graph.getNodeCount() != 0;
            }
            if (AttributeUtils.isEdgeColumn((Column)this.column)) {
                return graph.getEdgeCount() != 0;
            }
            return true;
        }

        public boolean evaluate(Graph graph, Element element) {
            Object val = element.getAttribute(this.column, graph.getView());
            if (val != null) {
                return this.range.isInRange((Number)val);
            }
            return false;
        }

        public void finish() {
        }

        public Number[] getValues(Graph graph) {
            ArrayList<Number> vals = new ArrayList<Number>();
            if (AttributeUtils.isNodeColumn((Column)this.column)) {
                for (Element n : graph.getNodes()) {
                    Object val = n.getAttribute(this.column, graph.getView());
                    if (val == null) continue;
                    vals.add((Number)val);
                }
            } else {
                for (Element e : graph.getEdges()) {
                    Object val = e.getAttribute(this.column, graph.getView());
                    if (val == null) continue;
                    vals.add((Number)val);
                }
            }
            return vals.toArray(new Number[0]);
        }

        public FilterProperty getRangeProperty() {
            return this.getProperties()[1];
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range range) {
            this.range = range;
        }

        public static class Edge
        extends AttributeRangeFilter<org.gephi.graph.api.Edge>
        implements EdgeFilter {
            public Edge(Column column) {
                super(column);
            }
        }

        public static class Node
        extends AttributeRangeFilter<org.gephi.graph.api.Node>
        implements NodeFilter {
            public Node(Column column) {
                super(column);
            }
        }
    }

    private static class AttributeRangeFilterBuilder
    extends AbstractAttributeFilterBuilder {
        public AttributeRangeFilterBuilder(Column column) {
            super(column, RANGE, NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeRangeBuilder.description"), null);
        }

        public AttributeRangeFilter getFilter(Workspace workspace) {
            return AttributeUtils.isNodeColumn((Column)this.column) ? new AttributeRangeFilter.Node(this.column) : new AttributeRangeFilter.Edge(this.column);
        }

        public JPanel getPanel(Filter filter) {
            RangeUI ui = (RangeUI)Lookup.getDefault().lookup(RangeUI.class);
            if (ui != null) {
                return ui.getPanel((AttributeRangeFilter)filter);
            }
            return null;
        }
    }
}

